/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class DataFlowAnalyzer {
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final KotlinBuiltIns builtIns;
    private final SmartCastManager smartCastManager;

    public DataFlowAnalyzer(@NotNull Iterable<AdditionalTypeChecker> additionalTypeCheckers, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull KotlinBuiltIns builtIns, @NotNull SmartCastManager smartCastManager) {
        if (additionalTypeCheckers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalTypeCheckers", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        if (smartCastManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartCastManager", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "<init>"));
        }
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.builtIns = builtIns;
        this.smartCastManager = smartCastManager;
    }

    @NotNull
    public DataFlowInfo extractDataFlowInfoFromCondition(@Nullable JetExpression condition, final boolean conditionValue, final ExpressionTypingContext context) {
        if (condition == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        final Ref<Object> result2 = new Ref<Object>(null);
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull JetIsExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitIsExpression"));
                }
                if (conditionValue && !expression.isNegated() || !conditionValue && expression.isNegated()) {
                    result2.set(context.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitBinaryExpression"));
                }
                IElementType operationToken = expression.getOperationToken();
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
                    DataFlowInfo dataFlowInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expression.getLeft(), conditionValue, context);
                    JetExpression expressionRight = expression.getRight();
                    if (expressionRight != null) {
                        DataFlowInfo rightInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expressionRight, conditionValue, context);
                        boolean and = operationToken == JetTokens.ANDAND;
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set(dataFlowInfo);
                } else {
                    JetExpression left = expression.getLeft();
                    if (left == null) {
                        return;
                    }
                    JetExpression right = expression.getRight();
                    if (right == null) {
                        return;
                    }
                    JetType lhsType = context.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    JetType rhsType = context.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, lhsType, context);
                    DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rhsType, context);
                    Boolean equals = null;
                    if (operationToken == JetTokens.EQEQ || operationToken == JetTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == JetTokens.EXCLEQ || operationToken == JetTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            result2.set(context.dataFlowInfo.equate(leftValue, rightValue));
                        } else {
                            result2.set(context.dataFlowInfo.disequate(leftValue, rightValue));
                        }
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull JetUnaryExpression expression) {
                JetExpression baseExpression;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitUnaryExpression"));
                }
                IElementType operationTokenType = expression.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == JetTokens.EXCL && (baseExpression = expression.getBaseExpression()) != null) {
                    result2.set(DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context));
                }
            }

            @Override
            public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1", "visitParenthesizedExpression"));
                }
                JetExpression body = expression.getExpression();
                if (body != null) {
                    body.accept(this);
                }
            }
        });
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo.and(result2.get());
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "extractDataFlowInfoFromCondition"));
        }
        return dataFlowInfo;
    }

    @Nullable
    public JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        return this.checkType(expressionType, expression, context, null);
    }

    @NotNull
    public JetTypeInfo checkType(@NotNull JetTypeInfo typeInfo, @NotNull JetExpression expression, @NotNull ResolutionContext context) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(this.checkType(typeInfo.getType(), expression, context));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetType checkTypeInternal(@NotNull JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext c, @NotNull Ref<Boolean> hasError) {
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (hasError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasError", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || JetTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            JetType jetType = expressionType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return jetType;
        }
        if (expression instanceof JetConstantExpression) {
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression, c.trace, c.expectedType);
            boolean error = new CompileTimeConstantChecker(c.trace, true).checkConstantExpressionType(constantValue, (JetConstantExpression)expression, c.expectedType);
            if (hasError != null) {
                hasError.set(error);
            }
            JetType jetType = expressionType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return jetType;
        }
        if (expression instanceof JetWhenExpression) {
            JetType jetType = expressionType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return jetType;
        }
        JetType possibleType = this.checkPossibleCast(expressionType, expression, c);
        if (possibleType != null) {
            JetType jetType = possibleType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
            }
            return jetType;
        }
        c.trace.report(Errors.TYPE_MISMATCH.on(expression, c.expectedType, expressionType));
        if (hasError != null) {
            hasError.set(true);
        }
        JetType jetType = expressionType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkTypeInternal"));
        }
        return jetType;
    }

    @Nullable
    public JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkType"));
        }
        if (hasError == null) {
            hasError = Ref.create(false);
        } else {
            hasError.set(false);
        }
        JetExpression expression = JetPsiUtil.safeDeparenthesize(expressionToCheck, false);
        this.recordExpectedType(c.trace, expression, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        JetType result2 = this.checkTypeInternal(expressionType, expression, c, hasError);
        if (Boolean.FALSE.equals(hasError.get())) {
            for (AdditionalTypeChecker checker : this.additionalTypeCheckers) {
                checker.checkType(expression, expressionType, result2, c);
            }
        }
        return result2;
    }

    @Nullable
    public JetType checkPossibleCast(@NotNull JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext c) {
        if (expressionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkPossibleCast"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, expressionType, c);
        SmartCastResult result2 = this.smartCastManager.checkAndRecordPossibleCast(dataFlowValue, c.expectedType, expression, c, false);
        return result2 != null ? result2.getResultType() : null;
    }

    public void recordExpectedType(@NotNull BindingTrace trace, @NotNull JetExpression expression, @NotNull JetType expectedType) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "recordExpectedType"));
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            JetType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? this.builtIns.getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression, normalizeExpectedType);
        }
    }

    @Nullable
    public JetType checkStatementType(@NotNull JetExpression expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkStatementType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkStatementType"));
        }
        if (!(TypeUtils.noExpectedType(context.expectedType) || KotlinBuiltIns.isUnit(context.expectedType) || context.expectedType.isError())) {
            context.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return this.builtIns.getUnitType();
    }

    @Nullable
    public JetType checkImplicitCast(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ResolutionContext context, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (expressionType != null && context.expectedType == TypeUtils.NO_EXPECTED_TYPE && context.contextDependency == ContextDependency.INDEPENDENT && !isStatement && (KotlinBuiltIns.isUnit(expressionType) || KotlinBuiltIns.isAnyOrNullableAny(expressionType)) && !TypesPackage.isDynamic(expressionType)) {
            context.trace.report(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY.on(expression, expressionType));
        }
        return expressionType;
    }

    @NotNull
    public JetTypeInfo checkImplicitCast(@NotNull JetTypeInfo typeInfo, @NotNull JetExpression expression, @NotNull ResolutionContext context, boolean isStatement) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(this.checkImplicitCast(typeInfo.getType(), expression, context, isStatement));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "checkImplicitCast"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo illegalStatementType(@NotNull JetExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        facade.checkStatementType(expression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context.trace.report(Errors.EXPRESSION_EXPECTED.on(expression, expression));
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "illegalStatementType"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public Collection<JetType> getAllPossibleTypes(@NotNull JetExpression expression, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType type2, @NotNull ResolutionContext c) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, c);
        HashSet<JetType> possibleTypes = Sets.newHashSet(type2);
        if (dataFlowValue.isPredictable()) {
            possibleTypes.addAll(dataFlowInfo.getPossibleTypes(dataFlowValue));
        }
        HashSet<JetType> hashSet = possibleTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "getAllPossibleTypes"));
        }
        return hashSet;
    }

    @NotNull
    public JetTypeInfo createCheckedTypeInfo(@Nullable JetType type2, @NotNull ResolutionContext<?> context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = this.checkType(TypeInfoFactoryPackage.createTypeInfo(type2, context), expression, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCheckedTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context) {
        JetType expressionType;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        if (value instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value;
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                expressionType = integerValueTypeConstant.getType(context.expectedType);
                this.constantExpressionEvaluator.updateNumberType(expressionType, expression, context.statementFilter, context.trace);
            } else {
                expressionType = integerValueTypeConstant.getUnknownIntegerType();
            }
        } else {
            expressionType = ((TypedCompileTimeConstant)value).getType();
        }
        JetTypeInfo jetTypeInfo = this.createCheckedTypeInfo(expressionType, context, expression);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer", "createCompileTimeConstantTypeInfo"));
        }
        return jetTypeInfo;
    }
}

