/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitor;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.UtilsPackage;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    public static final String RETURN_NOT_ALLOWED_MESSAGE = "Return not allowed";

    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull LexicalScope scope2, @Nullable JetExpression condition, ExpressionTypingContext context) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        if (condition != null) {
            JetTypeInfo typeInfo = this.facade.getTypeInfo(condition, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope2)).replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT));
            JetType conditionType = typeInfo.getType();
            if (conditionType != null && !this.components.builtIns.isBooleanOrSubtype(conditionType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition, conditionType));
            }
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        return dataFlowInfo;
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitIfExpression"));
        }
        return this.visitIfExpression(expression, context, false);
    }

    public JetTypeInfo visitIfExpression(JetIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression elseBranch = ifExpression.getElse();
        JetExpression thenBranch = ifExpression.getThen();
        LexicalWritableScope thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Then scope");
        LexicalWritableScope elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Else scope");
        DataFlowInfo thenInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                JetTypeInfo result2 = this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression, isStatement);
                return result2.getJumpOutPossible() ? result2.replaceJumpOutPossible(true).replaceJumpFlowInfo(conditionDataFlowInfo) : result2;
            }
            return TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkImplicitCast(this.components.builtIns.getUnitType(), (JetExpression)ifExpression, (ResolutionContext)contextWithExpectedType, isStatement), thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression, isStatement);
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(ifExpression);
        JetBlockExpression thenBlock = psiFactory.wrapInABlockWrapper(thenBranch);
        JetBlockExpression elseBlock = psiFactory.wrapInABlockWrapper(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, "If", Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), contextWithExpectedType, dataFlowInfoForArguments);
        BindingContext bindingContext = context.trace.getBindingContext();
        JetTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, bindingContext);
        JetTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, bindingContext);
        assert (thenTypeInfo != null) : "'Then' branch of if expression  was not processed: " + ifExpression;
        assert (elseTypeInfo != null) : "'Else' branch of if expression  was not processed: " + ifExpression;
        boolean loopBreakContinuePossible = thenTypeInfo.getJumpOutPossible() || elseTypeInfo.getJumpOutPossible();
        JetType thenType = thenTypeInfo.getType();
        JetType elseType = elseTypeInfo.getType();
        DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
        DataFlowInfo resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
        JetType resultType = resolvedCall.getResultingDescriptor().getReturnType();
        return TypeInfoFactoryPackage.createTypeInfo(this.components.dataFlowAnalyzer.checkImplicitCast(resultType, (JetExpression)ifExpression, (ResolutionContext)contextWithExpectedType, isStatement), resultDataFlowInfo, loopBreakContinuePossible, conditionDataFlowInfo);
    }

    @NotNull
    private JetTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull JetExpression presentBranch, @NotNull LexicalWritableScope presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context, @NotNull JetIfExpression ifExpression, boolean isStatement) {
        if (presentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentBranch", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentScope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        JetType type2 = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type2 != null && KotlinBuiltIns.isNothing(type2) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        JetTypeInfo jetTypeInfo = this.components.dataFlowAnalyzer.checkImplicitCast(this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getUnitType()), (JetExpression)ifExpression, (ResolutionContext)context), (JetExpression)ifExpression, (ResolutionContext)context, isStatement).replaceDataFlowInfo(dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitWhileExpression"));
        }
        return this.visitWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        JetExpression condition = expression.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context.scope, condition, context);
        JetExpression body = expression.getBody();
        DataFlowInfo conditionInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(dataFlowInfo);
        if (body != null) {
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in while's condition");
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo));
        } else {
            bodyTypeInfo = TypeInfoFactoryPackage.noTypeInfo(conditionInfo);
        }
        if (!this.containsJumpOutOfLoop(expression, context)) {
            dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(dataFlowInfo);
        }
        if (body != null && JetPsiUtil.isTrueConstant(condition)) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo()));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (JetExpression)expression, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final JetLoopExpression loopExpression, final ExpressionTypingContext context) {
        final boolean[] result2 = new boolean[]{false};
        loopExpression.accept(new JetTreeVisitor<List<JetLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull JetBreakExpression breakExpression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (breakExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitBreakExpression"));
                }
                JetSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element == loopExpression || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == loopExpression) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull JetContinueExpression expression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitContinueExpression"));
                }
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                if (targetLabel != null && (element = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof JetLoopExpression && !outerLoops.contains(element)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull JetLoopExpression loopExpression2, List<JetLoopExpression> outerLoops) {
                if (loopExpression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitLoopExpression"));
                }
                ArrayList<JetLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression2);
                return (Void)super.visitLoopExpression(loopExpression2, newOuterLoops);
            }
        }, Lists.newArrayList(loopExpression));
        return result2[0];
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitDoWhileExpression"));
        }
        return this.visitDoWhileExpression(expression, context, false);
    }

    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetTypeInfo bodyTypeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression body = expression.getBody();
        LexicalScope conditionScope = context.scope;
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        if (body instanceof JetFunctionLiteralExpression) {
            bodyTypeInfo = this.facade.getTypeInfo(body, (ExpressionTypingContext)context.replaceScope(context.scope));
        } else if (body != null) {
            LexicalWritableScope writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
            conditionScope = writableScope;
            List<JetExpression> block = body instanceof JetBlockExpression ? ((JetBlockExpression)body).getStatements() : Collections.singletonList(body);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context);
        } else {
            bodyTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        }
        JetExpression condition = expression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition, context);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression, context) ? this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        if (body != null) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo()));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (JetExpression)expression, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitForExpression"));
        }
        return this.visitForExpression(expression, context, false);
    }

    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetTypeInfo loopRangeInfo;
        if (!isStatement) {
            return this.components.dataFlowAnalyzer.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        JetExpression loopRange = expression.getLoopRange();
        JetType expectedParameterType = null;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context.replaceScope(context.scope));
            loopRangeInfo = this.facade.getTypeInfo(loopRange, context);
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context);
            }
        } else {
            loopRangeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        }
        LexicalWritableScope loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope with for-loop index");
        JetParameter loopParameter = expression.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(loopParameter, variableDescriptor);
            loopScope.addVariableDescriptor(variableDescriptor);
        } else {
            JetMultiDeclaration multiParameter = expression.getMultiParameter();
            if (multiParameter != null && loopRange != null) {
                JetType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)loopScope, multiParameter.getModifierList(), context.trace);
                this.components.multiDeclarationResolver.defineLocalVariablesFromMultiDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
                this.components.modifiersChecker.withTrace(context.trace).checkModifiersForMultiDeclaration(multiParameter);
            }
        }
        JetExpression body = expression.getBody();
        JetTypeInfo bodyTypeInfo = body != null ? this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo())) : loopRangeInfo;
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (JetExpression)expression, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo());
    }

    private VariableDescriptor createLoopParameterDescriptor(JetParameter loopParameter, JetType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        this.components.modifiersChecker.withTrace(context.trace).checkParameterHasNoValOrVar(loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        JetTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, loopParameter, context.trace);
            JetType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context.trace, context.scope);
        }
        VariableDescriptor olderVariable = UtilsPackage.getLocalVariable(context.scope, variableDescriptor.getName());
        if (olderVariable != null && ExpressionTypingUtils.isLocal(context.scope.getOwnerDescriptor(), olderVariable)) {
            PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
        return variableDescriptor;
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext typingContext) {
        JetType type2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitTryExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        JetBlockExpression tryBlock = expression.getTryBlock();
        List<JetCatchClause> catchClauses = expression.getCatchClauses();
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        ArrayList<JetType> types2 = new ArrayList<JetType>();
        for (JetCatchClause catchClause : catchClauses) {
            JetParameter catchParameter = catchClause.getCatchParameter();
            JetExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            ModifiersChecker.ModifiersCheckingProcedure modifiersChecking = this.components.modifiersChecker.withTrace(context.trace);
            modifiersChecking.checkParameterHasNoValOrVar(catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
            ModifierCheckerCore.INSTANCE$.check(catchParameter, context.trace, null);
            VariableDescriptor variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, catchParameter, context.trace);
            JetType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.components.dataFlowAnalyzer.checkType(variableDescriptor.getType(), (JetExpression)catchParameter, (ResolutionContext)context.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            LexicalWritableScope catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Catch scope");
            catchScope.addVariableDescriptor(variableDescriptor);
            JetType type3 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
            if (type3 == null) continue;
            types2.add(type3);
        }
        JetTypeInfo result2 = TypeInfoFactoryPackage.noTypeInfo(context);
        if (finallyBlock != null) {
            result2 = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        }
        if ((type2 = this.facade.getTypeInfo(tryBlock, context).getType()) != null) {
            types2.add(type2);
        }
        if (types2.isEmpty()) {
            return result2.clearType();
        }
        return result2.replaceType(CommonSupertypes.commonSupertype(types2));
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        if (thrownExpression != null) {
            JetType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitReturnExpression"));
        }
        JetElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression, context);
        JetExpression returnedExpression = expression.getReturnedExpression();
        JetType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        JetType resultType = this.components.builtIns.getNothingType();
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration instanceof JetParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
        }
        if (expression.getTargetLabel() == null) {
            while (parentDeclaration instanceof JetMultiDeclaration) {
                parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)parentDeclaration, JetDeclaration.class);
            }
            assert (parentDeclaration != null) : "Can't find parent declaration for " + expression.getText();
            DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineUtil.checkNonLocalReturnUsage(containingFunctionDescriptor, expression, context.trace) || ControlStructureTypingVisitor.isClassInitializer(containingFunInfo)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (JetElement)containingFunInfo.getSecond(), context);
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        } else if (labelTargetElement != null) {
            SimpleFunctionDescriptor functionDescriptor = context.trace.get(BindingContext.FUNCTION, labelTargetElement);
            if (functionDescriptor != null) {
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context);
                if (!InlineUtil.checkNonLocalReturnUsage(functionDescriptor, expression, context.trace)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
            } else {
                context.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression, expression.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        } else if (!(expectedType == null || TypeUtils.noExpectedType(expectedType) || KotlinBuiltIns.isUnit(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType))) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression, expectedType));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private static boolean isClassInitializer(@NotNull Pair<FunctionDescriptor, PsiElement> containingFunInfo) {
        if (containingFunInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFunInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "isClassInitializer"));
        }
        return containingFunInfo.getFirst() instanceof ConstructorDescriptor && !(containingFunInfo.getSecond() instanceof JetSecondaryConstructor);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitBreakExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression).replaceJumpOutPossible(true);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitContinueExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression).replaceJumpOutPossible(true);
    }

    @NotNull
    private static JetType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor2, @NotNull JetElement function, @NotNull ExpressionTypingContext context) {
        JetType expectedType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function instanceof JetSecondaryConstructor) {
            expectedType = DescriptorUtilPackage.getBuiltIns(descriptor2).getUnitType();
        } else if (function instanceof JetFunction) {
            JetFunction jetFunction = (JetFunction)function;
            expectedType = context.trace.get(BindingContext.EXPECTED_RETURN_TYPE, jetFunction);
            if (expectedType == null && (jetFunction.getTypeReference() != null || jetFunction.hasBlockBody())) {
                expectedType = descriptor2.getReturnType();
            }
        } else {
            expectedType = descriptor2.getReturnType();
        }
        JetType jetType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        return jetType;
    }
}

