/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.CharsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"!\n)QB)\u0012$B+2#v\fU!D\u0017\u0006;UiX\"M\u0003N\u001bvLT!N\u000b*11\u000b\u001e:j]\u001eTaa[8uY&t'\u0002\u00026bm\u0006TA\u0001\\1oO*ir-\u001a;E\u000b\u001a\u000bU\u000b\u0014+`!\u0006\u001b5*Q$F?\u000ec\u0015iU*`\u001d\u0006kUIC\u0015L_Rd\u0017N\u001c&bm\u0006\u001c8M]5qiN+'/[1mSj,GMU3t_V\u00148-\u001a)bi\"\u001c8\n\u001e\u0006\u001e\t\u00163\u0015)\u0016'U?B\u000b5iS!H\u000b~kU\tV!G\u00132+uLT!N\u000b*\u0001s-\u001a;E\u000b\u001a\u000bU\u000b\u0014+`!\u0006\u001b5*Q$F?6+E+\u0011$J\u0019\u0016{f*Q'F\u0015e\u0001\u0016iQ&B\u000f\u0016{6\tT!T'~s\u0015)T#`'V3e)\u0013-\u000b9\u001d,G\u000fU!D\u0017\u0006;UiX\"M\u0003N\u001bvLT!N\u000b~\u001bVK\u0012$J1*A2-\u00199ji\u0006d\u0017N_3O_:,U\u000e\u001d;z'R\u0014\u0018N\\4\u000b\u0003MTQcZ3u!\u0006\u001c7.Y4f\u00072\f7o\u001d$r\u001d\u0006lWM\u0003\u0006qC\u000e\\\u0017mZ3G#:SaAR9OC6,'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0005]\u0006lWMC\nhKR\u0004\u0016mY6bO\u0016\u001cE.Y:t\u001d\u0006lWM\u0003\thKR\u0004\u0016mY6bO\u00164\u0015OT1nK*Aa-\u001b7f\u001d\u0006lWM\u0003\bhKR\u0004\u0016mY6bO\u0016t\u0015-\\3\u000b\u0011\u0019LG.\u001a)bi\"Ta#[:DY\u0006\u001c8/Z:J]B\u000b7m[1hK\u001aKG.\u001a\u0006\b\u0005>|G.Z1o\u0015aI7\u000fR3gCVdG\u000fU1dW\u0006<W-T3uC\u001aLG.\u001a\u0006\u0016SN\u0004\u0016mY6bO\u0016lU\r^1eCR\fg)\u001b7f\u0015EI7o\u0015;sS:<G+\u00192mK\u001aKG.\u001a\u0006\u0015SN\u0004\u0016mY6bO\u0016\u001cE.Y:t\rFt\u0015-\\3I\u0015\t\u0001\"A\u0003\u0004\t\u0001A\t\u0001\u0004\u0001\u0006\u0003!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0002\u0015\t\u0001\u0002C\u0003\u0003\t\u000bA\t\"\u0002\u0002\u0005\u0007!\tQA\u0001C\u0004\u0011%)1\u0001\u0002\u0003\t\u00101\u0001QA\u0001\u0003\u0005\u0011\u001f)1\u0001\u0002\u0001\t\u001a1\u0001Q1\u0005\u0003b)a\u0001\u0011eA\u0003\u0002\u0011\u0003A\n!V\u0002\t\u000b\r!\u0001!C\u0001\t\u00055\u0019AQA\u0005\u0002\u0011\tA6aAC\u0012\t\u0005$\u0002tA\u0011\u0004\u000b\u0005A\t\u0001'\u0001V\u0007!)1\u0001b\u0002\n\u0003!\u0011Qb\u0001\u0003\u0005\u0013\u0005A!\u0001W\u0002\u0004\u000bG!\u0011\r\u0006M\u0005C\r)\u0011\u0001#\u0001\u0019\u0002U\u001b\u0001\"B\u0002\u0005\n%\t\u0001BA\u0007\u0004\t\u0015I\u0011\u0001\u0003\u0002Y\u0007\r)i\u0003B\u0001\u0019\fu=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001#\u0001\u0019\u0002A\u001b\u0001!I\u0002\u0006\u0003!\u0005\u0001\u0014A)\u0004\u000b\u0011-\u0011\"\u0001\u0005\u0003\u001b\u0005A!\u0001W\u0002\u0004\u000b[!\u0011\u0001'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001\t3!B\u0001\t\na%\u0011kA\u0003\u0005\u000e%\t\u0001\"B\u0007\u0002\u0011\u0015A6aAC\u0017\t\u0005A\u001a\"h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001C\r)\u0011\u0001#\u0001\u0019\u0002E\u001bQ\u0001b\u0005\n\u0003!\u0011Q\"\u0001\u0005\u00061\u000e\u0019QQ\u0006\u0003\u00021)iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001E\u00011\u0003\u00016\u0001A\u0011\u0004\u000b\u0005AI\u0001'\u0003R\u0007\u0015!!\"C\u0001\t\u000b5\t\u0001B\u0001-\u0004\u0007\u00155B!\u0001\r\f;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001\u0012\u0001M\u0001!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0003A\n!U\u0002\u0006\t-I\u0011\u0001\u0003\u0002\u000e\u0003!\u0011\u0001lA\u0002\u0006.\u0011\u0019\u0001\u0004DO\b\t\u0001A)\"D\u0002\u0006\u0003!\u0005\u0001\u0014\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\u00061\u0017\t6!\u0002\u0003\r\u0013\u0005!\t!D\u0001\t\u0005a\u001b1!\"\f\u0005\u0007aiQt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0002a\u0005\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)A!D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0002Y\u0007\r)i\u0003B\u0002\u0019\u001cu=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001#\u0001\u0019\u0002A\u001b\u0001!I\u0002\u0006\u0003!-\u00014B)\u0004\u000b\u0011m\u0011\"\u0001C\u0001\u001b\u0005A!\u0001W\u0002\u0004\u000b[!1\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0001\t3!B\u0001\t\fa-\u0011kA\u0003\u0005\u001d%\tA\u0011A\u0007\u0002\u0011\tA6aA\u0003\u0013\t\r)2!B\u0001\t\na%\u0001TD\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007\u0015!i\"C\u0001\u0005\u00025\t\u0001\"\u0002-\u0004\u0007\u0001"})
public final class KotlinJavascriptSerializedResourcePathsKt {
    @NotNull
    static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    @NotNull
    static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";
    @NotNull
    static final String DEFAULT_PACKAGE_METAFILE_NAME = "_DefaultPackage.kjsm";

    @NotNull
    public static final String getPACKAGE_CLASS_NAME_SUFFIX() {
        return PACKAGE_CLASS_NAME_SUFFIX;
    }

    @NotNull
    public static final String getDEFAULT_PACKAGE_CLASS_NAME() {
        return DEFAULT_PACKAGE_CLASS_NAME;
    }

    @NotNull
    public static final String getDEFAULT_PACKAGE_METAFILE_NAME() {
        return DEFAULT_PACKAGE_METAFILE_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPackageClassFqName(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isRoot()) return false;
        FqName fqName2 = $receiver.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "this.parent()");
        if (!Intrinsics.areEqual(KotlinJavascriptSerializedResourcePathsKt.getPackageClassFqName(fqName2), $receiver)) return false;
        return true;
    }

    public static final boolean isDefaultPackageMetafile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(fileName, DEFAULT_PACKAGE_METAFILE_NAME);
    }

    public static final boolean isPackageMetadataFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isStringTableFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getStringTableFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isClassesInPackageFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getClassesInPackageFilePath(KotlinJavascriptSerializedResourcePathsKt.getPackageFqName(fileName)), fileName);
    }

    @NotNull
    public static final FqName getPackageFqName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return new FqName(KotlinJavascriptSerializedResourcePathsKt.getPackageName(fileName));
    }

    @NotNull
    public static final String getPackageName(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        return StringsKt.indexOf$default(filePath, '/', 0, false, 6) >= 0 ? StringsKt.replace$default(StringsKt.substringBeforeLast$default(filePath, '/', null, 2), '/', '.', false, 4) : "";
    }

    @NotNull
    public static final FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        Intrinsics.checkParameterIsNotNull(packageFQN, "packageFQN");
        FqName fqName2 = packageFQN.child(Name.identifier(KotlinJavascriptSerializedResourcePathsKt.getPackageClassName(packageFQN)));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFQN.child(Name.id\u2026geClassName(packageFQN)))");
        return fqName2;
    }

    @NotNull
    public static final String getPackageClassName(@NotNull FqName packageFQN) {
        String string;
        Intrinsics.checkParameterIsNotNull(packageFQN, "packageFQN");
        if (packageFQN.isRoot()) {
            string = DEFAULT_PACKAGE_CLASS_NAME;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = packageFQN.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageFQN.shortName().asString()");
            string = stringBuilder.append(KotlinJavascriptSerializedResourcePathsKt.capitalizeNonEmptyString(string2)).append(PACKAGE_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    @NotNull
    public static final String capitalizeNonEmptyString(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        return Character.isUpperCase(s.charAt(0)) ? s : CharsKt.plus(Character.toUpperCase(s.charAt(0)), StringsKt.substring(s, 1));
    }

    static {
        PACKAGE_CLASS_NAME_SUFFIX = PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_CLASS_NAME = "_Default" + PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_METAFILE_NAME = DEFAULT_PACKAGE_CLASS_NAME + "." + KotlinJavascriptSerializationUtil.INSTANCE$.getCLASS_METADATA_FILE_EXTENSION();
    }
}

