/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetObjectInfo;

public class JetClassInfoUtil {
    @NotNull
    public static JetClassLikeInfo createClassLikeInfo(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
        }
        if (classOrObject instanceof JetClass) {
            JetClassInfo jetClassInfo = new JetClassInfo((JetClass)classOrObject);
            if (jetClassInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
            }
            return jetClassInfo;
        }
        if (classOrObject instanceof JetObjectDeclaration) {
            JetObjectInfo jetObjectInfo = new JetObjectInfo((JetObjectDeclaration)classOrObject);
            if (jetObjectInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/JetClassInfoUtil", "createClassLikeInfo"));
            }
            return jetObjectInfo;
        }
        throw new IllegalArgumentException("Unknown declaration type: " + classOrObject + classOrObject.getText());
    }
}

