/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"j\u001a)Qb)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\rif\u0004XMU3t_24XM\u001d\u0006\r)f\u0004XMU3t_24XM\u001d\u0006\u0013I\u0016\u001c8M]5qi>\u0014(+Z:pYZ,'O\u0003\nEKN\u001c'/\u001b9u_J\u0014Vm]8mm\u0016\u0014(BE1o]>$\u0018\r^5p]J+7o\u001c7wKJT!#\u00118o_R\fG/[8o%\u0016\u001cx\u000e\u001c<fe*q1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014(BD*u_J\fw-Z'b]\u0006<WM\u001d\u0006\bgR|'/Y4f\u0015a)\u0007\u0010\u001d:fgNLwN\u001c+za&twmU3sm&\u001cWm\u001d\u0006\u0019\u000bb\u0004(/Z:tS>tG+\u001f9j]\u001e\u001cVM\u001d<jG\u0016\u001c(\"\u0002;za\u0016\u001c(bC3yaJ,7o]5p]NT\u0001BY;jYRLen\u001d\u0006\u000f\u0017>$H.\u001b8Ck&dG/\u00138t\u0015!\u0011W/\u001b7uS:\u001c(\u0002E7pI&4\u0017.\u001a:t\u0007\",7m[3s\u0015Aiu\u000eZ5gS\u0016\u00148o\u00115fG.,'OC\u000ede\u0016\fG/Z\"p]N$(/^2u_J$Um]2sSB$xN\u001d\u0006\u0006g\u000e|\u0007/\u001a\u0006\r\u0019\u0016D\u0018nY1m'\u000e|\u0007/\u001a\u0006\u0007g\u000e|\u0007/Z:\u000b\u001f\rd\u0017m]:EKN\u001c'/\u001b9u_JTqb\u00117bgN$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\u0005jgB\u0013\u0018.\\1ss*9!i\\8mK\u0006t'\u0002D7pI&4\u0017.\u001a:MSN$(b\u0004&fi6{G-\u001b4jKJd\u0015n\u001d;\u000b\u0007A\u001c\u0018N\u0003\neK\u000ed\u0017M]1uS>tGk\u001c+sC\u000e,'B\u0004&fi\u0012+7\r\\1sCRLwN\u001c\u0006\u000fif\u0004X\rU1sC6,G/\u001a:t\u0015\u0011a\u0015n\u001d;\u000b/QK\b/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(b\u0004<bYV,\u0007+\u0019:b[\u0016$XM]:\u000b\u0019)+G\u000fU1sC6,G/\u001a:\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b3\r{gn\u001d;sk\u000e$xN\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe&k\u0007\u000f\u001c\u0006\u0005S6\u0004HN\u0003\u0003kCZ\f'\u0002B;uS2Tqd\u0019:fCR,g+\u00197vKB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:t\u0015!1WO\\2uS>t'b\u0003&fi\u001a+hn\u0019;j_:T!CZ;oGRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*a2+[7qY\u00164UO\\2uS>tG)Z:de&\u0004Ho\u001c:J[Bd'BC5o]\u0016\u00148kY8qK*!B*\u001a=jG\u0006dwK]5uC\ndWmU2pa\u0016TA#\u001a=qK\u000e$X\r\u001a$v]\u000e$\u0018n\u001c8UsB,'b\u0002&fiRK\b/\u001a\u0006\u0019-\u0006dW/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(\"M5oSRL\u0017\r\\5{K\u001a+hn\u0019;j_:$Um]2sSB$xN]!oI\u0016C\b\u000f\\5dSR\u0014V\r^;s]RK\b/\u001a\u0006\u0015G>tG/Y5oS:<G)Z:de&\u0004Ho\u001c:\u000b+\u0011+7\r\\1sCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*!QK\\5u\u0015=Jg.\u001b;jC2L'0\u001a$v]\u000e$\u0018n\u001c8SKR,(O\u001c+za\u0016\u0014\u0015m]3e\u001f:4UO\\2uS>t'i\u001c3z\u0015AQU\r\u001e(b[\u0016$g)\u001e8di&|gN\u0003\u0007eCR\fg\t\\8x\u0013:4wN\u0003\u0007ECR\fg\t\\8x\u0013:4wNC\u0003dC2d7O\u0003\u0006t[\u0006\u0014HoY1tiNT\u0011D]3t_24XMR;oGRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*\u0019b-\u001e8di&|gnQ8ogR\u0014Xo\u0019;pe*Ia)\u001e8di&|g.\u000e\u0006\f\u0003:tw\u000e^1uS>t7OC\u0006b]:|G/\u0019;j_:\u001c(\u0002\u0002(b[\u0016TAA\\1nK*!1*\u001b8e\u0015a\u0019\u0015\r\u001c7bE2,W*Z7cKJ$Um]2sSB$xN\u001d\u0006\u000e'>,(oY3FY\u0016lWM\u001c;\u000b1MKW\u000e\u001d7f\rVt7\r^5p]\u0012+7o\u0019:jaR|'OC\u0002km6T\u0011BZ;oGRLwN\\:\u000bGI,7o\u001c7wK\u001a+hn\u0019;j_:,\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*\u0019#/Z:pYZ,\u0007K]5nCJL8i\u001c8tiJ,8\r^8s\t\u0016\u001c8M]5qi>\u0014(\u0002D2mCN\u001cX\t\\3nK:$(\u0002\u0005&fi\u000ec\u0017m]:Pe>\u0013'.Z2u\u0015\u0015\u0012Xm]8mm\u0016\u001cVmY8oI\u0006\u0014\u0018pQ8ogR\u0014Xo\u0019;pe\u0012+7o\u0019:jaR|'OC\u0006d_:\u001cHO];di>\u0014(b\u0006&fiN+7m\u001c8eCJL8i\u001c8tiJ,8\r^8s\u0015Y\u0011Xm]8mm\u00164\u0016\r\\;f!\u0006\u0014\u0018-\\3uKJ\u001c(B\u0005$v]\u000e$\u0018n\u001c8EKN\u001c'/\u001b9u_JTa\u0002]1sC6,G/\u001a:TG>\u0004XMC\ffqB,7\r^3e-\u0006dW/\u001a)be\u0006lW\r^3sg*!b-\u001e8di&|g\u000eV=qK\u0016C\b/Z2uK\u0012TqbZ3u%\u0016\u001cW-\u001b<feRK\b/\u001a\u0006\u0013O\u0016$h+\u00197vKB\u000b'/Y7fi\u0016\u00148OC\u0003po:,'\u000f2\u0003\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0003\r\u0001\u0015\u0019A1\u0001\u0005\u0006\u0019\u0001)1\u0001b\u0001\t\r1\u0001QA\u0001\u0003\u0002\u0011\u001f)1\u0001B\u0003\t\u000f1\u0001QA\u0001\u0003\u0002\u0011%)!\u0001\u0002\u0004\t\u0014\u0015\u0019AQ\u0002E\t\u0019\u0001)!\u0001B\u0001\t\u0017\u0015\u0019Aq\u0002E\u000b\u0019\u0001)1\u0001b\u0001\t\u00191\u0001QA\u0001C\u0002\u0011\u0011)!\u0001b\u0001\t\u000b\u0015\u0011A1\u0001\u0005\u0007\u000b\t!Q\u0001C\u0004\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001fA)\"\u0002\u0002\u0005\u0004!aQA\u0001C\u0002\u00119)1\u0001\"\u0007\t\u001c1\u0001QA\u0001\u0003\u0002\u0011?)1\u0001b\u0007\t\u001f1\u0001Qa\u0001C\u0003\u0011Ca\u0001!\u0002\u0002\u0005\u0003!\u0011Ra\u0001\u0003\u0010\u0011Ga\u0001!B\u0002\u0005\u001f!\u0019B\u0002A\u0003\u0004\t\u000bAA\u0003\u0004\u0001\u0006\u0007\u0011m\u0001\u0012\u0006\u0007\u0001\u000b\r!q\u0002c\u000b\r\u0001\u0015\u0019A1\u0001E\u0017\u0019\u0001)!\u0001b\u0007\t0\u0015\u0019AQ\u0005\u0005\u0018\u0019\u0001)!\u0001\"\n\t/\u0015\u0011A\u0011\u0004E\u000e\u000b\t!Y\u0002C\b\u0006\u0005\u0011y\u00012E\u0003\u0003\t=A1#B\u0001\t1\u0015\u0011AA\u0006E\u0019\u000b\t!i\u0003\u0003\u000b\u0006\u0005\u0011\r\u0001RF\u0003\u0004\t=A!\u0004\u0004\u0001\u0006\u0007\u0011\u0015\u0002b\u0007\u0007\u0001\u000b\r!I\u0002\u0003\u000f\r\u0001\u0015\u0019AA\u0002\u0005\u001e\u0019\u0001)1\u0001b\u0007\t<1\u0001QA\u0001\u0003\u0010\u0011i)!\u0001\"\n\t7\u0015\u0011A\u0011\u0004\u0005\u001d\u000b\t!a\u0001C\u000f\u0006\u0007\u0011m\u0001b\b\u0007\u0001\u000b\r!)\u0001c\u0010\r\u0001\u0015\u0011A1\u0004\u0005 \u000b\r!q\u0002#\u0011\r\u0001\u0015\u0011A1\u0001\u0005#\u000b\t!i\u0004#\u0012\u0006\u0007\u0011y\u00022\t\u0007\u0001\u000b\t!q\u0002#\u0011\u0006\u0005\u0011y\u00022I\u0003\u0004\t\u000bAA\u0005\u0004\u0001\u0006\u0005\u0011m\u0001\"J\u0003\u0004\t\u0007BI\u0005\u0004\u0001\u0006\u0005\u0011\t\u0001BJ\u0003\u0004\t\u000bBY\u0005\u0004\u0001\u0006\u0007\u0011m\u0001b\n\u0007\u0001\u000b\r!9\u0005#\u0014\r\u0001\u0015\u0019A1\u0004E(\u0019\u0001)1\u0001b\u0007\tQ1\u0001QA\u0001C\u000e\u0011!*!\u0001\"\u0002\tR\u0015\u0011AA\n\u0005*\u000b\t!i\u0005\u0003\u0013\u0006\u0007\u0011y\u0001b\u000b\u0007\u0001\u000b\t!q\u0002C\u0016\u0006\u0007\u0011y\u0001\u0012\f\u0007\u0001\u000b\t!q\u0002#\u0017\u0006\u0007\u0011m\u00012\f\u0007\u0001\u000b\t!Y\u0002c\u0017\u0005\u00071\u0011\u0011dA\u0003\u0002\u0011\rA2!\f\u0007\u0005C\u0012AZ!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011)iC\u0002B1\u00051)\t3!B\u0001\t\u0011aAQk\u0001\u0003\u0006\u0007\u0011Q\u0011\"\u0001E\f[1!\u0011\r\u0002M\u0005C\r)\u0011\u0001\u0003\u0003\u0019\tU\u001bA!B\u0002\u0005\n%\t\u00012C\u0017\r\t\u0005$\u0001\u0004C\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007\u0011)1\u0001\u0002\u0005\n\u0003!YQ\u0006\u0004\u0003b\ta]\u0011eA\u0003\u0002\u0011#A\n\"V\u0002\u0005\u000b\r!9\"C\u0001\t\u00195bA!\u0019\u0003\u0019\u000e\u0005\u001aQ!\u0001E\u00061\u0017)6\u0001B\u0003\u0004\t\u001bI\u0011\u0001#\u0006.\u0019\u0011\tG\u0001g\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000e!Qa\u0001C\u0004\u0013\u0005A\u0011\"lu\u0001\t\u0005AJ\"h\u0004\u0005\u0001!iQbA\u0003\u0002\u00115AR\u0002U\u0002\u0001;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001B\u0004\r\u000f!\u000e\u0005Qt\u0002\u0003\u0001\u0011Ai1!B\u0001\t\u001eau\u0001kA\u0001\u001e\u0012\u0011\u0001\u0001\"E\u0007\u0005\u000b\u0005Ay\u0002$\u0001\u0019 A\u001b\u0019!h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u0011AA\u0002\u0003U\u0002\u0003;3!\u0001\u0001c\n\u000e\u0011\u0015\t\u0001\u0012E\u0005\u0005\u0013\r)\u0011\u0001C\t\u0019#a\u0005\u0002k!\u0002\u001e\u001a\u0011\u0001\u0001\"F\u0007\t\u000b\u0005A\t#\u0003\u0003\n\u0007\u0015\t\u00012\u0005M\u00121C\u00016aAO\b\t\u0001Aa#D\u0002\u0006\u0003!\u0011\u0002D\u0005)\u0004\b\u0005\u001aQ!\u0001\u0005\u00141M\t6a\u0005C\r\u0013\u0005A9#D\u0001\t)5\t\u0001\u0012F\u0007\u0002\t\u0003i\u0011\u0001C\u000b\u000e\u0003!-R\"\u0001\u0005\u0018\u001b\u0005Aq#D\u0001\t05\"\r\u0001B\u0001\u00193u=A\u0001\u0001E\u001a\u001b\r)\u0011\u0001\u0003\r\u00191A\u001b\u0001!h\u0004\u0005\u0001!URbA\u0003\u0002\u0011cA\n\u0004UB\u0001;\u001f!\u0001\u0001c\u000e\u000e\u0007\u0015\t\u0001\"\u0007\r\u001a!\u000e\tQt\u0002\u0003\u0001\u0011Yi1!B\u0001\t%a\u0011\u0002ka\u0001\u001e\u0010\u0011\u0001\u0001\u0012H\u0007\u0004\u000b\u0005A\u0019\u0004g\rQ\u0007\t\t\u0003\"B\u0001\t\"%!\u0011bA\u0003\u0002\u0011iA\"\u0004'\tR\u00075!\u0011$C\u0001\t/5\t\u0001RG\u0007\u0002\u0011mi\u0011\u0001c\u000e\u000e\u0003!=R\"\u0001\u0005\u001d['\u0007Aa\u0001\r\u001f;\u001f!\u0001\u0001#\u0010\u000e\u0007\u0015\t\u0001\u0012\bM\u001d!\u000e\u0001Qt\u0002\u0003\u0001\u00115i1!B\u0001\t\u001bai\u0001k!\u0001\u001e\u0010\u0011\u0001\u00012G\u0007\u0004\u000b\u0005A\u0001\u0004\u0007\rQ\u0007\u0005iz\u0001\u0002\u0001\t65\u0019Q!\u0001E\u00191c\u000161AO\b\t\u0001Aa#D\u0002\u0006\u0003!\u0011\u0002D\u0005)\u0004\u0005u=A\u0001\u0001E\u001d\u001b\r)\u0011\u0001c\r\u00194A\u001b)!I\u0002\u0006\u0003!i\u0002$H)\u0004\u001f\u0011q\u0012\"\u0001\u0003\u0001\u001b\u0005AY$D\u0001\t)5\t\u0001RG\u0007\u0002\u0011mi\u0011\u0001c\f\u000e\u0003!aRf\u0010\u0003\u00021\u0001jz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001\u0005\u000e15\u00016\u0001AO\b\t\u0001A\u0019$D\u0002\u0006\u0003!q\u0002D\b)\u0004\u0002u=A\u0001\u0001E\u001b\u001b\r)\u0011\u0001#\r\u00192A\u001b\u0011!h\u0004\u0005\u0001!1RbA\u0003\u0002\u0011IA\"\u0003UB\u0002;\u001f!\u0001\u0001C\u0011\u000e\u0007\u0015\t\u0001r\bM !\u000e\u0011\u0011eA\u0003\u0002\u0011uAR$U\u0002\u000e\t\u0001J\u0011\u0001\u0002\u0001\u000e\u0003!!R\"\u0001\u0005!\u001b\u0005A1$D\u0001\t05\t\u0001\u0012I\u0017s\u0002\u0011\t\u0001dIO&\t\u0001A9%D\u0011\u0006\u0003!\t\u0013\u0002B\u0005\u0004\u000b\u0005AI\u0004'\u000f\n\t%\u0019Q!\u0001\u0005#1\tJA!C\u0002\u0006\u0003!\u0019\u0003dI\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0013\u0019I%!\u0011bA\u0003\u0002\u0011\u0013BJ%\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0007M\u00191\u0005\u00026\u0001AO\b\t\u0001Ai$D\u0002\u0006\u0003!e\u0002\u0014\b)\u0004\u0002u=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\u0011!h\u0004\u0005\u0001!MRbA\u0003\u0002\u0011yAb\u0004UB\u0002;\u001f!\u0001\u0001\u0003\f\u000e\u0007\u0015\t\u0001B\u0005\r\u0013!\u000e\u0011Qt\u0002\u0003\u0001\u0011\u0005j1!B\u0001\t@a}\u0002k!\u0002\u001e\u0010\u0011\u0001\u0001\u0012H\u0007\u0004\u000b\u0005A\u0019\u0004g\rQ\u0007\r\t3!B\u0001\tKa)\u0013kA\t\u0005G%\t\u00012J\u0007\u0002\u0011\u001dj\u0011\u0001c\u000f\u000e\u0003!!R\"\u0001\u0005!\u001b\u0005Ay#D\u0001\tB5\t\u0001\u0002H\u0017@\t\rA2%h\u0004\u0005\u0001!uRbA\u0003\u0002\u0011sAJ\u0004U\u0002\u0001;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001\"\u0004\r\u000e!\u000e\u0005Qt\u0002\u0003\u0001\u0011gi1!B\u0001\t=aq\u0002kA\u0001\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005A!\u0003\u0007\nQ\u0007\u0007iz\u0001\u0002\u0001\tC5\u0019Q!\u0001E 1\u007f\u00016AA\u0011\u0004\u000b\u0005AQ\u0005G\u0013R\u00075!1%C\u0001\tL5\t\u00012H\u0007\u0002\u0011Qi\u0011\u0001\u0003\u0011\u000e\u0003!=R\"\u0001E!['\u0007Aa\u0001M*;\u001f!\u0001\u0001#\u0010\u000e\u0007\u0015\t\u0001\u0012\bM\u001d!\u000e\u0001Qt\u0002\u0003\u0001\u00115i1!B\u0001\t\u001bai\u0001k!\u0001\u001e\u0010\u0011\u0001\u00012G\u0007\u0004\u000b\u0005Aa\u0004\u0007\u0010Q\u0007\u0005iz\u0001\u0002\u0001\t-5\u0019Q!\u0001\u0005\u00131I\u000161AO\b\t\u0001A\u0011%D\u0002\u0006\u0003!}\u0002t\b)\u0004\u0005u=A\u0001\u0001E\u001d\u001b\r)\u0011\u0001c\r\u00194A\u001b)!I\u0002\u0006\u0003!)\u0003$J)\u0004\u001f\u0011M\u0013\"\u0001E&\u001b\u0005AY$D\u0001\t)5\t\u0001\u0002I\u0007\u0002\u0011_i\u0011\u0001#\u0011\u000e\u0003!aR6\u000e\u0003\u00041)jz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001\u0005\u000e15\u00016\u0001AO\b\t\u0001Ai\"D\u0002\u0006\u0003!q\u0001D\u0004)\u0004\u0002u=A\u0001\u0001E+\u001b\r)\u0011\u0001c\u0014\u0019PA\u001b\u0011!h\u0004\u0005\u0001!1RbA\u0003\u0002\u0011IA\"\u0003UB\u0002C\u0011)\u0011\u0001C\n\r\u0002a\u0019\u0012kA\u0006\u0005U%\t\u0001rE\u0007\u0002\u0011Qi\u0011\u0001#\u000b\u000e\u0003!AS\"\u0001E\u0018[S\"1\u0001g\u0016\u001e\u0010\u0011\u0001\u0001\"D\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0001iz\u0001\u0002\u0001\t\u001e5\u0019Q!\u0001\u0005\u000f19\u00016\u0011AO\b\t\u0001AA&D\u0002\u0006\u0003!E\u0003\u0014\u000b)\u0004\u0003u=A\u0001\u0001\u0005\u0017\u001b\r)\u0011\u0001\u0003\n\u0019%A\u001b\u0019!I\u0002\u0006\u0003!\u0019\u0002dE)\u0004\u0017\u0011]\u0013\"\u0001E\u0014\u001b\u0005AA#D\u0001\t*5\t\u0001\"K\u0007\u0002\u0011_is\u001a\u0001\u0003\u000215jz\u0001\u0002\u0001\t65\u0019Q!\u0001E*1'\u00026\u0001AO\b\t\u0001Aa&D\u0002\u0006\u0003!I\u0002$\u0007)\u0004\u0002ueA\u0001\u0001\u0005\u0016\u001b!)\u0011\u0001#\t\n\t%\u0019Q!\u0001E\u00121GA\n\u0003U\u0002\u0002;\u001f!\u0001\u0001\u0003\f\u000e\u0007\u0015\t\u0001B\u0005\r\u0013!\u000e\rQ4\u0004\u0003\u0001\u0011;j\u0011\"B\u0001\t\"%!\u0011bA\u0003\u0002\u0011iA\"\u0004$\u0001\u0019\"A\u001b!!\t\u0005\u0006\u0003!\u0005\u0012\u0002B\u0005\u0004\u000b\u0005A!\u0004\u0007\u000e\u0019\"E\u001bQ\u0002B\u0017\n\u0003!9R\"\u0001\u0005+\u001b\u0005A9$D\u0001\t/5\t\u0001rF\u0007\u0002\u0011]i\u000b\u0003B\u0001\u0016\u0007\u0015\t\u00012\u0007M\u001a1=\n3!B\u0001\t\u001eau\u0011kA\u0003\u0005_%\tA\u0011A\u0007\u0002\u0011qi\u001b\u0003B\u0001\u0016\u0007\u0015\t\u00012\u0007M\u001a1?\nC!B\u0001\t41\u0005\u00014G)\u0004\u000b\u0011}\u0013\"\u0001\u0005\u001d\u001b\u0005AA$L\u0011\u0005\u0003U\u0019Q!\u0001E\u001a1gA\u0002'h\u0004\u0005\u0001!\u0005TbA\u0003\u0002\u0011'B\u001a\u0006UB\u0001C%)\u0011\u0001#\t\n\t%\u0019Q!\u0001\u0005\u001b1ia\t\u0001'\tR\u0007\u001d!\u0001'C\u0001\t/5\t\u0001\u0002H\u0007\u0002\u0011)*d\u001bACU\u0002\u0011\u0019\u000f\u0001G\u0002\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0011AO\b\t\u0001AY!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0003u=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0019!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001dAr\u0001U\u0002\u0003;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0015Qt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u0012aE\u0001kA\u0002\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e\tBaA\u0005\u0002\t\u0001i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005A)\"D\u0001\t\u00175\t\u0001rC\u0007\u0002\u00111\u0001"})
public final class FunctionDescriptorResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final TypeResolver typeResolver;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final ExpressionTypingServices expressionTypingServices;
    private final KotlinBuiltIns builtIns;
    private final ModifiersChecker modifiersChecker;

    static {
        $kotlinClass = Reflection.createKotlinClass(FunctionDescriptorResolver.class);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        if (function.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((JetFunction)((PsiElement)function)));
        }
        Function5 function5 = (Function5)((Object)Reflection.function(resolveFunctionDescriptor.1.INSTANCE$));
        JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(jetType, "TypeUtils.NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor(function5, containingDescriptor, scope2, function, trace, dataFlowInfo, jetType);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull JetNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedFunctionType) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        return this.resolveFunctionDescriptor((Function5)((Object)Reflection.function(resolveFunctionExpressionDescriptor.1.INSTANCE$)), containingDescriptor, scope2, function, trace, dataFlowInfo, expectedFunctionType);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, JetNamedFunction function, BindingTrace trace, DataFlowInfo dataFlowInfo, JetType expectedFunctionType) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function.getModifierList(), trace);
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotationResolver.resol\u2026getModifierList(), trace)");
        Name name = function.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull(name, "function.getNameAsSafeName()");
        SimpleFunctionDescriptorImpl functionDescriptor = functionConstructor.invoke(containingDescriptor, annotations2, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(function));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function, functionDescriptor, trace, expectedFunctionType);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function, functionDescriptor, trace, dataFlowInfo);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function, functionDescriptor);
        return functionDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, JetNamedFunction function, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        JetType jetType;
        void value;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl = function.getTypeReference() == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
            String message = "Return type must be initialized early for function: " + function.getText() + ", at: " + DiagnosticUtils.atLocation(function);
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        if (function.hasBlockBody()) {
            jetType = this.builtIns.getUnitType();
        } else if (function.hasBody()) {
            JetType jetType2 = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(this, trace, scope2, dataFlowInfo, function, functionDescriptor){
                final /* synthetic */ FunctionDescriptorResolver this$0;
                final /* synthetic */ BindingTrace $trace;
                final /* synthetic */ LexicalScope $scope;
                final /* synthetic */ DataFlowInfo $dataFlowInfo;
                final /* synthetic */ JetNamedFunction $function;
                final /* synthetic */ SimpleFunctionDescriptorImpl $functionDescriptor;

                @Nullable
                public final JetType invoke() {
                    JetType type2 = FunctionDescriptorResolver.access$getExpressionTypingServices$0(this.this$0).getBodyExpressionType(this.$trace, this.$scope, this.$dataFlowInfo, this.$function, this.$functionDescriptor);
                    return DescriptorResolver.transformAnonymousTypeIfNeeded(this.$functionDescriptor, this.$function, type2, this.$trace);
                }
                {
                    this.this$0 = functionDescriptorResolver;
                    this.$trace = bindingTrace;
                    this.$scope = lexicalScope;
                    this.$dataFlowInfo = dataFlowInfo;
                    this.$function = jetNamedFunction;
                    this.$functionDescriptor = simpleFunctionDescriptorImpl;
                    super(0);
                }
            });
            jetType = jetType2;
            Intrinsics.checkExpressionValueIsNotNull(jetType2, "DeferredType.createRecur\u2026ype, trace)\n            }");
        } else {
            JetType jetType3 = ErrorUtils.createErrorType("No type, no body");
            jetType = jetType3;
            Intrinsics.checkExpressionValueIsNotNull(jetType3, "ErrorUtils.createErrorType(\"No type, no body\")");
        }
        JetType returnType2 = jetType;
        functionDescriptor.setReturnType(returnType2);
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull JetFunction function, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull JetType expectedFunctionType) {
        Unit unit;
        JetType jetType;
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        LexicalWritableScope innerScope = new LexicalWritableScope(scope2, functionDescriptor, true, null, new TraceBasedRedeclarationHandler(trace), "Function descriptor header scope");
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2 = this.descriptorResolver.resolveTypeParametersForCallableDescriptor(functionDescriptor, innerScope, function.getTypeParameters(), trace);
        innerScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.descriptorResolver.resolveGenericBounds(function, functionDescriptor, innerScope, typeParameterDescriptors2, trace);
        JetTypeReference receiverTypeRef = function.getReceiverTypeReference();
        JetType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(innerScope, receiverTypeRef, trace, true) : this.getReceiverType(expectedFunctionType);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function, functionDescriptor, innerScope, trace, expectedFunctionType);
        innerScope.changeLockLevel(WritableScope.LockLevel.READING);
        JetTypeReference jetTypeReference = function.getTypeReference();
        if (jetTypeReference != null) {
            void $receiver;
            JetTypeReference jetTypeReference2 = jetTypeReference;
            JetTypeReference it2 = (JetTypeReference)$receiver;
            TypeResolver typeResolver = this.typeResolver;
            LexicalScope lexicalScope = innerScope;
            JetTypeReference jetTypeReference3 = it2;
            Intrinsics.checkExpressionValueIsNotNull(jetTypeReference3, "it");
            jetType = typeResolver.resolveType(lexicalScope, jetTypeReference3, trace, true);
        } else {
            jetType = null;
        }
        JetType returnType2 = jetType;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function, DescriptorResolver.getDefaultVisibility(function, containingDescriptor));
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(function, DescriptorResolver.getDefaultModality(containingDescriptor, visibility, function.hasBody()));
        functionDescriptor.initialize(receiverType, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDescriptor), typeParameterDescriptors2, (List)valueParameterDescriptors, returnType2, modality, visibility, function.hasModifier(JetTokens.OPERATOR_KEYWORD));
        JetType jetType2 = receiverType;
        if (jetType2 != null) {
            void $receiver;
            JetType jetType3 = jetType2;
            JetType it3 = (JetType)$receiver;
            ForceResolveUtil.forceResolveAllContents(it3.getAnnotations());
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final List<ValueParameterDescriptor> createValueParameterDescriptors(JetFunction function, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, JetType expectedFunctionType) {
        List<ValueParameterDescriptor> expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function instanceof JetFunctionLiteral && ((JetFunctionLiteral)function).getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.first(expectedValueParameters);
                ValueParameterDescriptorImpl it2 = new ValueParameterDescriptorImpl(functionDescriptor, null, 0, Annotations.Companion.getEMPTY(), Name.identifier("it"), valueParameterDescriptor.getType(), valueParameterDescriptor.declaresDefaultValue(), valueParameterDescriptor.getVarargElementType(), SourceElement.NO_SOURCE);
                trace.record(BindingContext.AUTO_CREATED_IT, it2);
                return CollectionsKt.listOf(it2);
            }
            if (function.getValueParameters().size() != expectedValueParameters.size()) {
                List<JetType> expectedParameterTypes = ExpressionTypingUtils.getValueParametersTypes(expectedValueParameters);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((JetFunction)((PsiElement)function), expectedParameterTypes.size(), expectedParameterTypes));
            }
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<JetParameter> list = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.getValueParameters()");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list, trace, expectedValueParameters);
    }

    private final boolean functionTypeExpected(JetType $receiver) {
        return !TypeUtils.noExpectedType($receiver) && KotlinBuiltIns.isFunctionOrExtensionFunctionType($receiver);
    }

    private final JetType getReceiverType(JetType $receiver) {
        return this.functionTypeExpected($receiver) ? KotlinBuiltIns.getReceiverType($receiver) : (JetType)null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(JetType $receiver, FunctionDescriptor owner) {
        return this.functionTypeExpected($receiver) ? KotlinBuiltIns.getValueParameters(owner, $receiver) : (List<ValueParameterDescriptor>)null;
    }

    @Nullable
    public final ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetClassOrObject classElement, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(classElement, "classElement");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_ENTRY) || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        JetModifierList jetModifierList = classElement.getPrimaryConstructorModifierList();
        JetPrimaryConstructor jetPrimaryConstructor = classElement.getPrimaryConstructor();
        JetDeclaration jetDeclaration = jetPrimaryConstructor != null ? (JetDeclaration)jetPrimaryConstructor : (JetDeclaration)classElement;
        List<TypeParameterDescriptor> list = classDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "classDescriptor.getTypeC\u2026tructor().getParameters()");
        return this.createConstructorDescriptor(scope2, classDescriptor, true, jetModifierList, jetDeclaration, list, classElement.getPrimaryConstructorParameters(), trace);
    }

    @NotNull
    public final ConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetSecondaryConstructor constructor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        JetModifierList jetModifierList = constructor.getModifierList();
        JetDeclaration jetDeclaration = constructor;
        List<TypeParameterDescriptor> list = classDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "classDescriptor.getTypeC\u2026tructor().getParameters()");
        List<JetParameter> list2 = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.getValueParameters()");
        return this.createConstructorDescriptor(scope2, classDescriptor, false, jetModifierList, jetDeclaration, list, list2, trace);
    }

    private final ConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor, boolean isPrimary, JetModifierList modifierList, JetDeclaration declarationToTrace, List<? extends TypeParameterDescriptor> typeParameters, List<? extends JetParameter> valueParameters, BindingTrace trace) {
        ConstructorDescriptorImpl constructorDescriptor = ConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        DeclarationDescriptor declarationDescriptor = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "constructorDescriptor");
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, declarationDescriptor, false, null, new TraceBasedRedeclarationHandler(trace), "Scope with value parameters of a constructor");
        parameterScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        FunctionDescriptor functionDescriptor = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "constructorDescriptor");
        ConstructorDescriptorImpl constructor = constructorDescriptor.initialize(typeParameters, this.resolveValueParameters(functionDescriptor, parameterScope, valueParameters, trace, null), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor)));
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters, trace);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructor;
        Intrinsics.checkExpressionValueIsNotNull(constructorDescriptorImpl, "constructor");
        return constructorDescriptorImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends JetParameter> valueParameters, BindingTrace trace, List<? extends ValueParameterDescriptor> expectedValueParameters) {
        int n;
        ArrayList<ValueParameterDescriptorImpl> result2 = new ArrayList<ValueParameterDescriptorImpl>();
        IntRange intRange = CollectionsKt.getIndices((Collection)valueParameters);
        int n2 = ((Number)intRange.getStart()).intValue();
        if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
            while (true) {
                JetType type2;
                JetType expectedType;
                void $receiver;
                List it2;
                void i;
                JetParameter valueParameter = valueParameters.get((int)i);
                JetTypeReference typeReference = valueParameter.getTypeReference();
                JetType jetType = expectedValueParameters != null ? (i < (it2 = (List)$receiver).size() ? ((ValueParameterDescriptor)it2.get((int)i)).getType() : (JetType)null) : (expectedType = null);
                if (typeReference != null) {
                    type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                    if (expectedType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.DEFAULT.isSubtypeOf(expectedType, type2)) {
                        trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((JetParameter)((PsiElement)valueParameter), expectedType));
                    }
                } else if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || DescriptorUtils.isFunctionExpression(functionDescriptor)) {
                    boolean containsUninferredParameter2 = TypeUtils.containsSpecialType(expectedType, resolveValueParameters.containsUninferredParameter.1.INSTANCE$);
                    if (expectedType == null || containsUninferredParameter2) {
                        trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((JetParameter)((PsiElement)valueParameter)));
                    }
                    if (expectedType != null) {
                        type2 = expectedType;
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull(TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE, "TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE");
                    }
                } else {
                    trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((JetParameter)((PsiElement)valueParameter)));
                    Intrinsics.checkExpressionValueIsNotNull(ErrorUtils.createErrorType("Type annotation was missing for parameter " + valueParameter.getNameAsSafeName()), "ErrorUtils.createErrorTy\u2026er.getNameAsSafeName()}\")");
                }
                if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                    void receiver;
                    boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                    ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = this.modifiersChecker.withTrace(trace);
                    ModifiersChecker.ModifiersCheckingProcedure $receiver2 = (ModifiersChecker.ModifiersCheckingProcedure)receiver;
                    $receiver2.checkParameterHasNoValOrVar(valueParameter, isConstructor ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, (int)i, type2, trace);
                VariableDescriptor variableDescriptor = valueParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "valueParameterDescriptor");
                parameterScope.addVariableDescriptor(variableDescriptor);
                result2.add(valueParameterDescriptor);
                if (i == n) break;
                ++i;
            }
        }
        return result2;
    }

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull StorageManager storageManager, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker) {
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.storageManager = storageManager;
        this.expressionTypingServices = expressionTypingServices;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
    }

    @NotNull
    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$0(FunctionDescriptorResolver $this) {
        return $this.expressionTypingServices;
    }
}

