/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;

public class JsConstructExpressionVisitor
extends RecursiveJsVisitor {
    private boolean containsInvocation;

    public static boolean exec(JsExpression expression) {
        if (JsPrecedenceVisitor.exec(expression) < 15) {
            return true;
        }
        JsConstructExpressionVisitor visitor2 = new JsConstructExpressionVisitor();
        visitor2.accept(expression);
        return visitor2.containsInvocation;
    }

    private JsConstructExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitArrayAccess"));
        }
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitArray"));
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitFunction"));
        }
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitInvocation"));
        }
        this.containsInvocation = true;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitNameRef"));
        }
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitNew"));
        }
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/JsConstructExpressionVisitor", "visitObjectLiteral"));
        }
    }

    @Override
    public <T extends JsNode> void accept(T node) {
        JsExpression expression;
        int precedence;
        if (node instanceof JsExpression && (precedence = JsPrecedenceVisitor.exec(expression = (JsExpression)node)) < 15) {
            return;
        }
        super.accept(node);
    }
}

