/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.common.collect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableSet;
import org.jetbrains.kotlin.relocated.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.relocated.com.google.common.collect.DescendingImmutableSortedSet;
import org.jetbrains.kotlin.relocated.com.google.common.collect.EmptyImmutableSortedSet;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ImmutableSortedSetFauxverideShim;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Iterables;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.relocated.com.google.common.collect.ObjectArrays;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Ordering;
import org.jetbrains.kotlin.relocated.com.google.common.collect.RegularImmutableSortedSet;
import org.jetbrains.kotlin.relocated.com.google.common.collect.SortedIterable;
import org.jetbrains.kotlin.relocated.com.google.common.collect.SortedIterables;
import org.jetbrains.kotlin.relocated.com.google.common.collect.UnmodifiableIterator;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Comparable>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;
    transient ImmutableSortedSet<E> descendingSet;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator2) {
        if (NATURAL_ORDER.equals(comparator2)) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator2, Iterable<? extends E> elements) {
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator2);
        boolean hasSameComparator = SortedIterables.hasSameComparator(comparator2, elements);
        if (hasSameComparator && elements instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements).isPartialView()) {
            return original;
        }
        Object[] array = Iterables.toArray(elements);
        return ImmutableSortedSet.construct(comparator2, array.length, array);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator2, Collection<? extends E> elements) {
        return ImmutableSortedSet.copyOf(comparator2, elements);
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator2, int n, E ... contents) {
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator2);
        }
        ObjectArrays.checkElementsNotNull((Object[])contents, n);
        Arrays.sort(contents, 0, n, comparator2);
        int uniques = 1;
        for (int i = 1; i < n; ++i) {
            E cur = contents[i];
            E prev = contents[uniques - 1];
            if (comparator2.compare(cur, prev) == 0) continue;
            contents[uniques++] = cur;
        }
        Arrays.fill(contents, uniques, n, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(contents, uniques), comparator2);
    }

    int unsafeCompare(Object a, Object b) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, a, b);
    }

    static int unsafeCompare(Comparator<?> comparator2, Object a, Object b) {
        Comparator<?> unsafeComparator = comparator2;
        return unsafeComparator.compare(a, b);
    }

    ImmutableSortedSet(Comparator<? super E> comparator2) {
        this.comparator = comparator2;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement), inclusive);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSet((Object)fromElement, true);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    public E lower(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, false)).descendingIterator(), null);
    }

    @Override
    public E floor(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, true)).descendingIterator(), null);
    }

    @Override
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, true), null);
    }

    @Override
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result2 = this.descendingSet;
        if (result2 == null) {
            result2 = this.descendingSet = this.createDescendingSet();
            result2.descendingSet = this;
        }
        return result2;
    }

    ImmutableSortedSet<E> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(Object var1);
}

