/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.JetElementImpl;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetValueArgumentList
extends JetElementImpl {
    public JetValueArgumentList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetValueArgumentList", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetValueArgumentList", "accept"));
        }
        return visitor2.visitValueArgumentList(this, data2);
    }

    @NotNull
    public List<JetValueArgument> getArguments() {
        List<JetValueArgument> list = this.findChildrenByType(JetNodeTypes.VALUE_ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetValueArgumentList", "getArguments"));
        }
        return list;
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(JetTokens.RPAR);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(JetTokens.LPAR);
    }

    @NotNull
    public JetValueArgument addArgument(@NotNull JetValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgument"));
        }
        JetValueArgument jetValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItem(this, this.getArguments(), argument);
        if (jetValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgument"));
        }
        return jetValueArgument;
    }

    @NotNull
    public JetValueArgument addArgumentAfter(@NotNull JetValueArgument argument, @Nullable JetValueArgument anchor2) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgumentAfter"));
        }
        JetValueArgument jetValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItemAfter(this, this.getArguments(), argument, anchor2);
        if (jetValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgumentAfter"));
        }
        return jetValueArgument;
    }

    @NotNull
    public JetValueArgument addArgumentBefore(@NotNull JetValueArgument argument, @Nullable JetValueArgument anchor2) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgumentBefore"));
        }
        JetValueArgument jetValueArgument = EditCommaSeparatedListHelper.INSTANCE$.addItemBefore(this, this.getArguments(), argument, anchor2);
        if (jetValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetValueArgumentList", "addArgumentBefore"));
        }
        return jetValueArgument;
    }

    public void removeArgument(@NotNull JetValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/psi/JetValueArgumentList", "removeArgument"));
        }
        assert (argument.getParent() == this);
        EditCommaSeparatedListHelper.INSTANCE$.removeItem(argument);
    }
}

