/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.lexer;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.JetSingleValueToken;

public class JetKeywordToken
extends JetSingleValueToken {
    private final boolean myIsSoft;

    public static JetKeywordToken keyword(String value) {
        return JetKeywordToken.keyword(value, value);
    }

    public static JetKeywordToken keyword(String debugName, String value) {
        return new JetKeywordToken(debugName, value, false);
    }

    public static JetKeywordToken softKeyword(String value) {
        return new JetKeywordToken(value, value, true);
    }

    protected JetKeywordToken(@NotNull @NonNls String debugName, @NotNull @NonNls String value, boolean isSoft) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/lexer/JetKeywordToken", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/lexer/JetKeywordToken", "<init>"));
        }
        super(debugName, value);
        this.myIsSoft = isSoft;
    }

    public boolean isSoft() {
        return this.myIsSoft;
    }
}

