/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u001e\u0004)iAj\\8lkB$&/Y2lKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\fS:\u001c'/Z7f]R\fGN\u0003\u0006d_6\u0004xN\\3oiNTaA]3d_J$'\u0002\u00024s_6Ta\u0002T8pWV\u0004Hj\\2bi&|gNC\u0004j]N\u001bw\u000e]3\u000b\u0011)+GoU2pa\u0016TqA]3t_24XM\u0003\u0004tG>\u0004Xm\u001d\u0006\u0005]\u0006lWM\u0003\u0003OC6,'\u0002B+oSRTq!\u0016;jYN\\EO\u001d\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001\u0003\u0003\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\t!9\u0001\u0003\u0004\u0006\u0007\u0011!\u0001\"\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0004\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\r!=A\u0002A\u0003\u0003\t\tA\u0001!\u0002\u0002\u0005\u0005!!QA\u0001\u0003\u0005\u0011\u0015)!\u0001B\u0003\t\u000f\u0015\rDaA\u000b\u0004\u000b\u0005A)\u0001'\u0002\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\t!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0002;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\r\u0011eA\u0003\u0002\u0011\u001bAj!U\u0002\f\t\rI\u0011\u0001\u0002\u0001\u000e\u0003!9Q\"\u0001E\b\u001b\u0005A\u0001\"D\u0001\t\u0012a\u001b\u0001\u0002"})
public final class UtilsKt {
    public static final void record(LookupTracker $receiver, @NotNull LookupLocation from, @NotNull JetScope inScope, @NotNull Name name) {
        ScopeKind scopeKind;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(inScope, "inScope");
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (Intrinsics.areEqual($receiver, LookupTracker.Companion.getDO_NOTHING()) || from instanceof NoLookupLocation) {
            return;
        }
        if (!(from instanceof KotlinLookupLocation)) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected location type: " + from.getClass())));
        }
        JetFile containingJetFile = ((KotlinLookupLocation)from).getElement().getContainingJetFile();
        if (JetPsiFactoryKt.getDoNotAnalyze(containingJetFile) != null) {
            return;
        }
        String containingFilePath = containingJetFile.getVirtualFile().getPath();
        DiagnosticUtils.LineAndColumn lineAndColumn = $receiver.getRequiresLookupLineAndColumn() ? DiagnosticUtils.getLineAndColumnInPsiFile(containingJetFile, ((KotlinLookupLocation)from).getElement().getTextRange()) : (DiagnosticUtils.LineAndColumn)null;
        DeclarationDescriptor scopeContainingDeclaration = inScope.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = scopeContainingDeclaration;
        if (declarationDescriptor instanceof ClassifierDescriptor) {
            scopeKind = ScopeKind.CLASSIFIER;
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            scopeKind = ScopeKind.PACKAGE;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected containing declaration type: " + scopeContainingDeclaration.getClass())));
        }
        ScopeKind scopeKind2 = scopeKind;
        String string = containingFilePath;
        Intrinsics.checkExpressionValueIsNotNull(string, "containingFilePath");
        DiagnosticUtils.LineAndColumn lineAndColumn2 = lineAndColumn;
        Integer n = lineAndColumn2 != null ? Integer.valueOf(lineAndColumn2.getLine()) : null;
        DiagnosticUtils.LineAndColumn lineAndColumn3 = lineAndColumn;
        Integer n2 = lineAndColumn3 != null ? Integer.valueOf(lineAndColumn3.getColumn()) : null;
        String string2 = DescriptorUtilsKt.getFqNameUnsafe(scopeContainingDeclaration).asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "scopeContainingDeclaration.fqNameUnsafe.asString()");
        String string3 = name.asString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "name.asString()");
        $receiver.record(string, n, n2, string2, scopeKind2, string3);
    }
}

