/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.util.NotNullFunction;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

public class MainFunctionDetector {
    private final NotNullFunction<JetNamedFunction, FunctionDescriptor> getFunctionDescriptor;

    public MainFunctionDetector(final @NotNull BindingContext bindingContext) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = new NotNullFunction<JetNamedFunction, FunctionDescriptor>(){

            @Override
            @NotNull
            public FunctionDescriptor fun(JetNamedFunction function) {
                SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, function);
                if (functionDescriptor == null) {
                    throw new IllegalStateException("No descriptor resolved for " + function + " " + function.getText());
                }
                SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
                if (simpleFunctionDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector$1", "fun"));
                }
                return simpleFunctionDescriptor;
            }
        };
    }

    public MainFunctionDetector(@NotNull NotNullFunction<JetNamedFunction, FunctionDescriptor> functionResolver) {
        if (functionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionResolver", "org/jetbrains/kotlin/idea/MainFunctionDetector", "<init>"));
        }
        this.getFunctionDescriptor = functionResolver;
    }

    public boolean hasMain(@NotNull List<JetDeclaration> declarations) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/MainFunctionDetector", "hasMain"));
        }
        return this.findMainFunction(declarations) != null;
    }

    public boolean isMain(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/MainFunctionDetector", "isMain"));
        }
        if (function.isLocal()) {
            return false;
        }
        if (function.getValueParameters().size() != 1 || !function.getTypeParameters().isEmpty()) {
            return false;
        }
        if (!"main".equals(function.getName()) && !MainFunctionDetector.hasAnnotationWithExactNumberOfArguments(function, 1)) {
            return false;
        }
        if (!function.isTopLevel() && !MainFunctionDetector.hasAnnotationWithExactNumberOfArguments(function, 0)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = this.getFunctionDescriptor.fun(function);
        if (!MainFunctionDetector.getJVMFunctionName(functionDescriptor).equals("main")) {
            return false;
        }
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        if (parameters2.size() != 1) {
            return false;
        }
        ValueParameterDescriptor parameter = parameters2.get(0);
        JetType parameterType = parameter.getType();
        if (!KotlinBuiltIns.isArray(parameterType)) {
            return false;
        }
        List<TypeProjection> typeArguments = parameterType.getArguments();
        if (typeArguments.size() != 1) {
            return false;
        }
        JetType typeArgument = typeArguments.get(0).getType();
        if (!KotlinBuiltIns.isString(typeArgument)) {
            return false;
        }
        if (typeArguments.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(functionDescriptor)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && AnnotationsPackage.hasPlatformStaticAnnotation(functionDescriptor);
    }

    @Nullable
    public JetNamedFunction getMainFunction(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getMainFunction"));
        }
        for (JetFile file : files) {
            JetNamedFunction mainFunction = this.findMainFunction(file.getDeclarations());
            if (mainFunction == null) continue;
            return mainFunction;
        }
        return null;
    }

    @Nullable
    private JetNamedFunction findMainFunction(@NotNull List<JetDeclaration> declarations) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/idea/MainFunctionDetector", "findMainFunction"));
        }
        for (JetDeclaration declaration : declarations) {
            JetNamedFunction candidateFunction;
            if (!(declaration instanceof JetNamedFunction) || !this.isMain(candidateFunction = (JetNamedFunction)declaration)) continue;
            return candidateFunction;
        }
        return null;
    }

    @NotNull
    private static String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
        String platformName2 = DescriptorUtils.getJvmName(functionDescriptor);
        if (platformName2 != null) {
            String string = platformName2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getJVMFunctionName"));
            }
            return string;
        }
        String string = functionDescriptor.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/MainFunctionDetector", "getJVMFunctionName"));
        }
        return string;
    }

    private static boolean hasAnnotationWithExactNumberOfArguments(@NotNull JetNamedFunction function, int number) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/MainFunctionDetector", "hasAnnotationWithExactNumberOfArguments"));
        }
        for (JetAnnotationEntry entry : function.getAnnotationEntries()) {
            if (entry.getValueArguments().size() != number) continue;
            return true;
        }
        return false;
    }
}

