/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;

    public ValueParameterDescriptorImpl(@NotNull CallableDescriptor containingDeclaration, @Nullable ValueParameterDescriptor original, int index2, @NotNull Annotations annotations2, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations2, name, outType, source);
        this.original = original == null ? this : original;
        this.index = index2;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    @Override
    @NotNull
    public CallableDescriptor getContainingDeclaration() {
        CallableDescriptor callableDescriptor = (CallableDescriptor)super.getContainingDeclaration();
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "getContainingDeclaration"));
        }
        return callableDescriptor;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        ValueParameterDescriptor valueParameterDescriptor = this.original == this ? this : this.original.getOriginal();
        if (valueParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "getOriginal"));
        }
        return valueParameterDescriptor;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
        }
        if (substitutor2.isEmpty()) {
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = this;
            if (valueParameterDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
            }
            return valueParameterDescriptorImpl;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitValueParameterDescriptor(this, data2);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @Nullable
    public ConstantValue<?> getCompileTimeInitializer() {
        return null;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull CallableDescriptor newOwner, @NotNull Name newName) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, null, this.index, this.getAnnotations(), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType, SourceElement.NO_SOURCE);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        return valueParameterDescriptorImpl;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.LOCAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Collection<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        List<ValueParameterDescriptor> list = KotlinPackage.map(this.getContainingDeclaration().getOverriddenDescriptors(), new Function1<CallableDescriptor, ValueParameterDescriptor>(){

            @Override
            public ValueParameterDescriptor invoke(CallableDescriptor descriptor2) {
                return descriptor2.getValueParameters().get(ValueParameterDescriptorImpl.this.getIndex());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl", "getOverriddenDescriptors"));
        }
        return list;
    }
}

