/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.ExtensionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.SetterInfo;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u001c\u0006)Q2m\u001c7mK\u000e$\u0018J\u001c;fe\u001a\f7-Z:SK\u000e,(o]5wK*!A/\u001f9f\u0015\u0011!\u0016\u0010]3\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0004sK\u001adWm\u0019;\u000b\rI,7/\u001e7u\u0015)iU\u000f^1cY\u0016\u001cV\r\u001e\u0006\u0007W>$H.\u001b8\u000b\tUs\u0017\u000e\u001e\u0006\u0005kRLGNC\u0002TKRTqaQ1dQ\u0016\\EO\u0003\nhKR\u001cuN\\:ueV\u001cGo\u001c:J]\u001a|'\"A2\u000b\u000b\rc\u0017m]:\u000b\u001f\r{gn\u001d;sk\u000e$xN]%oM>T1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0005d_:$\u0018-\u001b8fe*\u0001r-\u001a;SK\u001eL7\u000f\u001e:bi&|gn\u001d\u0006\u0006W2\f7o\u001d\u0006\u0005\u0019&\u001cHO\u0003\bhKR\u001cV\r\u001e;fe&sgm\\:\u000b\u0015M+G\u000f^3s\u0013:4wNC\u0007ue\u00064XM]:f\u00072\f7o\u001d\u0006\n\u00072\f7o]%oM>TqaZ3u\u0013:4w\u000ef\u0001\u000b\u0005A\u0019!\u0002\u0002\u0005\u0001!\u0011QA\u0001C\u0001\u0011\u000b)1\u0001B\u0001\t\u00031\u0001Q!\u0001\u0005\u0005\u000b\r!!\u0001c\u0002\r\u0001\u0015\u0019AA\u0001E\u0005\u0019\u0001)!\u0001B\u0001\t\u0003\u0015\u0011A\u0001\u0001\u0005\u0006\u000b\t!A\u0001c\u0003\u0006\u0007\u0011\u0005\u0001r\u0002\u0007\u0001\u000b\u0005A\t\"\u0002\u0002\u0005\f!IQA\u0001\u0003\u0007\u0011\u0011)!\u0001\"\u0004\t\u0014\u0015\u0019Aa\u0002\u0005\t\u0019\u0001)!\u0001B\u0004\t\u0011\u0015\u0011A\u0011\u0001E\b\u000b\r!!\u0001C\u0006\r\u0001\u0015\u0011A\u0001\u0002\u0005\f\u000b\r!q\u0001\u0003\u0007\r\u0001\u0015\u0019Aa\u0002\u0005\u000e\u0019\u0001)!\u0001B\u0004\t\u001b\u00151C!\u0001\r\u0001;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u00012\u0001M\u0002!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011\ri\u0001\"B\u0001\t\u0006%!\u0011bA\u0003\u0002\u0011\u0007A\u001a\u0001'\u0002Q\u0007\u0003\t3!B\u0001\t\u0007a\u0019\u0011kA\u0004\u0005\u0001%\tA\u0001A\u0007\u0002\u0011\u000fi\u0011\u0001#\u0003Y\u0007\u0019)\u0019\u0004B\u0001\u0019\u000euMA\u0001\u0001\u0005\b\u001b\u0015)\u0011\u0001C\u0003\n\u0003\u0011\r\u0001$\u0002)\u0004\u0001\u0005\"Q!\u0001E\b\u0019\u0003Az!U\u0002\u0006\t\u001bI\u0011\u0001\u0003\u0005\u000e\u0003!E\u0001l\u0001\u0004\u0006<\u0011\t\u0001DCO\n\t\u0001A)\"D\u0003\u0006\u0003!)\u0011\"\u0001C\u00021\u0015\u00016\u0001A\u0011\t\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\t\u00012\u0001M\u00021%\t6!\u0002\u0003\u000b\u0013\u0005A\u0019\"D\u0001\t\u0012a\u001ba!b\u000f\u0005\u0003a]Q4\u0003\u0003\u0001\u0011\u001diQ!B\u0001\t\u000b%\tA1\u0001\r\u0006!\u000e\u0001\u0011\u0005C\u0003\u0002\u0011%IA!C\u0002\u0006\u0003!Q\u0001D\u0003\r\n#\u000e)AqC\u0005\u0002\u0011'i\u0011\u0001#\u0005Y\u0007\u0019)\t\u0004B\u0001\u0019\u001auMA\u0001\u0001\u0005\b\u001b\u0015)\u0011\u0001C\u0003\n\u0003\u0011\r\u0001$\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u000b1+\t6!\u0002C\r\u0013\u0005A1\"D\u0001\t\u0012a\u001ba!\u0002\u000b\u0005\u0007U)Q!\u0001\u0005\u0006\u0013\u0005!\u0019\u0001G\u0003\u0019\u001c\u0005\u001aQ!\u0001E\u000b1+\t6!\u0002C\u000e\u0013\u0005A1\"D\u0001\t\u0012a\u001ba\u0001"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ClassTraversalCache.INSTANCE$.getClassInfo($receiver);
    }

    @NotNull
    public static final ClassInfo traverseClass(@NotNull Class<?> c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c));
    }

    @NotNull
    public static final List<SetterInfo> getSetterInfos(@NotNull Class<?> c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Method[] methodArray = c.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2 = annotationArray[j];
                if (!StringsKt.endsWith$default(ExtensionsKt.annotationType(annotation2).getName(), ".Inject", false, 2)) continue;
                Method method2 = method;
                Intrinsics.checkExpressionValueIsNotNull(method2, "method");
                setterInfos.add(new SetterInfo(method2, ArraysKt.toList((Object[])method.getGenericParameterTypes())));
            }
        }
        return setterInfos;
    }

    @Nullable
    public static final ConstructorInfo getConstructorInfo(@NotNull Class<?> c) {
        Constructor constructor;
        boolean hasSinglePublicConstructor;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructors2 = c.getConstructors();
        Constructor constructor2 = (Constructor)ArraysKt.singleOrNull((Object[])constructors2);
        if (constructor2 != null) {
            Constructor $receiver = constructor2;
            Constructor it2 = $receiver;
            bl = Modifier.isPublic(it2.getModifiers());
        } else {
            bl = hasSinglePublicConstructor = false;
        }
        if (!hasSinglePublicConstructor) {
            return null;
        }
        Constructor constructor3 = constructor = (Constructor)ArraysKt.single((Object[])constructors2);
        Intrinsics.checkExpressionValueIsNotNull(constructor3, "constructor");
        return new ConstructorInfo(constructor3, ArraysKt.toList((Object[])constructor.getGenericParameterTypes()));
    }

    public static final void collectInterfacesRecursive(@NotNull Type type2, @NotNull Set<Type> result2) {
        Unit unit;
        Type[] klass;
        Object object;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        Type type3 = type2;
        if (type3 instanceof Class) {
            object = (Type[])type2;
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)type2).getRawType();
            if (!(type4 instanceof Class)) {
                type4 = null;
            }
            object = (Class)type4;
        } else {
            object = null;
        }
        Type[] typeArray = klass = object;
        if (klass != null && (typeArray = typeArray.getGenericInterfaces()) != null) {
            Object[] $receiver = typeArray;
            for (int i = 0; i < $receiver.length; ++i) {
                Type it2;
                Object element = $receiver[i];
                Type type5 = it2 = (Type)element;
                Intrinsics.checkExpressionValueIsNotNull(type5, "it");
                if (!result2.add(type5)) continue;
                Type type6 = it2;
                Intrinsics.checkExpressionValueIsNotNull(type6, "it");
                CacheKt.collectInterfacesRecursive(type6, result2);
            }
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Type> getRegistrations(@NotNull Class<?> klass) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        ArrayList registrations = new ArrayList();
        Sequence<Class<?>> superClasses2 = SequencesKt.sequence(klass, (Function1)getRegistrations.superClasses.1.INSTANCE$);
        CollectionsKt.addAll((Collection)registrations, superClasses2);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence<Class<?>> sequence2 = superClasses2;
        for (Object element : $receiver) {
            Type it2 = (Type)element;
            CacheKt.collectInterfacesRecursive(it2, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }
}

