/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0002\u0012)ya)\u001b=Ti\u0006\u001c7nQ8oi\u0016DHOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0019w\u000eZ3hK:TAb\u001c9uS6L'0\u0019;j_:T\u0001BZ5y'R\f7m\u001b\u0006\u0004\u0003:L(B\u0002\u001fj]&$hH\u0003\u0006nKRDw\u000e\u001a(pI\u0016T!\"T3uQ>$gj\u001c3f\u0015%y'M[3di^,'MC\u0002bg6TA\u0001\u001e:fK*1\"M]3bW\u000e{g\u000e^5ok\u0016<u\u000e^8O_\u0012,7OC\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\u0002\u0004&v[BLen\u001d8O_\u0012,'\"G4fi\n\u0013X-Y6D_:$\u0018N\\;f\u000f>$xNT8eKNTq\u0001P:fi6zdHC\u0004C_>dW-\u00198\u000b/\r|gn]5ti\u0016tG/\u00138mS:,W*\u0019:lKJ\u001c(BG4fi\u000e{gn]5ti\u0016tG/\u00138mS:,W*\u0019:lKJ\u001c(BG:fi\u000e{gn]5ti\u0016tG/\u00138mS:,W*\u0019:lKJ\u001c(B\u00074bW\u0016\fEn^1zg\u001a\u000bGn]3JM\u0016\fX*\u0019:lKJ\u001c(\"C!se\u0006LH*[:u\u0015A\t%m\u001d;sC\u000e$\u0018J\\:o\u001d>$WMC\u000fhKR4\u0015m[3BY^\f\u0017p\u001d$bYN,\u0017JZ3r\u001b\u0006\u00148.\u001a:t\u0015e1\u0017m[3BY^\f\u0017p\u001d+sk\u0016Le-Z9NCJ\\WM]:\u000b9\u001d,GOR1lK\u0006cw/Y=t)J,X-\u00134fc6\u000b'o[3sg*iq-\u001a;NKRDw\u000e\u001a(pI\u0016T\u0011d\u001c9f]&tw-\u00138mS:,W*\u001a;i_\u0012l\u0015M]6fe*9\u0001*Y:i\u001b\u0006\u0004(\u0002H4fi>\u0003XM\\5oO&sG.\u001b8f\u001b\u0016$\bn\u001c3NCJ\\WM\u001d\u0006!e\u0016\u001cHo\u001c:f'R\f7m['be.,'o\u001d$peN\u000bg/Z'be.,'OC\u0006NkR\f'\r\\3MSN$(bI4fiJ+7\u000f^8sKN#\u0018mY6NCJ\\WM]:G_J\u001c\u0016M^3NCJ\\WM\u001d\u0006 g\u00064Xm\u0015;bG.l\u0015M]6fe\u001a{'OU3ti>\u0014X-T1sW\u0016\u0014(BI4fiN\u000bg/Z*uC\u000e\\W*\u0019:lKJ4uN\u001d*fgR|'/Z'be.,'O\u0003\u0010tCZ,7\u000b^1dW:{G-Z:G_J$&/_*uCJ$H*\u00192fY*IA*\u00192fY:{G-\u001a\u0006\"O\u0016$8+\u0019<f'R\f7m\u001b(pI\u0016\u001chi\u001c:Uef\u001cF/\u0019:u\u0019\u0006\u0014W\r\u001c\u0006\u0016M&tG-T1uG\"LgnZ*bm\u0016tu\u000eZ3t\u0015!Ign\u001d8O_\u0012,'\u0002\u0004:fgR|'/\u001a'bE\u0016d'\u0002\u0002'jgRTQ\u0002[1t\u0003:LX*\u0019:lKJ\u001c(bB5oI\u0016DxJ\u001a\u0006\u0005]>$WMC\u0002J]RT!#[:B]\u0006d\u0017p]5t%\u0016\fX/\u001b:fI*Ab/[:ji\u001a\u000b7.Z!mo\u0006L8OR1mg\u0016Le-Z9\u000b\tUs\u0017\u000e\u001e\u0006\u0018m&\u001c\u0018\u000e\u001e$bW\u0016\fEn^1zgR\u0013X/Z%gKFTqC^5tSR4\u0015\u000e_*uC\u000e\\')\u001a4pe\u0016TU/\u001c9\u000b7YL7/\u001b;SKN$xN]3Ti\u0006\u001c7.\u00138Uef\u001c\u0015\r^2i\u0015]1\u0018n]5u'\u00064Xm\u0015;bG.\u0014UMZ8sKR\u0013\u0018Py\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0003\t\u0003A\t!\u0002\u0002\u0005\n!-QA\u0001\u0003\u0006\u0011\u0019)!\u0001b\u0003\t\u000e\u0015\u0019AA\u0002\u0005\u0006\u0019\u0001)!\u0001\u0002\u0004\t\u000b\u0015\t\u0001\u0002C\u0003\u0003\t\u001fA\t\"B\u0002\u0005\u0011!=A\u0002A\u0003\u0004\t\u0019A\u0011\u0002\u0004\u0001\u0006\u0005\u0011A\u0001rB\u0003\u0004\t\u000fA)\u0002\u0004\u0001\u0006\u0007\u0011A\u0001\"\u0004\u0007\u0001\u000b\r!a\u0001c\u0007\r\u0001\u0015\u0011A\u0001\u0003\u0005\u000e\u000b\r!\u0001\u0002#\t\r\u0001\u0015\u0011A\u0001\u0003E\u0011\u000b\r!9\u0001\u0003\n\r\u0001\u0015\u0019AA\u0002E\u0015\u0019\u0001)1\u0001b\u0002\t/1\u0001QA\u0001\u0003\t\u0011])!\u0001\u0002\u0004\t\u001c\u0015\u0011AA\u0002E\u0015\u000b\r!9\u0001C\r\r\u0001\u0015\u0019Aq\u0001E\u001b\u0019\u0001!\u0001\u0001D\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[U!1\r\u0002\r\bC!)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001\u0005\n1%A\n\"V\u0002\t\u000b\r!q!C\u0001\t\u00145\u0019A1C\u0005\u0002\u0011'i{\u0004Bb\r1-iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\u000b1)\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0002\u0007\u0006)CU\u001ba\"B\u0002\u0005\u0017%\tA\u0011A\u0007\u0004\t/I\u0011\u0001\"\u0001\u0012\u000b\u0011a\u0011\"\u0001\u0003\u0001\u001b\u0005!\t!L\u000b\u0005G\u0012AJ\"\t\u0005\u0006\u0003!U\u0011\u0002B\u0005\u0004\u000b\u0005A1\u0002G\u0006\u0019\u0016U\u001b\u0001\"B\u0002\u0005\u001a%\t\u0001rC\u0007\u0004\t9I\u0011\u0001c\u0006.+\u0011\u0019G\u0001'\b\"\u0011\u0015\t\u0001RC\u0005\u0005\u0013\r)\u0011\u0001C\u0006\u0019\u0017aUQk\u0001\u0005\u0006\u0007\u0011u\u0011\"\u0001E\f\u001b\r!q\"C\u0001\t\u00185\u0002Ba\u0019\u0003\u0019\n\u0005\u001aQ!\u0001E\u00071\u001b)6\u0001C\u0003\u0004\t\u0013I\u0011\u0001C\u0004\u000e\u0007\u0011}\u0011\"\u0001\u0005\b[i!1\r\u0002\r\u0011C5)\u0011\u0001\u0003\u0007\n\t%\u0019Q!\u0001\u0005\f1-IA!C\u0002\u0006\u0003!Y\u0001d\u0003\r\r+\u000eAQa\u0001\u0003\u0011\u0013\u0005AI\"D\u0002\u0005#%\t\u0001\u0012D\u0017 \t\r$\u00014E\u0011\u0013\u000b\u0005AA\"\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f\u0013%I\u0001\"B\u0001\t\u001b%!\u0011bA\u0003\u0002\u0011-A2\u0002G\u0007\u0019\u0019U\u001b\u0001\"B\u0002\u0005$%\t\u0001\u0012D\u0007\u0004\tKI\u0011\u0001#\u0007.5\u0011\u0019G\u0001G\n\"\u001b\u0015\t\u0001\u0002D\u0005\u0005\u0013\r)\u0011\u0001C\u0006\u0019\u0017%!\u0011bA\u0003\u0002\u0011-A2\u0002\u0007\u0007V\u0007!)1\u0001B\n\n\u0003!eQb\u0001C\u0014\u0013\u0005AI\"\f\u000e\u0005G\u0012AB#I\u0007\u0006\u0003!a\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0002g\u0007\n\t%\u0019Q!\u0001\u0005\f1-AB\"V\u0002\t\u000b\r!A#C\u0001\t\u001a5\u0019A!F\u0005\u0002\u00113iK\u0005B\u0001\u0019,u=A\u0001\u0001\u0005\u0017\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\u0001!h\u0004\u0005\u0001!5RbA\u0003\u0002\u00117AZ\u0002UB\u0001C!)\u0011\u0001\u0003\b\n\t%\u0019Q!\u0001\u0005\f1-Ab\"U\u0002\b\tWI\u0011\u0001#\b\u000e\u0003!yQ\"\u0001E\u0010[+!1\u0001g\f\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000e\u0019AqF\u0005\u0002\t\u0003iS\u0003B\u0001\u00191u=A\u0001\u0001E\u0019\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\u0001!I\u0002\u0006\u0003!\u0001\u0002\u0004E)\u0004\u000b\u0011A\u0012\"\u0001C\u0003\u001b\u0005Aq\",\u0006\u0005\u0007aM\u0012eA\u0003\u0002\u0011)A\"\"U\u0002\u0004\tgI\u0011\u0001\"\u0001.+\u0011\t\u0001DGO\b\t\u0001Aa#D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u00111C\t6!\u0002\u0003\u001b\u0013\u0005!\u0001!D\u0001\t\u001f5*B!\u0001\r\u001c;\u001f!\u0001\u0001\u0003\f\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0001\u0011eA\u0003\u0002\u0011CA\n#U\u0002\u0006\tmI\u0011\u0001\u0002\u0001\u000e\u0003!yQ&\u0006\u0003\u00021oiz\u0001\u0002\u0001\t-5\u0019Q!\u0001\u0005\f1-\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0003'\tR\u0007\u0015!9$C\u0001\u0005\u00015\t\u0001bD\u0017\u0016\t\u0005AB$h\u0004\u0005\u0001!1RbA\u0003\u0002\u0011-A2\u0002U\u0002\u0001C\r)\u0011\u0001#\t\u0019\"E\u001bQ\u0001\u0002\u000f\n\u0003\u0011\u0001Q\"\u0001\u0005\u0010[U!\u0011\u0001'\u000f\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005A1\u0002G\u0006Q\u0007\u0001\t3!B\u0001\t\"a\u0005\u0012kA\u0003\u0005:%\tA\u0001A\u0007\u0002\u0011=)l#b\u000b\u0005G\u0004AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bQ\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\b"})
public final class FixStackContext {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    @NotNull
    private final HashMap<LabelNode, AbstractInsnNode> saveStackNodesForTryStartLabel;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    static {
        $kotlinClass = Reflection.createKotlinClass(FixStackContext.class);
    }

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    @NotNull
    public final HashMap<LabelNode, AbstractInsnNode> getSaveStackNodesForTryStartLabel() {
        return this.saveStackNodesForTryStartLabel;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        AbstractInsnNode next = insnNode.getNext();
        PreconditionsKt.assert(next.getOpcode() == Opcodes.GOTO, this.indexOf(insnNode) + ": should be followed by GOTO");
        AbstractInsnNode abstractInsnNode = next;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)abstractInsnNode);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        PreconditionsKt.assert(insnNode.getNext().getOpcode() == Opcodes.IFEQ, this.indexOf(insnNode) + ": should be followed by IFEQ");
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        PreconditionsKt.assert(insnNode.getNext().getOpcode() == Opcodes.IFEQ, this.indexOf(insnNode) + ": should be followed by IFEQ");
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final void visitSaveStackBeforeTry(AbstractInsnNode insnNode) {
        AbstractInsnNode tryStartLabel = insnNode.getNext();
        PreconditionsKt.assert(tryStartLabel instanceof LabelNode, this.indexOf(insnNode) + ": save should be followed by a label");
        AbstractInsnNode abstractInsnNode = tryStartLabel;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LabelNode");
        }
        MapsKt.set(this.saveStackNodesForTryStartLabel, (LabelNode)abstractInsnNode, insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitRestoreStackInTryCatch(AbstractInsnNode insnNode) {
        Object object;
        void $receiver;
        AbstractInsnNode restoreLabel;
        Object it2;
        AbstractInsnNode finger;
        AbstractInsnNode $receiver2 = insnNode;
        for (finger = $receiver2.getPrevious(); finger != null && !UtilKt.hasOpcode((AbstractInsnNode)(it2 = finger)); finger = finger.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode = finger;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        $receiver2 = abstractInsnNode;
        for (finger = $receiver2.getPrevious(); finger != null && !((it2 = finger) instanceof LabelNode || UtilKt.hasOpcode((AbstractInsnNode)it2)); finger = finger.getPrevious()) {
        }
        AbstractInsnNode abstractInsnNode2 = finger;
        if (abstractInsnNode2 == null) {
            Intrinsics.throwNpe();
        }
        if (!((restoreLabel = abstractInsnNode2) instanceof LabelNode)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": restore should be preceded by a catch block label")));
        }
        List<AbstractInsnNode> saveNodes = this.findMatchingSaveNodes(insnNode, (LabelNode)restoreLabel);
        if (saveNodes.isEmpty()) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is not matched with save")));
        }
        if (saveNodes.size() > 1) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insnNode) + ": in handler " + this.indexOf(restoreLabel) + " restore is matched with several saves")));
        }
        AbstractInsnNode saveNode = CollectionsKt.first(saveNodes);
        MapsKt.set(this.saveStackMarkerForRestoreMarker, insnNode, saveNode);
        it2 = this.restoreStackMarkersForSaveMarker;
        Object value = $receiver.get(saveNode);
        if (value == null && !$receiver.containsKey(saveNode)) {
            SmartList answer = new SmartList();
            $receiver.put(saveNode, answer);
            object = answer;
        } else {
            object = value;
        }
        ((List)object).add(insnNode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractInsnNode> findMatchingSaveNodes(AbstractInsnNode insnNode, LabelNode restoreLabel) {
        void $receiver;
        SmartHashSet<AbstractInsnNode> saveNodes = new SmartHashSet<AbstractInsnNode>();
        Iterable iterable = this.methodNode.tryCatchBlocks;
        for (Object element : $receiver) {
            Boolean bl;
            TryCatchBlockNode tcb = (TryCatchBlockNode)element;
            if (!Intrinsics.areEqual(restoreLabel, tcb.start) && !Intrinsics.areEqual(restoreLabel, tcb.handler)) continue;
            if (this.getSaveStackNodesForTryStartLabel().get(tcb.start) != null) {
                void $receiver2;
                AbstractInsnNode it2 = (AbstractInsnNode)$receiver2;
                bl = saveNodes.add(it2);
                continue;
            }
            bl = null;
        }
        return new SmartList((Collection)saveNodes);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysTrueIfeqMarkers) || CollectionsKt.isNotEmpty((Collection)this.fakeAlwaysFalseIfeqMarkers) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    public final boolean isAnalysisRequired() {
        return CollectionsKt.isNotEmpty((Collection)this.breakContinueGotoNodes) || MapsKt.isNotEmpty((Map)this.saveStackNodesForTryStartLabel) || MapsKt.isNotEmpty((Map)this.openingInlineMethodMarker);
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = SetsKt.linkedSetOf(new JumpInsnNode[0]);
        this.fakeAlwaysTrueIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.fakeAlwaysFalseIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.saveStackNodesForTryStartLabel = MapsKt.hashMapOf(new Pair[0]);
        this.saveStackMarkerForRestoreMarker = MapsKt.hashMapOf(new Pair[0]);
        this.restoreStackMarkersForSaveMarker = MapsKt.hashMapOf(new Pair[0]);
        this.openingInlineMethodMarker = MapsKt.hashMapOf(new Pair[0]);
        this.consistentInlineMarkers = true;
        AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        Sequence $receiver = new InsnSequence(insnList);
        Iterator iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            Object element = iterator2.next();
            AbstractInsnNode insnNode = (AbstractInsnNode)element;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FIX_STACK_BEFORE_JUMP)) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ)) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ)) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.SAVE_STACK_BEFORE_TRY)) {
                this.visitSaveStackBeforeTry(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.RESTORE_STACK_IN_TRY_CATCH)) {
                this.visitRestoreStackInTryCatch(insnNode);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(insnNode)) continue;
            PreconditionsKt.assert(CollectionsKt.isNotEmpty((Collection)inlineMarkersStack), "Mismatching after inline method marker at " + this.indexOf(insnNode));
            Map map2 = this.getOpeningInlineMethodMarker();
            Object t = inlineMarkersStack.pop();
            Intrinsics.checkExpressionValueIsNotNull(t, "inlineMarkersStack.pop()");
            MapsKt.set(map2, insnNode, t);
        }
        if (CollectionsKt.isNotEmpty((Collection)inlineMarkersStack)) {
            this.consistentInlineMarkers = false;
        }
    }
}

