/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MaxLocalsCalculator
extends MethodVisitor {
    private int maxLocals;

    public MaxLocalsCalculator(int api, int access, String descriptor2, MethodVisitor mv) {
        super(api, mv);
        int size = Type.getArgumentsAndReturnSizes(descriptor2) >> 2;
        if ((access & 8) != 0) {
            --size;
        }
        this.maxLocals = size;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        int n = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1;
        this.updateMaxLocals(n);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.updateMaxLocals(var + 1);
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator", "visitLocalVariable"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator", "visitLocalVariable"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator", "visitLocalVariable"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/MaxLocalsCalculator", "visitLocalVariable"));
        }
        char c = desc.charAt(0);
        int n = index2 + (c == 'J' || c == 'D' ? 2 : 1);
        this.updateMaxLocals(n);
        super.visitLocalVariable(name, desc, signature, start, end, index2);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, this.maxLocals);
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    private void updateMaxLocals(int nextFreeSlotNumber) {
        if (nextFreeSlotNumber > this.maxLocals) {
            this.maxLocals = nextFreeSlotNumber;
        }
    }
}

