/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.ScriptNameUtil;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinCodegenFacade {
    public static void prepareForCompilation(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "prepareForCompilation"));
        }
        for (JetFile file : state.getFiles()) {
            if (!file.isScript()) continue;
            JetScript script = file.getScript();
            assert (script != null);
            FqName name = ScriptNameUtil.classNameForScript(script);
            Type type2 = AsmUtil.asmTypeByFqNameWithoutInnerClasses(name);
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, type2, state.getFileClassesProvider());
        }
        state.beforeCompile();
    }

    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.prepareForCompilation(state);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        MultiMap<FqName, JetFile> filesInPackageClasses = new MultiMap<FqName, JetFile>();
        MultiMap<FqName, JetFile> filesInMultifileClasses = new MultiMap<FqName, JetFile>();
        for (JetFile file : state.getFiles()) {
            if (file == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = state.getFileClassesProvider().getFileClassInfo(file);
            if (fileClassInfo.getIsMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), file);
            }
            if (state.getPackageFacadesAsMultifileClasses()) {
                if (fileClassInfo.getIsMultifileClass()) continue;
                filesInMultifileClasses.putValue(PackageClassUtils.getPackageClassFqName(file.getPackageFqName()), file);
                continue;
            }
            filesInPackageClasses.putValue(file.getPackageFqName(), file);
        }
        HashSet<FqName> packagesWithObsoleteParts = new HashSet<FqName>(state.getPackagesWithObsoleteParts());
        for (FqName packageFqName : Sets.union(packagesWithObsoleteParts, filesInPackageClasses.keySet())) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            KotlinCodegenFacade.generatePackage(state, packageFqName, filesInPackageClasses.get(packageFqName), errorHandler);
        }
        for (FqName multifileClassFqName : filesInMultifileClasses.keySet()) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            KotlinCodegenFacade.generateMultifileClass(state, multifileClassFqName, filesInMultifileClasses.get(multifileClassFqName), errorHandler);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state.getFactory().done();
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<JetFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private static void generateMultifileClass(@NotNull GenerationState state, @NotNull FqName multifileClassFqName, @NotNull Collection<JetFile> files, @NotNull CompilationErrorHandler handler2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (multifileClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multifileClassFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        MultifileClassCodegen codegen = state.getFactory().forMultifileClass(multifileClassFqName, files);
        codegen.generate(handler2);
    }

    private KotlinCodegenFacade() {
    }
}

