/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<Type> valueParameterTypes) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        if (valueParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterTypes", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "<init>"));
        }
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters;
        this.valueParameterTypes = valueParameterTypes;
        assert (valueParameters.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters.size() + " != " + valueParameterTypes.size();
    }

    @Override
    @NotNull
    public List<Integer> generate(@NotNull List<ResolvedValueArgument> valueArguments2) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "generate"));
        }
        boolean shouldMarkLineNumbers = this.codegen.isShouldMarkLineNumbers();
        this.codegen.setShouldMarkLineNumbers(false);
        List<Integer> masks = super.generate(valueArguments2);
        this.codegen.setShouldMarkLineNumbers(shouldMarkLineNumbers);
        List<Integer> list = masks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "generate"));
        }
        return list;
    }

    @Override
    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "generateExpression"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        ValueArgument valueArgument = argument.getValueArgument();
        assert (valueArgument != null);
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression, type2);
    }

    @Override
    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "generateDefault"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        AsmUtil.pushDefaultValueOnStack(type2, this.codegen.v);
        this.callGenerator.afterParameterPut(type2, null, parameter);
    }

    @Override
    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator", "generateVararg"));
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        this.codegen.genVarargs(argument, parameter.getType());
        this.callGenerator.afterParameterPut(type2, null, parameter);
    }
}

