/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.util.ArrayUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CompilerPlugin;
import org.jetbrains.kotlin.cli.common.CompilerPluginContext;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsPackage;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ConfigPackage;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.ModulesPackage;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.relocated.com.google.common.base.Function;
import org.jetbrains.kotlin.relocated.com.google.common.base.Joiner;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Lists;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Maps;
import org.jetbrains.kotlin.resolve.AnalyzerScriptParameter;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ScriptNameUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    @NotNull
    private static List<String> getAbsolutePaths(@NotNull File directory, @NotNull Module module) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        ArrayList<String> result2 = Lists.newArrayList();
        for (String sourceFile : module.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            result2.add(source.getAbsolutePath());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        return arrayList;
    }

    private static void writeOutput(@NotNull CompilerConfiguration configuration, @NotNull ClassFileFactory outputFiles, @Nullable File outputDir, @Nullable File jarPath, boolean jarRuntime, @Nullable FqName mainClass) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "writeOutput"));
        }
        if (outputFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "writeOutput"));
        }
        if (jarPath != null) {
            CompileEnvironmentUtil.writeToJar(jarPath, jarRuntime, mainClass, outputFiles);
        } else {
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
            OutputUtilsPackage.writeAll((OutputFileCollection)outputFiles, outputDir == null ? new File(".") : outputDir, messageCollector);
        }
    }

    public static boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull CompilerConfiguration configuration, @NotNull List<Module> chunk, @NotNull File directory, @Nullable File jarPath, boolean jarRuntime) {
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        HashMap<Module, ClassFileFactory> outputFiles = Maps.newHashMap();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        for (Module module : chunk) {
            ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject()).addModule(module);
        }
        String targetDescription = "in targets [" + Joiner.on(", ").join(Collections2.transform(chunk, new Function<Module, String>(){

            @Override
            public String apply(@Nullable Module input) {
                return input != null ? input.getModuleName() + "-" + input.getModuleType() : "<null>";
            }
        })) + "] ";
        AnalysisResult result2 = KotlinToJVMBytecodeCompiler.analyze(environment2, targetDescription);
        if (result2 == null) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        for (Module module : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            List<JetFile> jetFiles = CompileEnvironmentUtil.getJetFiles(environment2.getProject(), KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module), new Function1<String, Unit>(){

                @Override
                public Unit invoke(String s) {
                    throw new IllegalStateException("Should have been checked before: " + s);
                }
            });
            File moduleOutputDirectory = new File(module.getOutputDirectory());
            GenerationState generationState = KotlinToJVMBytecodeCompiler.generate(environment2, result2, jetFiles, module, moduleOutputDirectory, module.getModuleName());
            outputFiles.put(module, generationState.getFactory());
        }
        for (Module module : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            KotlinToJVMBytecodeCompiler.writeOutput(configuration, (ClassFileFactory)outputFiles.get(module), new File(module.getOutputDirectory()), jarPath, jarRuntime, null);
        }
        return true;
    }

    @NotNull
    public static CompilerConfiguration createCompilerConfiguration(@NotNull CompilerConfiguration base, @NotNull List<Module> chunk, @NotNull File directory) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        CompilerConfiguration configuration = base.copy();
        for (Module module : chunk) {
            ConfigPackage.addKotlinSourceRoots(configuration, KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module));
        }
        for (Module module : chunk) {
            for (String javaSourceRoot : module.getJavaSourceRoots()) {
                org.jetbrains.kotlin.cli.jvm.config.ConfigPackage.addJavaSourceRoot(configuration, new File(javaSourceRoot));
            }
        }
        for (Module module : chunk) {
            for (String classpathRoot : module.getClasspathRoots()) {
                org.jetbrains.kotlin.cli.jvm.config.ConfigPackage.addJvmClasspathRoot(configuration, new File(classpathRoot));
            }
        }
        for (Module module : chunk) {
            for (String annotationsRoot : module.getAnnotationsRoots()) {
                configuration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
            }
            configuration.add(JVMConfigurationKeys.MODULES, module);
        }
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        return compilerConfiguration;
    }

    @Nullable
    private static FqName findMainClass(@NotNull GenerationState generationState, @NotNull List<JetFile> files) {
        if (generationState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationState", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!mainFunctionDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName2 = file.getPackageFqName();
            mainClass = PackageClassUtils.getPackageClassFqName(fqName2);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileBunchOfSources"));
        }
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return false;
        }
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(generationState, environment2.getSourceFiles());
        try {
            KotlinToJVMBytecodeCompiler.writeOutput(environment2.getConfiguration(), generationState.getFactory(), outputDir, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static void compileAndExecuteScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2, @NotNull List<String> scriptArgs) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (scriptArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptArgs", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(configuration, paths, environment2);
        if (scriptClass == null) {
            return;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{ArrayUtil.toStringArray(scriptArgs)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static Class<?> compileScript(@NotNull CompilerConfiguration configuration, @NotNull KotlinPaths paths, @NotNull KotlinCoreEnvironment environment2) {
        GenerationState state;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        List<AnalyzerScriptParameter> scriptParameters = environment2.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS);
        if (!scriptParameters.isEmpty()) {
            JetScriptDefinitionProvider.getInstance(environment2.getProject()).addScriptDefinition(new JetScriptDefinition(".kts", scriptParameters));
        }
        if ((state = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment2)) == null) {
            return null;
        }
        try {
            ArrayList<URL> classPaths = Lists.newArrayList(paths.getRuntimePath().toURI().toURL());
            for (File file : org.jetbrains.kotlin.cli.jvm.config.ConfigPackage.getJvmClasspathRoots(configuration)) {
                classPaths.add(file.toURI().toURL());
            }
            GeneratedClassLoader classLoader = new GeneratedClassLoader(state.getFactory(), (ClassLoader)new URLClassLoader(classPaths.toArray(new URL[classPaths.size()]), null), new URL[0]);
            FqName nameForScript = ScriptNameUtil.classNameForScript(environment2.getSourceFiles().get(0).getScript());
            return classLoader.loadClass(nameForScript.asString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2) {
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyzeAndGenerate"));
        }
        AnalysisResult result2 = KotlinToJVMBytecodeCompiler.analyze(environment2, null);
        if (result2 == null) {
            return null;
        }
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment2, result2, environment2.getSourceFiles(), null, null, null);
    }

    @Nullable
    private static AnalysisResult analyze(final @NotNull KotlinCoreEnvironment environment2, @Nullable String targetDescription) {
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyze"));
        }
        MessageCollector collector2 = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        assert (collector2 != null);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport(environment2.getSourceFiles(), new Function0<AnalysisResult>(){

            @Override
            @NotNull
            public AnalysisResult invoke() {
                CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace sharedTrace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
                MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(environment2.getProject(), org.jetbrains.kotlin.cli.jvm.config.ConfigPackage.getModuleName(environment2));
                AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationWithCustomContext(moduleContext, environment2.getSourceFiles(), sharedTrace, environment2.getConfiguration().get(JVMConfigurationKeys.MODULES), environment2.getConfiguration().get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS), new JvmPackagePartProvider(environment2));
                if (analysisResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$3", "invoke"));
                }
                return analysisResult;
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        String message = "ANALYZE: " + environment2.getSourceFiles().size() + " files (" + environment2.getSourceLinesOfCode() + " lines) " + (targetDescription != null ? targetDescription : "") + "in " + TimeUnit.NANOSECONDS.toMillis(analysisNanos) + " ms";
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        AnalysisResult result2 = analyzerWithCompilerReport.getAnalysisResult();
        assert (result2 != null) : "AnalysisResult should be non-null, compiling: " + environment2.getSourceFiles();
        CompilerPluginContext context = new CompilerPluginContext(environment2.getProject(), result2.getBindingContext(), environment2.getSourceFiles());
        for (CompilerPlugin plugin : environment2.getConfiguration().getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        return analyzerWithCompilerReport.hasErrors() ? null : result2;
    }

    @NotNull
    private static GenerationState generate(@NotNull KotlinCoreEnvironment environment2, @NotNull AnalysisResult result2, @NotNull List<JetFile> sourceFiles, @Nullable Module module, File outputDirectory, String moduleName) {
        Set packagesWithObsoleteParts;
        if (environment2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        CompilerConfiguration configuration = environment2.getConfiguration();
        IncrementalCompilationComponents incrementalCompilationComponents = configuration.get(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS);
        TargetId targetId = null;
        if (module == null || incrementalCompilationComponents == null) {
            packagesWithObsoleteParts = Collections.emptySet();
        } else {
            targetId = ModulesPackage.TargetId(module);
            IncrementalCache incrementalCache = incrementalCompilationComponents.getIncrementalCache(targetId);
            packagesWithObsoleteParts = new HashSet();
            for (String internalName : incrementalCache.getObsoletePackageParts()) {
                packagesWithObsoleteParts.add(JvmClassName.byInternalName(internalName).getPackageFqName());
            }
        }
        BindingTraceContext diagnosticHolder = new BindingTraceContext();
        GenerationState generationState = new GenerationState(environment2.getProject(), ClassBuilderFactories.BINARIES, result2.getModuleDescriptor(), result2.getBindingContext(), sourceFiles, configuration.get(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, false), GenerationState.GenerateClassFilter.GENERATE_ALL, configuration.get(JVMConfigurationKeys.DISABLE_INLINE, false), configuration.get(JVMConfigurationKeys.DISABLE_OPTIMIZATION, false), configuration.get(JVMConfigurationKeys.PACKAGE_FACADES_AS_MULTIFILE_CLASSES, false), diagnosticHolder, packagesWithObsoleteParts, targetId, moduleName, outputDirectory, incrementalCompilationComponents);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module != null ? "target " + module.getModuleName() + "-" + module.getModuleType() + " " : "";
        String message = "GENERATE: " + sourceFiles.size() + " files (" + environment2.countLinesOfCode(sourceFiles) + " lines) " + desc + "in " + TimeUnit.NANOSECONDS.toMillis(generationNanos) + " ms";
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.reportDiagnostics(new FilteredJvmDiagnostics(diagnosticHolder.getBindingContext().getDiagnostics(), result2.getBindingContext().getDiagnostics()), environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        return generationState2;
    }
}

