/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.load.java.JavaBindingContext;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.UtilsPackage;

public final class AnalyzerWithCompilerReport {
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    private final MessageSeverityCollector messageCollector;
    private AnalysisResult analysisResult;

    @NotNull
    public static CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
        }
        switch (severity) {
            case INFO: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.INFO;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
            case ERROR: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
            case WARNING: {
                CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                if (compilerMessageSeverity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "convertSeverity"));
                }
                return compilerMessageSeverity;
            }
        }
        throw new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
    }

    public AnalyzerWithCompilerReport(@NotNull MessageCollector collector2) {
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "<init>"));
        }
        this.analysisResult = null;
        this.messageCollector = new MessageSeverityCollector(collector2);
    }

    private static boolean reportDiagnostic(@NotNull Diagnostic diagnostic, @NotNull DiagnosticMessageReporter reporter, boolean incompatibleFilesFound) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostic"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostic"));
        }
        if (!diagnostic.isValid()) {
            return false;
        }
        String render = diagnostic instanceof MyDiagnostic ? ((MyDiagnostic)diagnostic).message : DefaultErrorMessages.render(diagnostic);
        if (incompatibleFilesFound && Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
            render = render + "\n(note: this may be caused by the fact that some classes compiled with an incompatible version of Kotlin were found in the classpath. Such classes cannot be loaded properly by this version of Kotlin compiler. See below for more information)";
        }
        PsiFile file = diagnostic.getPsiFile();
        reporter.report(diagnostic, file, render);
        return diagnostic.getSeverity() == Severity.ERROR;
    }

    private void reportIncompleteHierarchies() {
        assert (this.analysisResult != null);
        BindingContext bindingContext = this.analysisResult.getBindingContext();
        Collection<ClassDescriptor> classes2 = bindingContext.getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY);
        if (!classes2.isEmpty()) {
            StringBuilder message = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor2 : classes2) {
                String fqName2 = DescriptorUtils.getFqName(descriptor2).asString();
                List<String> unresolved = bindingContext.get(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, descriptor2);
                assert (unresolved != null && !unresolved.isEmpty()) : "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName2;
                message.append("    class ").append(fqName2).append(", unresolved supertypes: ").append(UtilsPackage.join(unresolved, ", ")).append("\n");
            }
            this.messageCollector.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportAlternativeSignatureErrors() {
        assert (this.analysisResult != null);
        BindingContext bc = this.analysisResult.getBindingContext();
        Collection<DeclarationDescriptor> descriptorsWithErrors = bc.getKeys(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor2 : descriptorsWithErrors) {
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
                assert (declaration instanceof PsiModifierListOwner);
                List<String> errors = bc.get(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2);
                assert (errors != null && !errors.isEmpty());
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)declaration);
                message.append(externalName).append(":\n");
                for (String error : errors) {
                    message.append("    ").append(error).append("\n");
                }
            }
            this.messageCollector.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    @NotNull
    private List<TraceBasedErrorReporter.AbiVersionErrorData> getAbiVersionErrors() {
        assert (this.analysisResult != null);
        BindingContext bindingContext = this.analysisResult.getBindingContext();
        Collection<String> errorClasses = bindingContext.getKeys(TraceBasedErrorReporter.ABI_VERSION_ERRORS);
        ArrayList<TraceBasedErrorReporter.AbiVersionErrorData> result2 = new ArrayList<TraceBasedErrorReporter.AbiVersionErrorData>(errorClasses.size());
        for (String kotlinClass : errorClasses) {
            result2.add(bindingContext.get(TraceBasedErrorReporter.ABI_VERSION_ERRORS, kotlinClass));
        }
        ArrayList<TraceBasedErrorReporter.AbiVersionErrorData> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "getAbiVersionErrors"));
        }
        return arrayList;
    }

    private void reportAbiVersionErrors(@NotNull List<TraceBasedErrorReporter.AbiVersionErrorData> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportAbiVersionErrors"));
        }
        for (TraceBasedErrorReporter.AbiVersionErrorData data2 : errors) {
            String path = FileUtil.toSystemDependentName(data2.getFilePath());
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Class '" + JvmClassName.byClassId(data2.getClassId()) + "' was compiled with an incompatible version of Kotlin. " + "Its ABI version is " + data2.getActualVersion() + ", expected ABI version is " + JvmAbi.VERSION, CompilerMessageLocation.create(path, -1, -1, null));
        }
    }

    public static boolean reportDiagnostics(@NotNull Diagnostics diagnostics, @NotNull DiagnosticMessageReporter reporter, boolean incompatibleFilesFound) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        boolean hasErrors = false;
        for (Diagnostic diagnostic : DiagnosticUtils.sortedDiagnostics(diagnostics.all())) {
            hasErrors |= AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, reporter, incompatibleFilesFound);
        }
        return hasErrors;
    }

    public static boolean reportDiagnostics(@NotNull Diagnostics diagnostics, @NotNull MessageCollector messageCollector, boolean incompatibleFilesFound) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        return AnalyzerWithCompilerReport.reportDiagnostics(diagnostics, new DefaultDiagnosticReporter(messageCollector), incompatibleFilesFound);
    }

    public static boolean reportDiagnostics(@NotNull Diagnostics diagnostics, @NotNull MessageCollector messageCollector) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportDiagnostics"));
        }
        return AnalyzerWithCompilerReport.reportDiagnostics(diagnostics, new DefaultDiagnosticReporter(messageCollector), false);
    }

    private void reportSyntaxErrors(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        for (JetFile file : files) {
            AnalyzerWithCompilerReport.reportSyntaxErrors((PsiElement)file, this.messageCollector);
        }
    }

    public static SyntaxErrorReport reportSyntaxErrors(final @NotNull PsiElement file, final @NotNull DiagnosticMessageReporter reporter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        class ErrorReportingVisitor
        extends AnalyzingUtils.PsiErrorElementVisitor {
            boolean hasErrors = false;
            boolean allErrorsAtEof = true;

            ErrorReportingVisitor() {
            }

            private <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory, String message) {
                MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory, message);
                AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, reporter, false);
                if (element.getTextRange().getStartOffset() != file.getTextRange().getEndOffset()) {
                    this.allErrorsAtEof = false;
                }
                this.hasErrors = true;
            }

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                String description = element.getErrorDescription();
                this.reportDiagnostic(element, SYNTAX_ERROR_FACTORY, StringUtil.isEmpty(description) ? "Syntax error" : description);
            }
        }
        ErrorReportingVisitor visitor2 = new ErrorReportingVisitor();
        file.accept(visitor2);
        return new SyntaxErrorReport(visitor2.hasErrors, visitor2.allErrorsAtEof);
    }

    public static SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file, @NotNull MessageCollector messageCollector) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "reportSyntaxErrors"));
        }
        return AnalyzerWithCompilerReport.reportSyntaxErrors(file, new DefaultDiagnosticReporter(messageCollector));
    }

    @Nullable
    public AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    public boolean hasErrors() {
        return this.messageCollector.anyReported(CompilerMessageSeverity.ERROR);
    }

    public void analyzeAndReport(@NotNull Collection<JetFile> files, @NotNull Function0<AnalysisResult> analyzer) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "analyzeAndReport"));
        }
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport", "analyzeAndReport"));
        }
        this.analysisResult = analyzer.invoke();
        this.reportSyntaxErrors(files);
        List<TraceBasedErrorReporter.AbiVersionErrorData> abiVersionErrors = this.getAbiVersionErrors();
        AnalyzerWithCompilerReport.reportDiagnostics(this.analysisResult.getBindingContext().getDiagnostics(), this.messageCollector, !abiVersionErrors.isEmpty());
        if (this.hasErrors()) {
            this.reportAbiVersionErrors(abiVersionErrors);
        }
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    private static class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        private final String message;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory, String message) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic", "<init>"));
            }
            super(psiElement, factory, Severity.ERROR);
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static class SyntaxErrorReport {
        private final boolean hasErrors;
        private final boolean allErrorsAtEof;

        public SyntaxErrorReport(boolean hasErrors, boolean allErrorsAtEof) {
            this.hasErrors = hasErrors;
            this.allErrorsAtEof = allErrorsAtEof;
        }

        public boolean isHasErrors() {
            return this.hasErrors;
        }

        public boolean isAllErrorsAtEof() {
            return this.allErrorsAtEof;
        }
    }
}

