/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.DelegatingType;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeNullability;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtilsKt {
    @NotNull
    public static final TypeNullability nullability(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isNullabilityFlexible($receiver) ? TypeNullability.FLEXIBLE : (TypeUtils.isNullableType($receiver) ? TypeNullability.NULLABLE : TypeNullability.NOT_NULL);
    }

    @NotNull
    public static final JetType makeNullable(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNullable($receiver);
    }

    @NotNull
    public static final JetType makeNotNullable(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNotNullable($receiver);
    }

    @NotNull
    public static final Collection<JetType> immediateSupertypes(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getImmediateSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getImmediateSupertypes(this)");
        return collection;
    }

    @NotNull
    public static final Collection<JetType> supertypes(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getAllSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getAllSupertypes(this)");
        return collection;
    }

    public static final boolean isNothing(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothing($receiver);
    }

    public static final boolean isUnit(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isUnit($receiver);
    }

    public static final boolean isAnyOrNullableAny(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isBoolean(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBoolean($receiver);
    }

    public static final boolean isBooleanOrNullableBoolean(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBooleanOrNullableBoolean($receiver);
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getContainedTypeParameters(JetType $receiver) {
        Collection destination;
        Object it2;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor declarationDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            return CollectionsKt.listOf(declarationDescriptor);
        }
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility != null) {
            return CollectionsKt.plus(TypeUtilsKt.getContainedTypeParameters(flexibility.getLowerBound()), (Iterable)TypeUtilsKt.getContainedTypeParameters(flexibility.getUpperBound()));
        }
        Iterable $receiver3 = $receiver.getArguments();
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (TypeProjection)element;
            if (!(!it2.isStarProjection())) continue;
            destination.add(element);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            it2 = (TypeProjection)item;
            Collection collection2 = destination;
            JetType jetType = it2.getType();
            collection2.add(jetType);
        }
        $receiver3 = (List)destination;
        $receiver2 = $receiver3;
        destination = new ArrayList();
        for (Object element : $receiver2) {
            it2 = (JetType)element;
            Iterable list = TypeUtilsKt.getContainedTypeParameters((JetType)it2);
            CollectionsKt.addAll(destination, list);
        }
        return (List)destination;
    }

    @NotNull
    public static final Collection<TypeParameterDescriptor> getCapturedTypeParameters(DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        LinkedHashSet<TypeParameterDescriptor> result2 = new LinkedHashSet<TypeParameterDescriptor>();
        DeclarationDescriptor containingDeclaration = $receiver.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            result2.addAll(TypeUtilsKt.getContainedTypeParameters(((ClassDescriptor)containingDeclaration).getDefaultType()));
        } else if (containingDeclaration instanceof CallableDescriptor) {
            Collection collection = ((CallableDescriptor)containingDeclaration).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "containingDeclaration.getTypeParameters()");
            result2.addAll(collection);
        }
        if (containingDeclaration != null) {
            result2.addAll(TypeUtilsKt.getCapturedTypeParameters(containingDeclaration));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<TypeConstructor> getContainedAndCapturedTypeParameterConstructors(JetType $receiver) {
        void destination;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Object object = $receiver.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = TypeUtilsKt.getCapturedTypeParameters((DeclarationDescriptor)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object capturedTypeParameters = object;
        List<TypeParameterDescriptor> typeParameters = CollectionsKt.plus(TypeUtilsKt.getContainedTypeParameters($receiver), (Iterable)capturedTypeParameters);
        Iterable $receiver3 = typeParameters;
        Iterable iterable = $receiver3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item;
            void var9_9 = destination;
            TypeConstructor typeConstructor2 = it2.getTypeConstructor();
            var9_9.add(typeConstructor2);
        }
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList((List)destination);
    }

    public static final boolean isSubtypeOf(JetType $receiver, @NotNull JetType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return JetTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    public static final boolean cannotBeReified(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothingOrNullableNothing($receiver) || DynamicTypesKt.isDynamic($receiver);
    }

    @NotNull
    public static final TypeProjection substitute(TypeProjection $receiver, @NotNull Function1<? super JetType, ? extends JetType> doSubstitute) {
        TypeProjection typeProjection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(doSubstitute, "doSubstitute");
        if ($receiver.isStarProjection()) {
            typeProjection = $receiver;
        } else {
            Variance variance = $receiver.getProjectionKind();
            JetType jetType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "getType()");
            typeProjection = new TypeProjectionImpl(variance, doSubstitute.invoke(jetType));
        }
        return typeProjection;
    }

    @NotNull
    public static final JetType replaceAnnotations(JetType $receiver, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        if (newAnnotations.isEmpty()) {
            return $receiver;
        }
        return new DelegatingType($receiver, newAnnotations){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ JetType receiver$0;
            final /* synthetic */ Annotations $newAnnotations;

            static {
                $kotlinClass = Reflection.createKotlinClass(replaceAnnotations.1.class);
            }

            @NotNull
            protected JetType getDelegate() {
                return this.receiver$0;
            }

            @NotNull
            public Annotations getAnnotations() {
                return this.$newAnnotations;
            }
            {
                this.receiver$0 = $receiver;
                this.$newAnnotations = $captured_local_variable$1;
            }
        };
    }

    public static final boolean equalTypesOrNulls(JetTypeChecker $receiver, @Nullable JetType type1, @Nullable JetType type2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return $receiver.equalTypes(type1, type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getNestedArguments(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList<TypeProjection> result2 = new ArrayList<TypeProjection>();
        ArrayDeque<TypeProjection> stack = new ArrayDeque<TypeProjection>();
        stack.push(new TypeProjectionImpl($receiver));
        while (!stack.isEmpty()) {
            void $receiver2;
            TypeProjection typeProjection = (TypeProjection)stack.pop();
            if (typeProjection.isStarProjection()) continue;
            result2.add(typeProjection);
            Iterable iterable = typeProjection.getType().getArguments();
            for (Object element : $receiver2) {
                TypeProjection it2 = (TypeProjection)element;
                stack.add(it2);
            }
        }
        return result2;
    }

    public static final boolean containsError(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ErrorUtils.containsErrorType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> defaultProjections(List<? extends JetType> $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver3 = $receiver;
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver3, 10));
        for (Object item : $receiver2) {
            void it2;
            JetType jetType = (JetType)item;
            Collection collection = destination;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((JetType)it2);
            collection.add(typeProjectionImpl);
        }
        return (List)var3_3;
    }

    public static final boolean isDefaultBound(JetType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isDefaultBound(TypeCapabilitiesKt.getSupertypeRepresentative($receiver));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull JetType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl(Intrinsics.areEqual((Object)(typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null), (Object)projectionKind) ? Variance.INVARIANT : projectionKind, type2);
    }
}

