/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractJetType;
import kotlin.reflect.jvm.internal.impl.types.CommonSupertypes;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.LazyType;
import kotlin.reflect.jvm.internal.impl.types.NullAwareness;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    public static final JetType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final JetType PLACEHOLDER_FUNCTION_TYPE = ErrorUtils.createErrorTypeWithCustomDebugName("PLACEHOLDER_FUNCTION_TYPE");
    public static final JetType CANT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    public static final JetType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final JetType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "noExpectedType"));
        }
        return type2 == NO_EXPECTED_TYPE || type2 == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(@Nullable JetType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static JetType makeNullable(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullable"));
        }
        JetType jetType = TypeUtils.makeNullableAsSpecified(type2, true);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullable"));
        }
        return jetType;
    }

    @NotNull
    public static JetType makeNotNullable(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNotNullable"));
        }
        JetType jetType = TypeUtils.makeNullableAsSpecified(type2, false);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNotNullable"));
        }
        return jetType;
    }

    @NotNull
    public static JetType makeNullableAsSpecified(@NotNull JetType type2, boolean nullable2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableAsSpecified"));
        }
        NullAwareness nullAwareness = type2.getCapability(NullAwareness.class);
        if (nullAwareness != null) {
            JetType jetType = nullAwareness.makeNullableAsSpecified(nullable2);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return jetType;
        }
        if (type2 instanceof AbstractTypeWithKnownNullability) {
            JetType jetType = TypeUtils.makeNullableAsSpecified(((AbstractTypeWithKnownNullability)type2).delegate, nullable2);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return jetType;
        }
        if (!(type2 instanceof LazyType) && type2.isMarkedNullable() == nullable2) {
            JetType jetType = type2;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableAsSpecified"));
            }
            return jetType;
        }
        AbstractTypeWithKnownNullability abstractTypeWithKnownNullability = nullable2 ? new NullableType(type2) : new NotNullType(type2);
        if (abstractTypeWithKnownNullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableAsSpecified"));
        }
        return abstractTypeWithKnownNullability;
    }

    @NotNull
    public static JetType makeNullableIfNeeded(@NotNull JetType type2, boolean nullable2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableIfNeeded"));
        }
        if (nullable2) {
            JetType jetType = TypeUtils.makeNullable(type2);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableIfNeeded"));
            }
            return jetType;
        }
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeNullableIfNeeded"));
        }
        return jetType;
    }

    public static boolean canHaveSubtypes(JetTypeChecker typeChecker, @NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "canHaveSubtypes"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (!type2.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        int parametersSize = parameters2.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            TypeProjection typeProjection = arguments2.get(i);
            Variance projectionKind = typeProjection.getProjectionKind();
            JetType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(JetTypeChecker typeChecker, JetType argument, TypeParameterDescriptor parameterDescriptor) {
        for (JetType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JetType makeUnsubstitutedType(ClassDescriptor classDescriptor, JetScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            JetType jetType = ErrorUtils.createErrorType("Unsubstituted type for " + classDescriptor);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeUnsubstitutedType"));
            }
            return jetType;
        }
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        List<TypeProjection> arguments2 = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(Annotations.EMPTY, typeConstructor2, false, arguments2, unsubstitutedMemberScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeUnsubstitutedType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(@NotNull List<TypeParameterDescriptor> parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getDefaultTypeProjections"));
        }
        ArrayList<TypeProjectionImpl> result2 = new ArrayList<TypeProjectionImpl>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            result2.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        List<TypeProjection> list = UtilsPackage.toReadOnlyList(result2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getDefaultTypeProjections"));
        }
        return list;
    }

    @NotNull
    public static List<JetType> getImmediateSupertypes(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getImmediateSupertypes"));
        }
        boolean isNullable = type2.isMarkedNullable();
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        Collection<JetType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<JetType> result2 = new ArrayList<JetType>(originalSupertypes.size());
        for (JetType supertype : originalSupertypes) {
            JetType substitutedType = substitutor2.substitute(supertype, Variance.INVARIANT);
            if (substitutedType == null) continue;
            result2.add(TypeUtils.makeNullableIfNeeded(substitutedType, isNullable));
        }
        ArrayList<JetType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getImmediateSupertypes"));
        }
        return arrayList;
    }

    private static void collectAllSupertypes(@NotNull JetType type2, @NotNull Set<JetType> result2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "collectAllSupertypes"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "collectAllSupertypes"));
        }
        List<JetType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type2);
        result2.addAll(immediateSupertypes);
        for (JetType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result2);
        }
    }

    @NotNull
    public static Set<JetType> getAllSupertypes(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getAllSupertypes"));
        }
        LinkedHashSet<JetType> result2 = new LinkedHashSet<JetType>(15);
        TypeUtils.collectAllSupertypes(type2, result2);
        LinkedHashSet<JetType> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getAllSupertypes"));
        }
        return linkedHashSet;
    }

    public static boolean hasNullableLowerBound(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "hasNullableLowerBound"));
        }
        for (JetType bound : typeParameterDescriptor.getLowerBounds()) {
            if (!bound.isMarkedNullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullableType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "isNullableType"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (TypesPackage.isFlexible(type2) && TypeUtils.isNullableType(TypesPackage.flexibility(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        return false;
    }

    public static boolean acceptsNullable(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "acceptsNullable"));
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (TypesPackage.isFlexible(type2) && TypeUtils.acceptsNullable(TypesPackage.flexibility(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableLowerBound((TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor());
        }
        return false;
    }

    public static boolean hasNullableSuperType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "hasNullableSuperType"));
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (JetType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (supertype.isMarkedNullable()) {
                return true;
            }
            if (!TypeUtils.hasNullableSuperType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getClassDescriptor"));
        }
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static JetType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<JetType> typeArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteParameters"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteParameters"));
        }
        List<TypeProjection> projections = KotlinPackage.map(typeArguments, new Function1<JetType, TypeProjection>(){

            @Override
            public TypeProjection invoke(JetType type2) {
                return new TypeProjectionImpl(type2);
            }
        });
        JetType jetType = TypeUtils.substituteProjectionsForParameters(clazz, projections);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteParameters"));
        }
        return jetType;
    }

    @NotNull
    public static JetType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        if (projections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projections", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = UtilsPackage.newHashMapWithExpectedSize(clazzTypeParameters.size());
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor2 = clazzTypeParameters.get(i).getTypeConstructor();
            substitutions.put(typeConstructor2, projections.get(i));
        }
        JetType jetType = TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "substituteProjectionsForParameters"));
        }
        return jetType;
    }

    public static boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "equalTypes"));
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(a, b) && JetTypeChecker.DEFAULT.isSubtypeOf(b, a);
    }

    public static boolean dependsOnTypeParameters(@NotNull JetType type2, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "dependsOnTypeParameters"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "dependsOnTypeParameters"));
        }
        return TypeUtils.dependsOnTypeConstructors(type2, KotlinPackage.map(typeParameters, new Function1<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                if (typeParameterDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$2", "invoke"));
                }
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull JetType type2, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterConstructors", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "dependsOnTypeConstructors"));
        }
        if (typeParameterConstructors.contains(type2.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSpecialType(@Nullable JetType type2, final @NotNull JetType specialType) {
        if (specialType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specialType", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "containsSpecialType"));
        }
        return TypeUtils.containsSpecialType(type2, new Function1<JetType, Boolean>(){

            @Override
            public Boolean invoke(JetType type2) {
                return ((Object)specialType).equals(type2);
            }
        });
    }

    public static boolean containsSpecialType(@Nullable JetType type2, @NotNull Function1<JetType, Boolean> isSpecialType) {
        if (isSpecialType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isSpecialType", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "containsSpecialType"));
        }
        if (type2 == null) {
            return false;
        }
        if (isSpecialType.invoke(type2).booleanValue()) {
            return true;
        }
        Flexibility flexibility = type2.getCapability(Flexibility.class);
        if (flexibility != null && (TypeUtils.containsSpecialType(flexibility.getLowerBound(), isSpecialType) || TypeUtils.containsSpecialType(flexibility.getUpperBound(), isSpecialType))) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.containsSpecialType(projection.getType(), isSpecialType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeStarProjection"));
        }
        StarProjectionImpl starProjectionImpl = new StarProjectionImpl(parameterDescriptor);
        if (starProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "makeStarProjection"));
        }
        return starProjectionImpl;
    }

    @Nullable
    public static JetType commonSupertypeForNumberTypes(@NotNull Collection<JetType> numberLowerBounds) {
        if (numberLowerBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberLowerBounds", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "commonSupertypeForNumberTypes"));
        }
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        Set<JetType> intersectionOfSupertypes = TypeUtils.getIntersectionOfSupertypes(numberLowerBounds);
        JetType primitiveNumberType = TypeUtils.getDefaultPrimitiveNumberType(intersectionOfSupertypes);
        if (primitiveNumberType != null) {
            return primitiveNumberType;
        }
        return CommonSupertypes.commonSupertype(numberLowerBounds);
    }

    @NotNull
    private static Set<JetType> getIntersectionOfSupertypes(@NotNull Collection<JetType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getIntersectionOfSupertypes"));
        }
        HashSet<JetType> upperBounds = new HashSet<JetType>();
        for (JetType type2 : types2) {
            Collection<JetType> supertypes2 = type2.getConstructor().getSupertypes();
            if (upperBounds.isEmpty()) {
                upperBounds.addAll(supertypes2);
                continue;
            }
            upperBounds.retainAll(supertypes2);
        }
        HashSet<JetType> hashSet = upperBounds;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getIntersectionOfSupertypes"));
        }
        return hashSet;
    }

    @NotNull
    public static JetType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        JetType type2 = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type2 != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". " + "Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        return jetType;
    }

    @Nullable
    private static JetType getDefaultPrimitiveNumberType(@NotNull Collection<JetType> supertypes2) {
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getDefaultPrimitiveNumberType"));
        }
        JetType doubleType = KotlinBuiltIns.getInstance().getDoubleType();
        if (supertypes2.contains(doubleType)) {
            return doubleType;
        }
        JetType intType = KotlinBuiltIns.getInstance().getIntType();
        if (supertypes2.contains(intType)) {
            return intType;
        }
        JetType longType = KotlinBuiltIns.getInstance().getLongType();
        if (supertypes2.contains(longType)) {
            return longType;
        }
        return null;
    }

    @NotNull
    public static JetType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull JetType expectedType) {
        if (numberValueTypeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValueTypeConstructor", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getPrimitiveNumberType"));
        }
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            JetType jetType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return jetType;
        }
        for (JetType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            JetType jetType = primitiveNumberType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getPrimitiveNumberType"));
            }
            return jetType;
        }
        JetType jetType = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getPrimitiveNumberType"));
        }
        return jetType;
    }

    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull JetType type2, final @NotNull Map<TypeConstructor, Set<JetType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (constructorToAllInstances == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorToAllInstances", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        return DFS.dfs(Collections.singletonList(type2), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                TypeSubstitutor substitutor2 = TypeSubstitutor.create(current);
                Collection<JetType> supertypes2 = current.getConstructor().getSupertypes();
                ArrayList<JetType> result2 = new ArrayList<JetType>(supertypes2.size());
                for (JetType supertype : supertypes2) {
                    if (visited.contains(supertype.getConstructor())) continue;
                    result2.add(substitutor2.safeSubstitute(supertype, Variance.INVARIANT));
                }
                ArrayList<JetType> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$4", "getNeighbors"));
                }
                return arrayList;
            }
        }, new DFS.Visited<JetType>(){

            @Override
            public boolean checkAndMarkVisited(JetType current) {
                return visited.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(JetType current) {
                TypeConstructor constructor = current.getConstructor();
                HashSet<JetType> instances = (HashSet<JetType>)constructorToAllInstances.get(constructor);
                if (instances == null) {
                    instances = new HashSet<JetType>();
                    constructorToAllInstances.put(constructor, instances);
                }
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(JetType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
    }

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors2, JetType type2) {
        final HashSet<TypeConstructor> constructors2 = UtilsPackage.newHashSetWithExpectedSize(typeParameterDescriptors2.size());
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors2) {
            constructors2.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjectionImpl projection = new TypeProjectionImpl(type2);
        return TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Override
            public TypeProjection get(@NotNull TypeConstructor key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$7", "get"));
                }
                if (constructors2.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    public static boolean isTypeParameter(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "isTypeParameter"));
        }
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null;
    }

    public static boolean isNonReifiedTypeParemeter(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "isNonReifiedTypeParemeter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        return typeParameterDescriptor != null && !typeParameterDescriptor.isReified();
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeUtils", "getTypeParameterDescriptorOrNull"));
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    private static class NotNullType
    extends AbstractTypeWithKnownNullability {
        private NotNullType(@NotNull JetType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$NotNullType", "<init>"));
            }
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }
    }

    private static class NullableType
    extends AbstractTypeWithKnownNullability {
        private NullableType(@NotNull JetType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$NullableType", "<init>"));
            }
            super(delegate2);
        }

        @Override
        public boolean isMarkedNullable() {
            return true;
        }
    }

    private static abstract class AbstractTypeWithKnownNullability
    extends AbstractJetType {
        private final JetType delegate;

        private AbstractTypeWithKnownNullability(@NotNull JetType delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "<init>"));
            }
            this.delegate = delegate2;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor2 = this.delegate.getConstructor();
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getConstructor"));
            }
            return typeConstructor2;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list = this.delegate.getArguments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getArguments"));
            }
            return list;
        }

        @Override
        public abstract boolean isMarkedNullable();

        @Override
        @NotNull
        public JetScope getMemberScope() {
            JetScope jetScope = this.delegate.getMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getMemberScope"));
            }
            return jetScope;
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = this.delegate.getAnnotations();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @NotNull
        public TypeSubstitution getSubstitution() {
            TypeSubstitution typeSubstitution = this.delegate.getSubstitution();
            if (typeSubstitution == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getSubstitution"));
            }
            return typeSubstitution;
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getCapability"));
            }
            return this.delegate.getCapability(capabilityClass);
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            TypeCapabilities typeCapabilities = this.delegate.getCapabilities();
            if (typeCapabilities == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$AbstractTypeWithKnownNullability", "getCapabilities"));
            }
            return typeCapabilities;
        }
    }

    public static class SpecialType
    implements JetType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public TypeSubstitution getSubstitution() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isMarkedNullable() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$SpecialType", "getCapability"));
            }
            return null;
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            TypeCapabilities.NONE nONE = TypeCapabilities.NONE.INSTANCE$;
            if (nONE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeUtils$SpecialType", "getCapabilities"));
            }
            return nONE;
        }

        public String toString() {
            return this.name;
        }
    }
}

