/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.org.jdom.Element;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){};

    private XmlSerializer() {
    }

    @Nullable
    public static <T> T deserialize(Element element, Class<T> aClass) throws XmlSerializationException {
        try {
            return (T)XmlSerializerImpl.getBinding(aClass).deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        XmlSerializer.deserializeInto(bean, element, null);
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            ((BeanBinding)XmlSerializerImpl.getBinding(bean.getClass())).deserializeInto(bean, element, accessorNameTracker);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

