/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<H, T> myFunction;
    @NotNull
    private final Key<?> myModifyCause;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<H, T> function, @NotNull Key<?> modifyCause) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/PsiCacheKey", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/util/PsiCacheKey", "<init>"));
        }
        if (modifyCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifyCause", "com/intellij/psi/util/PsiCacheKey", "<init>"));
        }
        super(name);
        this.myFunction = function;
        this.myModifyCause = modifyCause;
    }

    public final T getValue(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "com/intellij/psi/util/PsiCacheKey", "getValue"));
        }
        T result2 = this.getCachedValueOrNull(h);
        if (result2 != null) {
            return result2;
        }
        result2 = this.myFunction.fun(h);
        long count = this.getModificationCount(h.getManager().getModificationTracker());
        h.putUserData(this, new SoftReference<Pair<Long, T>>(new Pair<Long, T>(count, result2)));
        return result2;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "com/intellij/psi/util/PsiCacheKey", "getCachedValueOrNull"));
        }
        SoftReference ref = (SoftReference)h.getUserData(this);
        Pair data2 = (Pair)SoftReference.dereference(ref);
        if (data2 == null || ((Long)data2.getFirst()).longValue() != this.getModificationCount(h.getManager().getModificationTracker())) {
            return null;
        }
        return (T)data2.getSecond();
    }

    private long getModificationCount(@NotNull PsiModificationTracker tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/psi/util/PsiCacheKey", "getModificationCount"));
        }
        if (this.myModifyCause.equals(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT)) {
            return tracker.getJavaStructureModificationCount();
        }
        if (this.myModifyCause.equals(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT)) {
            return tracker.getOutOfCodeBlockModificationCount();
        }
        if (this.myModifyCause.equals(PsiModificationTracker.MODIFICATION_COUNT)) {
            return tracker.getModificationCount();
        }
        throw new AssertionError((Object)("No modification tracker found for key " + this.myModifyCause));
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<H, T> function, @NotNull Key<?> modifyCause) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        if (modifyCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifyCause", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        return new PsiCacheKey<T, H>(name, function, modifyCause);
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/util/PsiCacheKey", "create"));
        }
        return PsiCacheKey.create(name, function, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
    }
}

