/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project) {
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/source/text/BlockSupportImpl$1", "updateStarted"));
                }
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            }
        });
    }

    @Override
    public void reparseRange(PsiFile file, int startOffset, int endOffset, CharSequence newTextS) throws IncorrectOperationException {
        LOG.assertTrue(file.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newTextS);
        PsiDocumentManager.getInstance(psiFile.getProject()).commitDocument(document);
    }

    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (changedPsiRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedPsiRange", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        PsiFileImpl fileImpl = (PsiFileImpl)file;
        Couple<ASTNode> reparseableRoots = this.findReparseableRoots(fileImpl, changedPsiRange, newFileText);
        DiffLog diffLog = reparseableRoots != null ? BlockSupportImpl.mergeTrees(fileImpl, (ASTNode)reparseableRoots.first, (ASTNode)reparseableRoots.second, indicator, lastCommittedText) : BlockSupportImpl.makeFullParse(fileImpl, newFileText, indicator, lastCommittedText);
        if (diffLog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "reparseRange"));
        }
        return diffLog;
    }

    @Nullable
    public Couple<ASTNode> findReparseableRoots(@NotNull PsiFileImpl file, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        if (changedPsiRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedPsiRange", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "findReparseableRoots"));
        }
        Project project = file.getProject();
        FileElement fileElement = file.getTreeElement();
        CharTable charTable = fileElement.getCharTable();
        int lengthShift = newFileText.length() - fileElement.getTextLength();
        if (fileElement.getElementType() instanceof ITemplateDataElementType || BlockSupportImpl.isTooDeep(file)) {
            return null;
        }
        LeafElement leafAtStart = fileElement.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        LeafElement leafAtEnd = fileElement.findLeafElementAt(Math.min(changedPsiRange.getEndOffset(), fileElement.getTextLength() - 1));
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        for (ASTNode node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : fileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (!baseLanguage.isKindOf(reparseable.getLanguage()) || textRange.getLength() + lengthShift <= 0) continue;
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + lengthShift;
            if (end > newFileText.length()) {
                BlockSupportImpl.reportInconsistentLength(file, newFileText, node, start, end);
                break;
            }
            CharSequence newTextStr = newFileText.subSequence(start, end);
            if (!reparseable.isParsable(node.getTreeParent(), newTextStr, baseLanguage, project) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(file.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            if (holder.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + holder.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            return Couple.of(node, chameleon);
        }
        return null;
    }

    private static void reportInconsistentLength(PsiFile file, CharSequence newFileText, ASTNode node, int start, int end) {
        String message = "Index out of bounds: type=" + node.getElementType() + "; file=" + file + "; file.class=" + file.getClass() + "; start=" + start + "; end=" + end + "; length=" + node.getTextLength();
        String newTextBefore = newFileText.subSequence(0, start).toString();
        String oldTextBefore = file.getText().subSequence(0, start).toString();
        if (oldTextBefore.equals(newTextBefore)) {
            message = message + "; oldTextBefore==newTextBefore";
        }
        LOG.error(message, new Attachment(file.getName() + "_oldNodeText.txt", node.getText()), new Attachment(file.getName() + "_oldFileText.txt", file.getText()), new Attachment(file.getName() + "_newFileText.txt", newFileText.toString()));
    }

    @NotNull
    private static DiffLog makeFullParse(@NotNull PsiFileImpl fileImpl, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (newFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement parent = fileImpl.getTreeElement();
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), null).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, newFileText.length())));
            DiffLog diffLog = new DiffLog();
            diffLog.appendReplaceFileElement(parent, (FileElement)holderElement.getFirstChildNode());
            DiffLog diffLog2 = diffLog;
            if (diffLog2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
            }
            return diffLog2;
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getViewProvider().getModificationStamp());
        lightFile.setOriginalFile(viewProvider.getVirtualFile());
        FileViewProvider copy2 = viewProvider.createCopy(lightFile);
        if (copy2.isEventSystemEnabled()) {
            throw new AssertionError((Object)("Copied view provider must be non-physical for reparse to deliver correct events: " + viewProvider));
        }
        copy2.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit(lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, copy2);
        newFile.setOriginalFile(fileImpl);
        FileElement newFileElement = (FileElement)newFile.getNode();
        FileElement oldFileElement = (FileElement)fileImpl.getNode();
        if (!lastCommittedText.toString().equals(oldFileElement.getText())) {
            throw new IncorrectOperationException();
        }
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement, indicator, lastCommittedText);
        ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider(lightFile, null);
        DiffLog diffLog3 = diffLog;
        if (diffLog3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "makeFullParse"));
        }
        return diffLog3;
    }

    @NotNull
    public static PsiFileImpl getFileCopy(@NotNull PsiFileImpl originalFile, @NotNull FileViewProvider providerCopy) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/psi/impl/source/text/BlockSupportImpl", "getFileCopy"));
        }
        if (providerCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerCopy", "com/intellij/psi/impl/source/text/BlockSupportImpl", "getFileCopy"));
        }
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFile file = providerCopy.getPsi(language);
        if (file != null && !(file instanceof PsiFileImpl)) {
            throw new RuntimeException("View provider " + viewProvider + " refused to provide PsiFileImpl for " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl newFile = (PsiFileImpl)file;
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl psiFileImpl = newFile;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "getFileCopy"));
        }
        return psiFileImpl;
    }

    private static String details(FileViewProvider providerCopy, FileViewProvider viewProvider) {
        return "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null);
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        DiffLog diffLog = new DiffLog();
        diffLog.appendReplaceElementWithEvents(oldRoot, newRoot);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "replaceElementWithEvents"));
        }
        return diffLog2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        block17: {
            DiffLog diffLog;
            block16: {
                if (fileImpl == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (oldRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (newRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (lastCommittedText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                }
                if (newRoot instanceof FileElement) {
                    ((FileElement)newRoot).setCharTable(fileImpl.getTreeElement().getCharTable());
                }
                try {
                    newRoot.putUserData(TREE_TO_BE_REPARSED, Pair.create(oldRoot, lastCommittedText));
                    if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                        DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
                        fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                        DiffLog diffLog2 = treeChangeEvent;
                        diffLog = diffLog2;
                        break block16;
                    }
                    newRoot.getFirstChildNode();
                    break block17;
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    DiffLog diffLog3 = e.getDiffLog();
                    DiffLog diffLog4 = diffLog3;
                    if (diffLog4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
                    }
                    return diffLog4;
                }
            }
            if (diffLog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
            }
            return diffLog;
            finally {
                newRoot.putUserData(TREE_TO_BE_REPARSED, null);
            }
        }
        ASTShallowComparator comparator2 = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog, comparator2, treeStructure, indicator, lastCommittedText);
        DiffLog diffLog5 = diffLog;
        if (diffLog5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/text/BlockSupportImpl", "mergeTrees"));
        }
        return diffLog5;
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder, @NotNull ShallowNodeComparator<ASTNode, T> comparator2, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (newTreeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTreeStructure", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/source/text/BlockSupportImpl", "diffTrees"));
        }
        TreeUtil.ensureParsedRecursivelyCheckingProgress(oldRoot, indicator);
        DiffTree.diff(BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator2, builder, lastCommittedText);
    }

    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @NotNull ProgressIndicator indicator) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "createInterruptibleASTStructure"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/text/BlockSupportImpl", "createInterruptibleASTStructure"));
        }
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                if (astNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/psi/impl/source/text/BlockSupportImpl$2", "getChildren"));
                }
                if (into == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "com/intellij/psi/impl/source/text/BlockSupportImpl$2", "getChildren"));
                }
                indicator.checkCanceled();
                return super.getChildren(astNode, into);
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        if (fileImpl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileImpl", "com/intellij/psi/impl/source/text/BlockSupportImpl", "isReplaceWholeNode"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "com/intellij/psi/impl/source/text/BlockSupportImpl", "isReplaceWholeNode"));
        }
        Boolean data2 = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY);
        if (data2 != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data2)) || BlockSupportImpl.isTooDeep(fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep(childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    public static void sendBeforeChildrenChangeEvent(@NotNull PsiManagerImpl manager, @NotNull PsiElement scope2, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendBeforeChildrenChangeEvent"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendBeforeChildrenChangeEvent"));
        }
        if (!scope2.isPhysical()) {
            manager.beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope2);
        event.setFile(scope2.getContainingFile());
        TextRange range = scope2.getTextRange();
        event.setOffset(range == null ? 0 : range.getStartOffset());
        event.setOldLength(scope2.getTextLength());
        event.setGenericChange(isGenericChange);
        manager.beforeChildrenChange(event);
    }

    public static void sendAfterChildrenChangedEvent(@NotNull PsiManagerImpl manager, @NotNull PsiFile scope2, int oldLength, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendAfterChildrenChangedEvent"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/text/BlockSupportImpl", "sendAfterChildrenChangedEvent"));
        }
        if (!scope2.isPhysical()) {
            manager.afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope2);
        event.setFile(scope2);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGenericChange(isGenericChange);
        manager.childrenChanged(event);
    }
}

