/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaDummyHolder
extends DummyHolder
implements PsiImportHolder {
    private static final Map<String, PsiClass> EMPTY = Collections.emptyMap();
    private Map<String, PsiClass> myPseudoImports;

    public JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, contentElement, context, null, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, null, table, validity, JavaLanguage.INSTANCE);
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, context, null, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, contentElement, context, table, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, context, table, null, JavaDummyHolder.language(context, JavaLanguage.INSTANCE));
        this.myPseudoImports = EMPTY;
    }

    public JavaDummyHolder(@NotNull PsiManager manager, CharTable table) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/JavaDummyHolder", "<init>"));
        }
        super(manager, null, null, table, null, JavaLanguage.INSTANCE);
        this.myPseudoImports = EMPTY;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        PsiClass resolved;
        if (this.myContext != null && (resolved = JavaPsiFacade.getInstance(this.getProject()).getResolveHelper().resolveReferencedClass(aClass.getName(), this.myContext)) != null) {
            return this.getManager().areElementsEquivalent(aClass, resolved);
        }
        String className = aClass.getName();
        if (!this.myPseudoImports.containsKey(className)) {
            if (this.myPseudoImports == EMPTY) {
                this.myPseudoImports = new LinkedHashMap<String, PsiClass>();
            }
            this.myPseudoImports.put(className, aClass);
            this.myManager.beforeChange(false);
            return true;
        }
        return true;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/JavaDummyHolder", "processDeclarations"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            String name;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            String string = name = nameHint != null ? nameHint.getName(state) : null;
            if (name != null) {
                PsiClass imported = this.myPseudoImports.get(name);
                if (imported != null && !processor.execute(imported, state)) {
                    return false;
                }
            } else {
                for (PsiClass aClass : this.myPseudoImports.values()) {
                    if (processor.execute(aClass, state)) continue;
                    return false;
                }
            }
            if (this.myContext == null && !JavaResolveUtil.processImplicitlyImportedPackages(processor, state, place, this.getManager())) {
                return false;
            }
        }
        return true;
    }

    public boolean isSamePackage(PsiElement other) {
        if (other instanceof DummyHolder) {
            PsiElement otherContext = ((DummyHolder)other).myContext;
            if (this.myContext == null) {
                return otherContext == null;
            }
            return JavaPsiFacade.getInstance(this.myContext.getProject()).arePackagesTheSame(this.myContext, otherContext);
        }
        if (other instanceof PsiJavaFile) {
            if (this.myContext != null) {
                return JavaPsiFacade.getInstance(this.myContext.getProject()).arePackagesTheSame(this.myContext, other);
            }
            String packageName = ((PsiJavaFile)other).getPackageName();
            return packageName.isEmpty();
        }
        return false;
    }

    public boolean isInPackage(PsiPackage aPackage) {
        if (this.myContext != null) {
            return JavaPsiFacade.getInstance(this.myContext.getProject()).isInPackage(this.myContext, aPackage);
        }
        return aPackage == null || aPackage.getQualifiedName().isEmpty();
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/psi/impl/source/JavaDummyHolder", "setOriginalFile"));
        }
        super.setOriginalFile(originalFile);
        this.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, PsiUtil.getLanguageLevel(originalFile));
    }
}

