/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure;

import io.ktor.network.sockets.ServerSocket;
import io.ktor.network.sockets.Socket;
import java.io.Closeable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.experimental.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteReadChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteWriteChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.DefaultAuthorizableClient;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerBase;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerSocketWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.StreamWrappersKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002:\b*+,-./01J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u001f\u001a\u00020\u00162\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015H\u0016J)\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u001eH\u0016R.\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000b\u0010\n\u001a\u00020\u000b8BX\u0082\u0004R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server;", "T", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "clients", "Ljava/util/HashMap;", "Lio/ktor/network/sockets/Socket;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ClientInfo;", "Lkotlin/collections/HashMap;", "getClients", "()Ljava/util/HashMap;", "log", "Ljava/util/logging/Logger;", "serverPort", "", "getServerPort", "()I", "serverSocketWithPort", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "getServerSocketWithPort", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "attachClient", "Lkotlinx/coroutines/Deferred;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$State;", "client", "checkClientCanReadFile", "", "clientInputChannel", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dealWithClient", "", "processMessage", "msg", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "runServer", "serverHandshake", "input", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;Ljava/util/logging/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdownClient", "shutdownServer", "AnyMessage", "ClientInfo", "EndConnectionMessage", "KeepAliveAcknowledgement", "KeepAliveMessage", "Message", "ServerDownMessage", "State", "daemon-common-new"})
public interface Server<T extends ServerBase>
extends ServerBase {
    @NotNull
    public ServerSocketWrapper getServerSocketWithPort();

    public int getServerPort();

    @NotNull
    public State processMessage(@NotNull AnyMessage<? super T> var1, @NotNull ByteWriteChannelWrapper var2);

    @NotNull
    public Deferred<State> attachClient(@NotNull Socket var1);

    @NotNull
    public HashMap<Socket, ClientInfo> getClients();

    @NotNull
    public Deferred<Unit> runServer();

    public void shutdownServer();

    @Nullable
    public Object checkClientCanReadFile(@NotNull ByteReadChannelWrapper var1, @NotNull Continuation<? super Boolean> var2);

    @Nullable
    public Object serverHandshake(@NotNull ByteReadChannelWrapper var1, @NotNull ByteWriteChannelWrapper var2, @NotNull Logger var3, @NotNull Continuation<? super Boolean> var4);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$State;", "", "(Ljava/lang/String;I)V", "WORKING", "CLOSED", "ERROR", "DOWNING", "UNVERIFIED", "daemon-common-new"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State WORKING = new State();
        public static final /* enum */ State CLOSED = new State();
        public static final /* enum */ State ERROR = new State();
        public static final /* enum */ State DOWNING = new State();
        public static final /* enum */ State UNVERIFIED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.WORKING, State.CLOSED, State.ERROR, State.DOWNING, State.UNVERIFIED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u0006R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Ljava/io/Serializable;", "()V", "messageId", "", "getMessageId", "()Ljava/lang/Integer;", "setMessageId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "withId", "id", "daemon-common-new"})
    public static abstract class AnyMessage<ServerType extends ServerBase>
    implements Serializable {
        @Nullable
        private Integer messageId;

        @Nullable
        public final Integer getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(@Nullable Integer n) {
            this.messageId = n;
        }

        @NotNull
        public final AnyMessage<ServerType> withId(int id) {
            this.messageId = id;
            return this;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ/\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00012\u0014\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00070\u000eH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$Message;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "process", "Lkotlinx/coroutines/Deferred;", "", "server", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;)Lkotlinx/coroutines/Deferred;", "processImpl", "sendReply", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "daemon-common-new"})
    public static abstract class Message<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
        @NotNull
        public final Deferred<Unit> process(@NotNull ServerType server, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(server, this, output, null){
                int label;
                final /* synthetic */ ServerType $server;
                final /* synthetic */ Message<ServerType> this$0;
                final /* synthetic */ ByteWriteChannelWrapper $output;
                {
                    this.$server = $server;
                    this.this$0 = $receiver;
                    this.$output = $output;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ClientUtilsKt.getLog().fine(this.$server + " starts processing " + this.this$0);
                            this.label = 1;
                            Object object3 = this.this$0.processImpl(this.$server, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this.$server, this.this$0, this.$output){
                                final /* synthetic */ ServerType $server;
                                final /* synthetic */ Message<ServerType> this$0;
                                final /* synthetic */ ByteWriteChannelWrapper $output;
                                {
                                    this.$server = $server;
                                    this.this$0 = $receiver;
                                    this.$output = $output;
                                    super(1);
                                }

                                public final void invoke(@Nullable Object it) {
                                    ClientUtilsKt.getLog().fine(this.$server + " finished processing " + this.this$0 + ", sending output");
                                    BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$server, this.this$0, this.$output, it, null){
                                        int label;
                                        final /* synthetic */ ServerType $server;
                                        final /* synthetic */ Message<ServerType> this$0;
                                        final /* synthetic */ ByteWriteChannelWrapper $output;
                                        final /* synthetic */ Object $it;
                                        {
                                            this.$server = $server;
                                            this.this$0 = $receiver;
                                            this.$output = $output;
                                            this.$it = $it;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    ClientUtilsKt.getLog().fine(this.$server + " starts sending " + this.this$0 + " to output");
                                                    v0 = this.this$0.getMessageId();
                                                    this.label = 1;
                                                    v1 = this.$output.writeObject(new DefaultAuthorizableClient.MessageReply<Object>(v0 != null ? v0 : -1, this.$it), (Continuation<? super Unit>)((Continuation)this));
                                                    if (v1 == var2_2) {
                                                        return var2_2;
                                                    }
                                                    ** GOTO lbl15
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl15:
                                                    // 2 sources

                                                    ClientUtilsKt.getLog().fine(this.$server + " finished sending " + this.this$0 + " to output");
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            }), (Continuation<Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Nullable
        public abstract Object processImpl(@NotNull ServerType var1, @NotNull Function1<Object, Unit> var2, @NotNull Continuation<? super Unit> var3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$EndConnectionMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class EndConnectionMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$KeepAliveAcknowledgement;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class KeepAliveAcknowledgement<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$KeepAliveMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class KeepAliveMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ServerDownMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class ServerDownMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ClientInfo;", "", "socket", "Lio/ktor/network/sockets/Socket;", "input", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "(Lio/ktor/network/sockets/Socket;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;)V", "getInput", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "getOutput", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "getSocket", "()Lio/ktor/network/sockets/Socket;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "daemon-common-new"})
    public static final class ClientInfo {
        @NotNull
        private final Socket socket;
        @NotNull
        private final ByteReadChannelWrapper input;
        @NotNull
        private final ByteWriteChannelWrapper output;

        public ClientInfo(@NotNull Socket socket, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.socket = socket;
            this.input = input;
            this.output = output;
        }

        @NotNull
        public final Socket getSocket() {
            return this.socket;
        }

        @NotNull
        public final ByteReadChannelWrapper getInput() {
            return this.input;
        }

        @NotNull
        public final ByteWriteChannelWrapper getOutput() {
            return this.output;
        }

        @NotNull
        public final Socket component1() {
            return this.socket;
        }

        @NotNull
        public final ByteReadChannelWrapper component2() {
            return this.input;
        }

        @NotNull
        public final ByteWriteChannelWrapper component3() {
            return this.output;
        }

        @NotNull
        public final ClientInfo copy(@NotNull Socket socket, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return new ClientInfo(socket, input, output);
        }

        public static /* synthetic */ ClientInfo copy$default(ClientInfo clientInfo, Socket socket, ByteReadChannelWrapper byteReadChannelWrapper, ByteWriteChannelWrapper byteWriteChannelWrapper, int n, Object object) {
            if ((n & 1) != 0) {
                socket = clientInfo.socket;
            }
            if ((n & 2) != 0) {
                byteReadChannelWrapper = clientInfo.input;
            }
            if ((n & 4) != 0) {
                byteWriteChannelWrapper = clientInfo.output;
            }
            return clientInfo.copy(socket, byteReadChannelWrapper, byteWriteChannelWrapper);
        }

        @NotNull
        public String toString() {
            return "ClientInfo(socket=" + this.socket + ", input=" + this.input + ", output=" + this.output + ')';
        }

        public int hashCode() {
            int result = this.socket.hashCode();
            result = result * 31 + this.input.hashCode();
            result = result * 31 + this.output.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientInfo)) {
                return false;
            }
            ClientInfo clientInfo = (ClientInfo)other;
            if (!Intrinsics.areEqual((Object)this.socket, (Object)clientInfo.socket)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.input, (Object)clientInfo.input)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)clientInfo.output);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T extends ServerBase> int getServerPort(@NotNull Server<? extends T> $this) {
            return $this.getServerSocketWithPort().getPort();
        }

        private static <T extends ServerBase> Logger getLog(Server<? extends T> $this) {
            Logger logger = Logger.getLogger("default server(" + $this.getServerPort() + ')');
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"default server($serverPort)\")");
            return logger;
        }

        @NotNull
        public static <T extends ServerBase> State processMessage(@NotNull Server<? extends T> $this, @NotNull AnyMessage<? super T> msg, @NotNull ByteWriteChannelWrapper output) {
            State state;
            Intrinsics.checkNotNullParameter(msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            AnyMessage<? super T> anyMessage = msg;
            if (anyMessage instanceof Message) {
                State state2;
                State it = state2 = State.WORKING;
                boolean bl = false;
                Message message = (Message)msg;
                Intrinsics.checkNotNull($this, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server.DefaultImpls.processMessage$lambda$0");
                message.process((ServerBase)$this, output);
                state = state2;
            } else {
                state = anyMessage instanceof EndConnectionMessage ? State.CLOSED : (anyMessage instanceof ServerDownMessage ? State.CLOSED : State.ERROR);
            }
            return state;
        }

        @NotNull
        public static <T extends ServerBase> Deferred<State> attachClient(@NotNull Server<? extends T> $this, @NotNull Socket client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super State>, Object>(client, $this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int label;
                final /* synthetic */ Socket $client;
                final /* synthetic */ Server<T> this$0;
                {
                    this.$client = $client;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block19: {
                        var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = StreamWrappersKt.openIO(this.$client, DefaultImpls.access$getLog(this.this$0));
                                input = var2_3.component1();
                                output = var2_3.component2();
                                this.L$0 = input;
                                this.L$1 = output;
                                this.label = 1;
                                v0 = this.this$0.serverHandshake(input, output, DefaultImpls.access$getLog(this.this$0), (Continuation<Boolean>)((Continuation)this));
                                if (v0 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl20
                            }
                            case 1: {
                                output = (ByteWriteChannelWrapper)this.L$1;
                                input = (ByteReadChannelWrapper)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl20:
                                // 2 sources

                                if (!((Boolean)v0).booleanValue()) {
                                    return State.UNVERIFIED;
                                }
                                this.L$0 = input;
                                this.L$1 = output;
                                this.label = 2;
                                v1 = this.this$0.checkClientCanReadFile(input, (Continuation<Boolean>)((Continuation)this));
                                if (v1 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl34
                            }
                            case 2: {
                                output = (ByteWriteChannelWrapper)this.L$1;
                                input = (ByteReadChannelWrapper)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl34:
                                // 2 sources

                                if (!((Boolean)v1).booleanValue()) {
                                    return State.UNVERIFIED;
                                }
                                ((Map)this.this$0.getClients()).put(this.$client, new ClientInfo(this.$client, input, output));
                                finalState = State.WORKING;
                                keepAliveAcknowledgement = new KeepAliveAcknowledgement<ServerType>();
lbl41:
                                // 4 sources

                                while (true) {
                                    this.L$0 = input;
                                    this.L$1 = output;
                                    this.L$2 = finalState;
                                    this.L$3 = keepAliveAcknowledgement;
                                    this.L$4 = null;
                                    this.label = 3;
                                    v2 = input.nextObject((Continuation<Object>)((Continuation)this));
                                    if (v2 == var11_2) {
                                        return var11_2;
                                    }
                                    ** GOTO lbl59
                                    break;
                                }
                            }
                            case 3: {
                                keepAliveAcknowledgement = (KeepAliveAcknowledgement<ServerType>)this.L$3;
                                finalState = (State)this.L$2;
                                output = (ByteWriteChannelWrapper)this.L$1;
                                input = (ByteReadChannelWrapper)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl59:
                                // 2 sources

                                if (!((var8_9 = (message = v2)) instanceof ServerDownMessage)) ** GOTO lbl62
                                DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                break block19;
lbl62:
                                // 1 sources

                                if (!(var8_9 instanceof KeepAliveMessage)) break;
                                var9_10 = State.WORKING;
                                $i$a$-also-Server$attachClient$1$1 = false;
                                v3 = ((KeepAliveMessage)message).getMessageId();
                                Intrinsics.checkNotNull((Object)v3);
                                this.L$0 = input;
                                this.L$1 = output;
                                this.L$2 = finalState;
                                this.L$3 = keepAliveAcknowledgement;
                                this.L$4 = var9_10;
                                this.label = 4;
                                v4 = output.writeObject(new DefaultAuthorizableClient.MessageReply<KeepAliveAcknowledgement<ServerType>>(v3, keepAliveAcknowledgement), (Continuation<? super Unit>)this);
                                if (v4 != var11_2) ** GOTO lbl41
                                return var11_2;
                            }
                            case 4: {
                                $i$a$-also-Server$attachClient$1$1 = false;
                                var9_10 = (State)this.L$4;
                                keepAliveAcknowledgement = (KeepAliveAcknowledgement)this.L$3;
                                finalState = (State)this.L$2;
                                output = (ByteWriteChannelWrapper)this.L$1;
                                input = (ByteReadChannelWrapper)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                ** GOTO lbl41
                            }
                        }
                        if (!(var8_9 instanceof AnyMessage)) {
                            finalState = State.ERROR;
                        } else {
                            Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server.AnyMessage<T of org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server>");
                            state = this.this$0.processMessage((AnyMessage)message, output);
                            switch (attachClient.WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                                case 1: {
                                    ** continue;
                                }
                                case 2: {
                                    finalState = State.ERROR;
                                    break;
                                }
                                default: {
                                    finalState = state;
                                    break;
                                }
                            }
                        }
                    }
                    return finalState;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super State> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private static <T extends ServerBase> Deferred<Unit> dealWithClient(Server<? extends T> $this, Socket client) {
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, client, null){
                int label;
                final /* synthetic */ Server<T> this$0;
                final /* synthetic */ Socket $client;
                {
                    this.this$0 = $receiver;
                    this.$client = $client;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = this.this$0.attachClient(this.$client).await((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var3_4 = state = (State)v0;
                            switch (dealWithClient.WhenMappings.$EnumSwitchMapping$0[var3_4.ordinal()]) {
                                case 1: 
                                case 2: {
                                    DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                    break;
                                }
                                case 3: {
                                    this.this$0.shutdownServer();
                                    break;
                                }
                                default: {
                                    DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public static <T extends ServerBase> Deferred<Unit> runServer(@NotNull Server<? extends T> $this) {
            ServerSocket serverSocket = $this.getServerSocketWithPort().getSocket();
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(serverSocket, $this, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                final /* synthetic */ ServerSocket $serverSocket;
                final /* synthetic */ Server<T> this$0;
                {
                    this.$serverSocket = $serverSocket;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = (Closeable)this.$serverSocket;
                            var3_4 = this.this$0;
                            var4_5 = this.$serverSocket;
                            var5_6 = null;
                            try {
                                (ServerSocket)var2_3;
                                $i$a$-use-Server$runServer$1$1 = false;
                            }
                            catch (Throwable var6_9) {
                                var5_6 = var6_9;
                                throw var6_9;
                            }
                            catch (Throwable var6_10) {
                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var5_6);
                                throw var6_10;
                            }
lbl22:
                            // 2 sources

                            while (true) {
                                var8_8 = var3_4;
                                this.L$0 = var2_3;
                                this.L$1 = var3_4;
                                this.L$2 = var4_5;
                                this.L$3 = var8_8;
                                this.label = 1;
                                v0 = var4_5.accept((Continuation)this);
                                if (v0 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl43
                                break;
                            }
                        }
                        case 1: {
                            $i$a$-use-Server$runServer$1$1 = false;
                            var8_8 = (Server)this.L$3;
                            var5_6 = null;
                            var4_5 = (ServerSocket)this.L$2;
                            var3_4 = (Server)this.L$1;
                            var2_3 = (Closeable)this.L$0;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl43:
                                // 2 sources

                                DefaultImpls.access$dealWithClient(var8_8, (Socket)v0);
                                ** continue;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static <T extends ServerBase> void shutdownServer(@NotNull Server<? extends T> $this) {
            $this.getClients().forEach((arg_0, arg_1) -> DefaultImpls.shutdownServer$lambda$1(shutdownServer.1.INSTANCE, arg_0, arg_1));
            $this.getClients().clear();
            $this.getServerSocketWithPort().getSocket().close();
        }

        private static <T extends ServerBase> void shutdownClient(Server<? extends T> $this, Socket client) {
            $this.getClients().remove(client);
            client.close();
        }

        @Nullable
        public static <T extends ServerBase> Object checkClientCanReadFile(@NotNull Server<? extends T> $this, @NotNull ByteReadChannelWrapper clientInputChannel, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((boolean)true);
        }

        @Nullable
        public static <T extends ServerBase> Object serverHandshake(@NotNull Server<? extends T> $this, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output, @NotNull Logger log, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((boolean)true);
        }

        private static void shutdownServer$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public static final /* synthetic */ Logger access$getLog(Server $this) {
            return DefaultImpls.getLog($this);
        }

        public static final /* synthetic */ void access$shutdownClient(Server $this, Socket client) {
            DefaultImpls.shutdownClient($this, client);
        }

        public static final /* synthetic */ Deferred access$dealWithClient(Server $this, Socket client) {
            return DefaultImpls.dealWithClient($this, client);
        }
    }
}

