/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001YB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0087\u0001\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\"\b\u0002\u0010 \u001a\u001c\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0#\u0012\u0004\u0012\u00020$\u0018\u00010!2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002JL\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\f2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\"J<\u0010=\u001a\u0004\u0018\u0001H>\"\u0004\b\u0000\u0010>2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\f2\u0014\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u0001H>0@H\u0082\b\u00a2\u0006\u0002\u0010AJ:\u0010B\u001a\u0004\u0018\u00010\u00112\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\fJ<\u0010B\u001a\u0004\u0018\u00010\u00112\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\f2\b\b\u0002\u0010C\u001a\u00020\fJ\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010#J\u000e\u0010E\u001a\u00020\"2\u0006\u00106\u001a\u000207Jm\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010LJ\u0018\u0010M\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010N\u001a\u0004\u0018\u00010\u0017J!\u0010O\u001a\u00020$2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010PJ\u0016\u0010Q\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010R\u001a\u00020$2\u0006\u00101\u001a\u000202J\u0016\u0010R\u001a\u00020$2\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u000207J(\u0010S\u001a\u00020\f2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002JH\u0010T\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u0002050U2\u0006\u0010V\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0018\u0010W\u001a\u0014\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020$0!H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getOrCreateClientFlagFile", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "ClientOptions", "kotlin-daemon-client"})
public final class KotlinCompilerClient {
    @NotNull
    public static final KotlinCompilerClient INSTANCE = new KotlinCompilerClient();
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting = CompilerSystemProperties.COMPILE_DAEMON_VERBOSE_REPORT_PROPERTY.getValue() != null;

    private KotlinCompilerClient() {
    }

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY.getValue();
        if (string == null) {
            object = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String p0 = string2;
            boolean bl3 = false;
            String string3 = DaemonParamsKt.trimQuotes(p0);
            if (string3 == null) {
                object = null;
            } else {
                Object object2 = string3;
                bl2 = false;
                boolean bl4 = false;
                String p02 = object2;
                boolean bl5 = false;
                String string4 = string2 = !StringsKt.isBlank((CharSequence)p02) ? object2 : null;
                if (string2 == null) {
                    object = null;
                } else {
                    Object object3 = string2;
                    bl4 = false;
                    boolean bl6 = false;
                    Object p03 = object3;
                    boolean bl7 = false;
                    object3 = object2 = new File((String)p03);
                    bl4 = false;
                    bl6 = false;
                    p03 = object3;
                    boolean bl8 = false;
                    object = ((File)p03).exists() ? object3 : null;
                }
            }
        }
        File file = object;
        return file == null ? ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null) : file;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession == null ? null : compileServiceSession.getCompileService();
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        KotlinCompilerClient this_$iv = this;
        boolean $i$f$connectLoop = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this_$iv) {
            Object object;
            boolean bl3 = false;
            try {
                int n;
                int attempts$iv = 1;
                do {
                    Pair pair;
                    try {
                        CompileServiceSession compileServiceSession;
                        boolean isLastAttempt = attempts$iv >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS();
                        boolean bl4 = false;
                        NetworkUtilsKt.ensureServerHostnameIsSetUp();
                        Pair<CompileService, DaemonJVMOptions> pair2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                            final /* synthetic */ DaemonReportingTargets $reportingTargets;
                            {
                                this.$reportingTargets = $reportingTargets;
                                super(2);
                            }

                            public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)cat), (String)"cat");
                                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                                KotlinCompilerClientKt.report$default(this.$reportingTargets, cat, msg, null, 4, null);
                            }
                        }));
                        CompileService service = (CompileService)pair2.component1();
                        DaemonJVMOptions newJVMOptions = (DaemonJVMOptions)pair2.component2();
                        if (service != null) {
                            compileServiceSession = KotlinCompilerClient.connectAndLease$lambda-5$leaseImpl(service, clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile);
                        } else {
                            if (!isLastAttempt && autostart && INSTANCE.startDaemon(compilerId, newJVMOptions, daemonOptions, reportingTargets)) {
                                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
                            }
                            compileServiceSession = null;
                        }
                        pair = TuplesKt.to((Object)compileServiceSession, null);
                    }
                    catch (SocketException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectIOException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (UnmarshalException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (RuntimeException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    Pair pair3 = pair;
                    Object res$iv = pair3.component1();
                    Exception err$iv = (Exception)pair3.component2();
                    if (res$iv != null) {
                        Object object2 = res$iv;
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 10, 12] lbl54 : MonitorExitStatement: MONITOREXIT : this_$iv
                        object = object2;
                        return (CompileServiceSession)object;
                    }
                    if (err$iv != null) {
                        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, Intrinsics.stringPlus((String)(attempts$iv >= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() || !autostart ? "no more retries on: " : "retrying(" + attempts$iv + ") on: "), (Object)err$iv), null, 4, null);
                    }
                    n = attempts$iv;
                    attempts$iv = n + 1;
                } while (n <= INSTANCE.getDAEMON_CONNECT_CYCLE_ATTEMPTS() && autostart);
                Object var25_31 = null;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl63 : MonitorExitStatement: MONITOREXIT : this_$iv
                object = var25_31;
                return (CompileServiceSession)object;
            }
            catch (Throwable e$iv) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
                Object object3 = null;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl69 : MonitorExitStatement: MONITOREXIT : this_$iv
                object = object3;
                return (CompileServiceSession)object;
            }
        }
    }

    public static /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
        if (compileService != null) {
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    @Deprecated(message="Use other compile method", replaceWith=@ReplaceWith(expression="compile", imports={}))
    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, port, 63, null), outStrm, CompileService.OutputFormat.PLAIN, outStrm, operationsTracer).get()).intValue();
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    @Deprecated(message="Use non-deprecated compile method", replaceWith=@ReplaceWith(expression="compile", imports={}))
    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Profiler $this$withMeasure$iv = profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        int res$iv = ((Number)compileService.remoteIncrementalCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(callbackServices.getIncrementalCompilationComponents(), callbackServices.getLookupTracker(), callbackServices.getCompilationCanceledStatus(), null, null, null, port, 56, null), new RemoteOutputStreamServer(compilerOut, port), CompileService.OutputFormat.XML, new RemoteOutputStreamServer(daemonOut, port), operationsTracer).get()).intValue();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x100) != 0) {
            profiler = new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Profiler $this$withMeasure$iv = profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(messageCollector, outputsCollector, port);
        Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
        boolean $i$f$emptyArray = false;
        int res$iv = ((Number)compilerService.compile(sessionId, args, new CompilationOptions(compilerMode, targetPlatform, integerArray, reportSeverity.getCode(), (Integer[])((Object[])new Integer[0]), null, 32, null), services, null).get()).intValue();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getValue();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String[] stringArray = new String[]{","};
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])stringArray, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw new IllegalArgumentException("Unrecognized client options passed via property " + CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getProperty() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(new String[0], true, false, true);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, "--daemon-");
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    bl = false;
                    boolean bl2 = false;
                    List<String> list3 = list2;
                    boolean bl3 = false;
                    compilerId.setCompilerClasspath(list3);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw new IllegalArgumentException("Cannot find compiler jar");
            }
            Iterable iterable = compilerId.getCompilerClasspath();
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathSeparator");
            String string2 = Intrinsics.stringPlus((String)"desired compiler classpath: ", (Object)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
            boolean bl4 = false;
            System.out.println((Object)string2);
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            String string = "Shutdown the daemon";
            bl = false;
            System.out.println((Object)string);
            compileService.shutdown();
            String string3 = "Daemon shut down successfully";
            bl = false;
            System.out.println((Object)string3);
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            String string = Intrinsics.stringPlus((String)"Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns ", (Object)compileService.checkCompilerId(compilerId));
            bl = false;
            System.out.println((Object)string);
            return;
        }
        String string = Intrinsics.stringPlus((String)"Executing daemon compilation with args: ", (Object)CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        bl = false;
        System.out.println((Object)string);
        PrintStream printStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"out");
        RemoteOutputStreamServer remoteOutputStreamServer = new RemoteOutputStreamServer(printStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, 0, 127, null);
        try {
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection $this$toTypedArray$iv = CollectionsKt.toList(filteredArgs);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            CompileService.CallResult<Integer> res2 = compileService.remoteCompile(CompileService.Companion.getNO_SESSION(), CompileService.TargetPlatform.JVM, stringArray, servicesFacade, remoteOutputStreamServer, CompileService.OutputFormat.PLAIN, remoteOutputStreamServer, null);
            long endTime = System.nanoTime();
            thisCollection$iv = "Compilation " + (res2.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res2.get()).intValue();
            boolean bl5 = false;
            System.out.println(thisCollection$iv);
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            String string4 = "Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms";
            boolean bl6 = false;
            System.out.println((Object)string4);
            StringBuilder stringBuilder = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            string4 = "%+d";
            Object[] objectArray = new Object[]{memAfter - memBefore};
            boolean bl7 = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
            string4 = stringBuilder.append(string5).append(" kb)").toString();
            boolean bl8 = false;
            System.out.println((Object)string4);
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(remoteOutputStreamServer, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        List list;
        String string = CompilerSystemProperties.JAVA_CLASS_PATH.getValue();
        if (string == null) {
            list = null;
        } else {
            CharSequence charSequence = string;
            Object object = new String[1];
            Object object2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"pathSeparator");
            object[0] = object2;
            List list2 = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                Iterable $this$mapTo$iv$iv;
                void $this$map$iv;
                object2 = list2;
                boolean $i$f$map = false;
                File file = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file2 = new File((String)it).getParentFile();
                    collection.add(file2);
                }
                object = (List)destination$iv$iv;
                object2 = CollectionsKt.distinct((Iterable)((Iterable)object));
                if (object2 == null) {
                    list = null;
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    $this$mapTo$iv$iv = (Iterable)object2;
                    boolean $i$f$mapNotNull = false;
                    void $i$f$mapTo2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        File file3;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        File it = (File)element$iv$iv;
                        boolean bl2 = false;
                        File file4 = it;
                        if (file4 == null) {
                            file3 = null;
                        } else {
                            FileTreeWalk fileTreeWalk = FilesKt.walk$default((File)file4, null, (int)1, null);
                            if (fileTreeWalk == null) {
                                file3 = null;
                            } else {
                                Object v3;
                                block15: {
                                    void $this$firstOrNull$iv;
                                    Sequence sequence = (Sequence)fileTreeWalk;
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv : $this$firstOrNull$iv) {
                                        File it2 = (File)element$iv;
                                        boolean bl3 = false;
                                        if (!StringsKt.equals((String)it2.getName(), (String)"kotlin-compiler.jar", (boolean)true)) continue;
                                        v3 = element$iv;
                                        break block15;
                                    }
                                    v3 = null;
                                }
                                file3 = v3;
                            }
                        }
                        if (file3 == null) continue;
                        File file5 = file3;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        File it$iv$iv = file5;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv2;
                    file = (File)CollectionsKt.firstOrNull((List)list3);
                    if (file == null) {
                        list = null;
                    } else {
                        File file6 = file;
                        boolean bl = false;
                        boolean bl7 = false;
                        File it = file6;
                        boolean bl8 = false;
                        list = CollectionsKt.listOf((Object)it.getAbsolutePath());
                    }
                }
            }
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    private final <R> R connectLoop(DaemonReportingTargets reportingTargets, boolean autostart, Function1<? super Boolean, ? extends R> body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        Comparator comparator;
        DaemonWithMetadata it;
        Pair pair;
        List list;
        registryDir.mkdirs();
        File timestampMarker = Files.createTempFile(registryDir.toPath(), "kotlin-daemon-client-tsmarker", null, new FileAttribute[0]).toFile();
        try {
            Intrinsics.checkExpressionValueIsNotNull((Object)timestampMarker, (String)"timestampMarker");
            list = SequencesKt.toList((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, timestampMarker, null, report2, 8, null));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata = list;
        Comparator comparator2 = new DaemonJVMOptionsMemoryComparator();
        boolean bl = false;
        comparator2 = new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = comparator;
            }

            public final int compare(T a, T b) {
                DaemonWithMetadata it;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                Comparator comparator2 = comparator;
                boolean bl2 = false;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                it = (DaemonWithMetadata)b;
                bl2 = false;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Comparator comparator3 = new FileAgeComparator();
        boolean bl2 = false;
        Comparator comparator4 = new Comparator(comparator2, comparator3){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = comparator;
                this.$comparator = comparator2;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata it;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator2 = comparator;
                    boolean bl2 = false;
                    File file = it.getRunFile();
                    it = (DaemonWithMetadata)b;
                    bl2 = false;
                    File file2 = it.getRunFile();
                    n = comparator2.compare(file, file2);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        Object object = (DaemonWithMetadata)CollectionsKt.maxWith((Iterable)aliveWithMetadata, (Comparator)comparator4);
        if (object == null) {
            pair = null;
        } else {
            DaemonWithMetadata daemonWithMetadata;
            DaemonWithMetadata daemonWithMetadata2 = object;
            boolean bl3 = false;
            boolean bl4 = false;
            it = daemonWithMetadata2;
            boolean bl5 = false;
            DaemonWithMetadata daemonWithMetadata3 = daemonWithMetadata = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, it.getJvmOptions()) ? daemonWithMetadata2 : null;
            if (daemonWithMetadata == null) {
                pair = null;
            } else {
                daemonWithMetadata2 = daemonWithMetadata;
                bl3 = false;
                bl4 = false;
                it = daemonWithMetadata2;
                boolean bl6 = false;
                pair = new Pair((Object)it.getDaemon(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, it.getJvmOptions()));
            }
        }
        comparator3 = pair;
        if (comparator3 == null) {
            DaemonJVMOptions daemonJVMOptions2;
            void $this$fold$iv;
            object = aliveWithMetadata;
            Object var18_24 = null;
            boolean $i$f$fold = false;
            DaemonJVMOptions accumulator$iv = optsCopy;
            for (Object element$iv : $this$fold$iv) {
                void d;
                it = (DaemonWithMetadata)element$iv;
                DaemonJVMOptions opts = accumulator$iv;
                boolean bl7 = false;
                accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
            }
            DaemonJVMOptions daemonJVMOptions3 = daemonJVMOptions2 = accumulator$iv;
            Object var21_28 = var18_24;
            comparator = new Pair(var21_28, (Object)daemonJVMOptions3);
        } else {
            comparator = comparator3;
        }
        return comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        Object object;
        Object list$iv$iv;
        PropMapper it;
        Object element$iv$iv;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        List list;
        Integer javaVersion;
        File javaExecutable = new File(new File(CompilerSystemProperties.JAVA_HOME.getSafeValue(), "bin"), "java");
        String string = CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getValue();
        if (string == null) {
            String string2 = Intrinsics.stringPlus((String)CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty(), (Object)" is not set!");
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String serverHostname = string;
        Object[] objectArray = new String[]{"-Djava.awt.headless=true", "-D$" + CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + '=' + serverHostname};
        List platformSpecificOptions = CollectionsKt.listOf((Object[])objectArray);
        String string3 = CompilerSystemProperties.JAVA_VERSION.getValue();
        Integer n = javaVersion = string3 == null ? null : StringsKt.toIntOrNull((String)string3);
        if (javaVersion != null && javaVersion >= 16) {
            Object[] objectArray2 = new String[]{"--add-exports", "java.base/sun.nio.ch=ALL-UNNAMED"};
            list = CollectionsKt.listOf((Object[])objectArray2);
        } else {
            list = CollectionsKt.emptyList();
        }
        List javaIllegalAccessWorkaround = list;
        Object object2 = new String[3];
        object2[0] = javaExecutable.getAbsolutePath();
        object2[1] = "-cp";
        Iterable iterable = compilerId.getCompilerClasspath();
        String string4 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"pathSeparator");
        object2[2] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, null, (int)62, null);
        Collection collection = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object2), (Iterable)platformSpecificOptions);
        object2 = daemonJVMOptions.getMappers();
        Collection collection2 = collection;
        boolean $i$f$flatMap = false;
        void var13_18 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (PropMapper)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$flatMap$iv = daemonOptions.getMappers();
        collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)list2), (Iterable)javaIllegalAccessWorkaround), (Object)"org.jetbrains.kotlin.daemon.KotlinCompileDaemon");
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (PropMapper)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$flatMap$iv = compilerId.getMappers();
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (PropMapper)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        List args = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, Intrinsics.stringPlus((String)"starting the daemon as: ", (Object)CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), null, 4, null);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        $this$flatMapTo$iv$iv = new File(daemonOptions.getRunFilesPath());
        boolean destination$iv$iv2 = false;
        $i$f$flatMapTo = false;
        Object $this$startDaemon_u24lambda_u2d23 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        ((File)$this$startDaemon_u24lambda_u2d23).mkdirs();
        Object workingDir = $this$flatMapTo$iv$iv;
        processBuilder.directory((File)workingDir);
        Process daemon2 = NativePlatformUtilKt.launchProcessWithFallback(processBuilder, reportingTargets, "daemon client");
        Semaphore isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        Thread stdoutThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon2, isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ Semaphore $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            {
                this.$daemon = $daemon;
                this.$isEchoRead = $isEchoRead;
                this.$reportingTargets = $reportingTargets;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"daemon.inputStream");
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream, charset), (Function1)((Function1)new Function1<String, Unit>(this.$reportingTargets, this.$isEchoRead){
                        final /* synthetic */ DaemonReportingTargets $reportingTargets;
                        final /* synthetic */ Semaphore $isEchoRead;
                        {
                            this.$reportingTargets = $reportingTargets;
                            this.$isEchoRead = $isEchoRead;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)it, (Object)"Kotlin compile daemon is ready")) {
                                KotlinCompilerClientKt.report$default(this.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClientKt.report(this.$reportingTargets, DaemonReportCategory.INFO, it, "daemon");
                        }
                    }));
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                    this.$isEchoRead.release();
                }
            }
        }), (int)31, null);
        try {
            Object object3;
            String string5 = CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getValue();
            if (string5 == null) {
                object3 = null;
            } else {
                Object object4;
                object = string5;
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = object;
                boolean bl4 = false;
                try {
                    object4 = it2;
                    boolean bl5 = false;
                    object4 = Long.parseLong((String)object4);
                }
                catch (Exception e) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getProperty() + " property ('" + it2 + "'); using default timeout " + INSTANCE.getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() + " ms", null, 4, null);
                    object4 = null;
                }
                object3 = object4;
            }
            list$iv$iv = object3;
            long daemonStartupTimeout = list$iv$iv == null ? DAEMON_DEFAULT_STARTUP_TIMEOUT_MS : (Long)list$iv$iv;
            list$iv$iv = daemonOptions.getRunFilesPath();
            boolean bl6 = false;
            if (list$iv$iv.length() > 0) {
                boolean bl7;
                boolean succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                if (!KotlinCompilerClientKt.isProcessAlive(daemon2)) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, Intrinsics.stringPlus((String)"Daemon terminated unexpectedly with error code: ", (Object)daemon2.exitValue()), null, 4, null);
                    bl7 = false;
                } else if (!succeeded) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Unable to get response from daemon in " + daemonStartupTimeout + " ms", null, 4, null);
                    bl7 = false;
                } else {
                    bl7 = true;
                }
                bl6 = bl7;
                return bl6;
            }
            Thread.sleep(daemonStartupTimeout);
            boolean bl8 = true;
            return bl8;
        }
        finally {
            if (stdoutThread2.isAlive()) {
                stdoutThread2.interrupt();
            }
            if ((object = reportingTargets.getOut()) != null) {
                ((PrintStream)object).flush();
            }
        }
    }

    private static final CompileServiceSession connectAndLease$lambda-5$leaseImpl(CompileService $this$connectAndLease_u24lambda_u2d5_u24leaseImpl, File $clientAliveFlagFile, DaemonReportingTargets $reportingTargets, boolean $leaseSession, File $sessionAliveFlagFile) {
        CompileServiceSession compileServiceSession;
        Serializable serializable;
        $this$connectAndLease_u24lambda_u2d5_u24leaseImpl.registerClient($clientAliveFlagFile.getAbsolutePath());
        KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
        if (!$leaseSession) {
            return new CompileServiceSession($this$connectAndLease_u24lambda_u2d5_u24leaseImpl, CompileService.Companion.getNO_SESSION());
        }
        Serializable serializable2 = $sessionAliveFlagFile;
        serializable2 = $this$connectAndLease_u24lambda_u2d5_u24leaseImpl.leaseCompileSession(serializable2 == null ? null : ((File)serializable2).getAbsolutePath());
        boolean bl = false;
        boolean bl2 = false;
        Serializable it = serializable2;
        boolean bl3 = false;
        Serializable serializable3 = serializable = !(it instanceof CompileService.CallResult.Dying) ? serializable2 : null;
        if (serializable == null) {
            compileServiceSession = null;
        } else {
            serializable2 = serializable;
            bl = false;
            bl2 = false;
            it = serializable2;
            boolean bl4 = false;
            compileServiceSession = new CompileServiceSession($this$connectAndLease_u24lambda_u2d5_u24leaseImpl, ((Number)((CompileService.CallResult)it).get()).intValue());
        }
        return compileServiceSession;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, (KMutableProperty1)mappers.1.INSTANCE, null, 4, null));
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        public static /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        @NotNull
        public String toString() {
            return "ClientOptions(stop=" + this.stop + ')';
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientOptions)) {
                return false;
            }
            ClientOptions clientOptions = (ClientOptions)other;
            return this.stop == clientOptions.stop;
        }

        public ClientOptions() {
            this(false, 1, null);
        }
    }
}

