/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.base.Throwables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0003\"\b\b\u0000\u0010\u0011*\u00020\u0012*\b\u0012\u0004\u0012\u0002H\u00110\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003*\u00020\u0018H\u0000\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\u000f\u0010\u001a\u001a\u00070\u0001\u00a2\u0006\u0002\b\u001b*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020 \u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0001\u001a\u000f\u0010\"\u001a\u00070\u0001\u00a2\u0006\u0002\b\u001b*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"END_LINE", "", "SOURCE_CHARS", "", "XML_PREAMBLE", "XML_REPLACEMENTS", "makeScriptBaseName", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "renderReplStackTrace", "cause", "", "startFromMethodName", "scriptResultFieldName", "lineNo", "", "ensureNotEmpty", "T", "", "error", "listAllUrlsAsFiles", "Ljava/io/File;", "Ljava/lang/ClassLoader;", "listLocalUrlsAsFiles", "Ljava/net/URLClassLoader;", "replAddLineBreak", "replEscapeLineBreaks", "Lorg/jetbrains/annotations/NotNull;", "replInputAsXml", "replNormalizeLineBreaks", "replOutputAsXml", "escapeType", "Lorg/jetbrains/kotlin/utils/repl/ReplEscapeType;", "replRemoveLineBreaksInTheEnd", "replUnescapeLineBreaks", "cli-common"})
public final class ReplUtilKt {
    @NotNull
    private static final List<String> SOURCE_CHARS;
    @NotNull
    private static final List<String> XML_REPLACEMENTS;
    @NotNull
    private static final String END_LINE;
    @NotNull
    private static final String XML_PREAMBLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    @NotNull
    public static final String replUnescapeLineBreaks(@NotNull String $this$replUnescapeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replUnescapeLineBreaks, (String)"<this>");
        String string = StringUtil.replace((String)$this$replUnescapeLineBreaks, XML_REPLACEMENTS, SOURCE_CHARS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(this, XML_REPLACEMENTS, SOURCE_CHARS)");
        return string;
    }

    @NotNull
    public static final String replEscapeLineBreaks(@NotNull String $this$replEscapeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replEscapeLineBreaks, (String)"<this>");
        String string = StringUtil.replace((String)$this$replEscapeLineBreaks, SOURCE_CHARS, XML_REPLACEMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(this, SOURCE_CHARS, XML_REPLACEMENTS)");
        return string;
    }

    @NotNull
    public static final String replOutputAsXml(@NotNull String $this$replOutputAsXml, @NotNull ReplEscapeType escapeType) {
        Intrinsics.checkNotNullParameter((Object)$this$replOutputAsXml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)escapeType, (String)"escapeType");
        String string = StringUtil.escapeXmlEntities((String)ReplUtilKt.replEscapeLineBreaks($this$replOutputAsXml));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(replEscapeLineBreaks())");
        String escapedXml = string;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output type=\"" + escapeType + "\">" + escapedXml + "</output>";
    }

    @NotNull
    public static final String replInputAsXml(@NotNull String $this$replInputAsXml) {
        Intrinsics.checkNotNullParameter((Object)$this$replInputAsXml, (String)"<this>");
        String string = StringUtil.escapeXmlEntities((String)ReplUtilKt.replEscapeLineBreaks($this$replInputAsXml));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(replEscapeLineBreaks())");
        String escapedXml = string;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><input>" + escapedXml + "</input>";
    }

    @NotNull
    public static final String replAddLineBreak(@NotNull String $this$replAddLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$replAddLineBreak, (String)"<this>");
        return Intrinsics.stringPlus((String)$this$replAddLineBreak, (Object)END_LINE);
    }

    @NotNull
    public static final String replRemoveLineBreaksInTheEnd(@NotNull String $this$replRemoveLineBreaksInTheEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$replRemoveLineBreaksInTheEnd, (String)"<this>");
        Object object = END_LINE;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        object = new char[cArray2.length];
        System.arraycopy(cArray2, 0, object, 0, cArray2.length);
        return StringsKt.trimEnd((String)$this$replRemoveLineBreaksInTheEnd, (char[])object);
    }

    @NotNull
    public static final String replNormalizeLineBreaks(@NotNull String $this$replNormalizeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replNormalizeLineBreaks, (String)"<this>");
        return StringsKt.replace$default((String)$this$replNormalizeLineBreaks, (String)END_LINE, (String)"\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? Intrinsics.stringPlus((String)"_gen_", (Object)codeLine.getGeneration()) : "");
    }

    @NotNull
    public static final String scriptResultFieldName(int lineNo) {
        return Intrinsics.stringPlus((String)"res", (Object)lineNo);
    }

    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause, @NotNull String startFromMethodName) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)startFromMethodName, (String)"startFromMethodName");
        boolean bl = false;
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip = true;
        Object object = cause.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cause.stackTrace");
        for (StackTraceElement element : ArraysKt.reversed((Object[])object)) {
            if (Intrinsics.areEqual((Object)(element.getClassName() + '.' + element.getMethodName()), (Object)startFromMethodName)) {
                skip = false;
            }
            if (skip) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast((List)CollectionsKt.reversed((Iterable)newTrace), (int)1);
        Collection $this$toTypedArray$iv = resultingTrace;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        cause.setStackTrace(stackTraceElementArray);
        object = Throwables.getStackTraceAsString((Throwable)cause);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getStackTraceAsString(cause)");
        boolean bl2 = false;
        return ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)object))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $this$listAllUrlsAsFiles) {
        void $this$fold$iv;
        Sequence parents2;
        Intrinsics.checkNotNullParameter((Object)$this$listAllUrlsAsFiles, (String)"<this>");
        Sequence sequence = parents2 = SequencesKt.filterIsInstance((Sequence)SequencesKt.generateSequence((Object)$this$listAllUrlsAsFiles, (Function1)listAllUrlsAsFiles.parents.1.INSTANCE), URLClassLoader.class);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct((Iterable)accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $this$listLocalUrlsAsFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$listLocalUrlsAsFiles, (String)"<this>");
        URL[] uRLArray = $this$listLocalUrlsAsFiles.getURLs();
        Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"this.urLs");
        Object[] $this$mapNotNull$iv = uRLArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        String string = $this$forEach$iv$iv$iv;
        int n = ((void)string).length;
        for (int i = 0; i < n; ++i) {
            String string2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = string[i];
            boolean bl = false;
            URL it = (URL)element$iv$iv;
            boolean bl2 = false;
            String string3 = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.toString()");
            if (StringsKt.removePrefix((String)string3, (CharSequence)"file:") == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)p0);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $this$ensureNotEmpty, @NotNull String error) {
        Intrinsics.checkNotNullParameter($this$ensureNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if ($this$ensureNotEmpty.isEmpty()) {
            throw new IllegalStateException(error);
        }
        return $this$ensureNotEmpty;
    }

    static {
        Object object = new String[]{"\r", "\n", "#"};
        SOURCE_CHARS = CollectionsKt.listOf((Object[])object);
        object = new String[]{"#r", "#n", "#diez"};
        XML_REPLACEMENTS = CollectionsKt.listOf((Object[])object);
        object = LineSeparator.getSystemLineSeparator().getSeparatorString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSystemLineSeparator().separatorString");
        END_LINE = object;
    }
}

