/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common.experimental;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.experimental.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.experimental.SecurityData;
import org.jetbrains.kotlin.daemon.common.experimental.SecurityUtilsKt;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteReadChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteWriteChannelWrapper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0007\u001a\u00020\b\u001a\b\u0010\t\u001a\u00020\nH\u0002\u001a)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\u0010\u0010\u0013\u001a\n \u0004*\u0004\u0018\u00010\u00140\u0014H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0016\u001a!\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!\u001a\u0014\u0010\"\u001a\u00020\n*\u00020\u00162\u0006\u0010#\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"SECURITY_TOKEN_SIZE", "", "pairGenerator", "Ljava/security/KeyPairGenerator;", "kotlin.jvm.PlatformType", "secureRandom", "Ljava/security/SecureRandom;", "generateKeysAndToken", "Lorg/jetbrains/kotlin/daemon/common/experimental/SecurityData;", "generateSecurityToken", "", "getSignatureAndVerify", "", "input", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "expectedToken", "publicKey", "Ljava/security/PublicKey;", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;[BLjava/security/PublicKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "instantiateDsa", "Ljava/security/Signature;", "readTokenKeyPairAndSign", "Ljava/io/FileInputStream;", "sendSignature", "", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "signature", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTokenKeyPair", "Ljava/io/FileOutputStream;", "token", "privateKey", "Ljava/security/PrivateKey;", "readBytesFixedLength", "n", "daemon-common-new"})
public final class SecurityUtilsKt {
    public static final int SECURITY_TOKEN_SIZE = 128;
    private static final SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
    private static final KeyPairGenerator pairGenerator = KeyPairGenerator.getInstance("DSA", "SUN");

    private static final byte[] generateSecurityToken() {
        byte[] tokenBuffer = new byte[128];
        secureRandom.nextBytes(tokenBuffer);
        return tokenBuffer;
    }

    @NotNull
    public static final SecurityData generateKeysAndToken() {
        KeyPair keyPair = pairGenerator.generateKeyPair();
        boolean bl = false;
        boolean bl2 = false;
        KeyPair it = keyPair;
        boolean bl3 = false;
        Key key = it.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"it.private");
        PrivateKey privateKey = key;
        key = it.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"it.public");
        return new SecurityData(privateKey, (PublicKey)key, SecurityUtilsKt.generateSecurityToken());
    }

    private static final byte[] readBytesFixedLength(FileInputStream $this$readBytesFixedLength, int n) {
        byte[] buffer = new byte[n];
        for (int bytesRead = 0; bytesRead != n; bytesRead += $this$readBytesFixedLength.read(buffer, bytesRead, n - bytesRead)) {
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendTokenKeyPair(@NotNull FileOutputStream output, @NotNull byte[] token, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        output.write(token);
        Closeable closeable = new ObjectOutputStream(output);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl3 = false;
            it.writeObject(privateKey);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Signature instantiateDsa() {
        return Signature.getInstance("SHA1withDSA", "SUN");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getSignatureAndVerify(@NotNull ByteReadChannelWrapper var0, @NotNull byte[] var1_1, @NotNull PublicKey var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof getSignatureAndVerify.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SecurityUtilsKt.getSignatureAndVerify(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = expectedToken;
                $continuation.L$1 = publicKey;
                $continuation.label = 1;
                v0 = input.nextBytes((Continuation<? super byte[]>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                publicKey = (PublicKey)$continuation.L$1;
                expectedToken = (byte[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                signature = (byte[])v0;
                dsa = SecurityUtilsKt.instantiateDsa();
                dsa.initVerify(publicKey);
                dsa.update(expectedToken, 0, 128);
                verified = dsa.verify(signature);
                ClientUtilsKt.getLog().fine(Intrinsics.stringPlus((String)"verified : ", (Object)Boxing.boxBoolean((boolean)(verified != false))));
                return Boxing.boxBoolean((boolean)(verified != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readTokenKeyPairAndSign(@NotNull FileInputStream input) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] token = SecurityUtilsKt.readBytesFixedLength(input, 128);
        Object object2 = new ObjectInputStream(input);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ObjectInputStream p0 = (ObjectInputStream)object2;
            boolean bl3 = false;
            object = p0.readObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        PrivateKey privateKey = (PrivateKey)object3;
        Signature dsa = SecurityUtilsKt.instantiateDsa();
        dsa.initSign(privateKey);
        dsa.update(token, 0, 128);
        object2 = dsa.sign();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"dsa.sign()");
        return object2;
    }

    @Nullable
    public static final Object sendSignature(@NotNull ByteWriteChannelWrapper output, @NotNull byte[] signature, @NotNull Continuation<? super Unit> $completion) {
        Object object = output.writeBytesAndLength(signature.length, signature, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

