/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.CompilerArgumentsParseException;
import org.jetbrains.kotlin.buildtools.api.CompilerExecutionStrategyConfiguration;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.ClasspathEntrySnapshotImpl;
import org.jetbrains.kotlin.buildtools.internal.CompilationServiceImpl;
import org.jetbrains.kotlin.buildtools.internal.CompilationServiceImplKt;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategy;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategyConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.DaemonAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonCompilationResults;
import org.jetbrains.kotlin.buildtools.internal.JvmCompilationConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.KotlinLoggerMessageCollectorAdapter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J<\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0016JD\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl;", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "()V", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "calculateClasspathSnapshot", "Lorg/jetbrains/kotlin/buildtools/internal/ClasspathEntrySnapshotImpl;", "classpathEntry", "granularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "compileInProcess", "Lorg/jetbrains/kotlin/buildtools/api/CompilationResult;", "loggerAdapter", "Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "sources", "", "arguments", "", "compileJvm", "projectId", "strategyConfig", "Lorg/jetbrains/kotlin/buildtools/api/CompilerExecutionStrategyConfiguration;", "compilationConfig", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmCompilationConfiguration;", "compileWithinDaemon", "daemonConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategy$Daemon;", "compilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/JvmCompilationConfigurationImpl;", "finishProjectCompilation", "", "makeCompilerExecutionStrategyConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategyConfigurationImpl;", "makeJvmCompilationConfiguration", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nCompilationServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1549#2:147\n1620#2,3:148\n1549#2:153\n1620#2,3:154\n37#3,2:151\n1#4:157\n*S KotlinDebug\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n*L\n91#1:147\n91#1:148,3\n132#1:153\n132#1:154,3\n132#1:151,2\n*E\n"})
public final class CompilationServiceImpl
implements CompilationService {
    @NotNull
    public static final CompilationServiceImpl INSTANCE = new CompilationServiceImpl();
    @NotNull
    private static final Map<ProjectId, File> buildIdToSessionFlagFile = new ConcurrentHashMap();

    private CompilationServiceImpl() {
    }

    @NotNull
    public ClasspathEntrySnapshotImpl calculateClasspathSnapshot(@NotNull File classpathEntry, @NotNull ClassSnapshotGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        return new ClasspathEntrySnapshotImpl(ClasspathEntrySnapshotter.INSTANCE.snapshot(classpathEntry, granularity, (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE));
    }

    @NotNull
    public CompilerExecutionStrategyConfigurationImpl makeCompilerExecutionStrategyConfiguration() {
        return new CompilerExecutionStrategyConfigurationImpl();
    }

    @NotNull
    public JvmCompilationConfigurationImpl makeJvmCompilationConfiguration() {
        return new JvmCompilationConfigurationImpl(null, null, 3, null);
    }

    @NotNull
    public CompilationResult compileJvm(@NotNull ProjectId projectId, @NotNull CompilerExecutionStrategyConfiguration strategyConfig, @NotNull JvmCompilationConfiguration compilationConfig, @NotNull List<? extends File> sources, @NotNull List<String> arguments) {
        CompilationResult compilationResult;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)strategyConfig, (String)"strategyConfig");
        Intrinsics.checkNotNullParameter((Object)compilationConfig, (String)"compilationConfig");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (!(strategyConfig instanceof CompilerExecutionStrategyConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$32 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$32 = "Initial strategy configuration object must be acquired from the `makeCompilerExecutionStrategyConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$32.toString());
        }
        if (!(compilationConfig instanceof JvmCompilationConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$42 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$42 = "Initial JVM compilation configuration object must be acquired from the `makeJvmCompilationConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$42.toString());
        }
        KotlinLoggerMessageCollectorAdapter loggerAdapter = new KotlinLoggerMessageCollectorAdapter(((JvmCompilationConfigurationImpl)compilationConfig).getLogger());
        CompilerExecutionStrategy selectedStrategy = ((CompilerExecutionStrategyConfigurationImpl)strategyConfig).getSelectedStrategy$kotlin_build_tools_impl();
        if (selectedStrategy instanceof CompilerExecutionStrategy.InProcess) {
            compilationResult = this.compileInProcess(loggerAdapter, sources, arguments);
        } else if (selectedStrategy instanceof CompilerExecutionStrategy.Daemon) {
            compilationResult = this.compileWithinDaemon(projectId, loggerAdapter, (CompilerExecutionStrategy.Daemon)selectedStrategy, (JvmCompilationConfigurationImpl)compilationConfig, sources, arguments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilationResult;
    }

    public void finishProjectCompilation(@NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        File file = buildIdToSessionFlagFile.remove(projectId);
        if (file == null) {
            return;
        }
        File file2 = file;
        file2.delete();
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileInProcess(KotlinLoggerMessageCollectorAdapter loggerAdapter, List<? extends File> sources, List<String> arguments) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        K2JVMCompiler compiler = new K2JVMCompiler();
        K2JVMCompilerArguments parsedArguments = compiler.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments$default(arguments, (CommonToolArguments)((CommonToolArguments)parsedArguments), (boolean)false, (int)4, null);
        Object object = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)parsedArguments.getErrors());
        if (object != null) {
            String it = object;
            boolean bl = false;
            throw new CompilerArgumentsParseException(it);
        }
        object = sources;
        Collection collection2 = parsedArguments.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = parsedArguments;
        boolean $i$f$map = false;
        void it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        MessageCollector.report$default((MessageCollector)loggerAdapter, (CompilerMessageSeverity)CompilerMessageSeverity.INFO, (String)arguments.toString(), null, (int)4, null);
        return CompilationServiceImplKt.access$getAsCompilationResult(compiler.exec((MessageCollector)loggerAdapter, Services.EMPTY, (CommonToolArguments)parsedArguments));
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileWithinDaemon(ProjectId projectId, KotlinLoggerMessageCollectorAdapter loggerAdapter, CompilerExecutionStrategy.Daemon daemonConfiguration, JvmCompilationConfigurationImpl compilationConfiguration, List<? extends File> sources, List<String> arguments) {
        ExitCode exitCode;
        Object v2;
        int exitCode2;
        block5: {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DaemonJVMOptions daemonJVMOptions;
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)CompilationServiceImplKt.access$getCurrentClasspath());
            File file = buildIdToSessionFlagFile.computeIfAbsent(projectId, arg_0 -> CompilationServiceImpl.compileWithinDaemon$lambda$4(compileWithinDaemon.sessionIsAliveFlagFile.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"computeIfAbsent(...)");
            File sessionIsAliveFlagFile2 = file;
            DaemonJVMOptions opts = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl = false;
            if (!((Collection)daemonConfiguration.getJvmArguments()).isEmpty()) {
                CollectionsKt.addAll((Collection)opts.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonConfiguration.getJvmArguments(), (List)opts.getMappers(), (String)"", (RestPropMapper)opts.getRestMapper()));
            }
            DaemonJVMOptions jvmOptions = daemonJVMOptions;
            CompileServiceSession compileServiceSession = KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)DaemonAdaptersKt.getClientIsAliveFile(), (File)sessionIsAliveFlagFile2, (MessageCollector)loggerAdapter, (boolean)false, null, (DaemonJVMOptions)jvmOptions, (int)32, null);
            if (compileServiceSession == null) {
                throw new IllegalStateException("Can't get connection".toString());
            }
            daemonJVMOptions = compileServiceSession;
            CompileService daemon = daemonJVMOptions.component1();
            int sessionId = daemonJVMOptions.component2();
            CompilationOptions daemonCompileOptions = DaemonAdaptersKt.getAsDaemonCompilationOptions(compilationConfiguration);
            Iterable $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = sources;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            int n = sessionId;
            CompileService compileService = daemon;
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            exitCode2 = ((Number)compileService.compile(n, (String[])ArraysKt.plus((Object[])objectArray, (Collection)collection), daemonCompileOptions, (CompilerServicesFacadeBase)new BasicCompilerServicesWithResultsFacadeServer((MessageCollector)loggerAdapter, null, 0, 6, null), (CompilationResults)new DaemonCompilationResults()).get()).intValue();
            Iterable iterable = (Iterable)EntriesMappings.entries$0;
            for (Object t : iterable) {
                ExitCode it = (ExitCode)t;
                boolean bl3 = false;
                if (!(it.getCode() == exitCode2)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        if ((exitCode = (ExitCode)v2) == null) {
            exitCode = exitCode2 == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
        }
        return CompilationServiceImplKt.access$getAsCompilationResult(exitCode);
    }

    private static final File compileWithinDaemon$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExitCode> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExitCode.values()));
        }
    }
}

