/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.atomicfu.compiler.diagnostic;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlinx.atomicfu.compiler.diagnostic.AtomicfuErrors;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/atomicfu/compiler/diagnostic/AtomicfuErrorMessages;", "Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;", "<init>", "()V", "CONSTRAINTS_MESSAGE", "", "PUBLIC_ATOMICS_ARE_FORBIDDEN_MESSAGE", "ATOMIC_PROEPRTIES_SHOULD_BE_VAL_MESSAGE", "MAP", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "getMAP", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "kotlin-atomicfu-compiler-plugin"})
public final class AtomicfuErrorMessages
extends BaseDiagnosticRendererFactory {
    @NotNull
    public static final AtomicfuErrorMessages INSTANCE;
    @NotNull
    public static final String CONSTRAINTS_MESSAGE = "\nPlease make sure that you follow these constraints for using atomic properties:\n   * To ensure that atomic properties are not accessed out of the current Kotlin module, it is necessary to declare atomic properties as private or internal.\n     Alternatively, you can make the containing class private or internal.\n     If you need to expose the atomic property value to the public, consider using a delegated property declared within the same scope:\n       ```\n       private val _a = atomic<T>(initial) \n       public var a: T by _a \n       ```\n   * Directly invoke operations on atomic properties, like this:\n       ```\n       val top = atomic<Node?>(null)\n       top.compareAndSet(null, Node(1)) // OK\n       ```\n   * Refrain from invoking atomic operations on local variables:\n       ```\n       val top = atomic<Node?>(null)\n       val tmp = top\n       tmp.compareAndSet(null, Node(1)) // DON'T DO THIS\n       ```\n   * Avoid leaking references to atomic values in other ways, such as returning them or passing them as parameters.\n   * Be cautious with the complexity of data flow within parameters of atomic operations.\n     For instance, instead of using intricate expression directly as an argument, e.g.:\n       ```\n       top.compareAndSet(cur, <complex_expression>)\n       ```\n     create a separate variable to hold the complex expression's value and then perform the operation:\n       ```\n       val newValue = <complex_expression>\n       top.compareAndSet(cur, newValue) \n       ```\n\n";
    @NotNull
    private static final String PUBLIC_ATOMICS_ARE_FORBIDDEN_MESSAGE = "\nTo prevent atomic properties from being referenced outside the current Kotlin module, they should be declared as either private or internal. Note, that `@kotlin.PublishedApi` annotation, when applied to a class or a member with internal visibility, makes it effectively public.\nPlease consider setting the visibility of the property `''{0}''` to private or internal or limit the scope of the containing class. \nAlternatively, if you need to expose the atomic property value to the public, you can use a delegated property declared within the same scope, e.g:\n```\nprivate val _a = atomic<T>(initial) \npublic val a: T by _a \n```\n";
    @NotNull
    private static final String ATOMIC_PROEPRTIES_SHOULD_BE_VAL_MESSAGE = "Please consider declaring `''{0}''` as a private val or internal val.\nIf you need to declare a variable with accessors delegated to the atomic property value, you can use a delegated property declared within the same scope, e.g:\n```\nprivate val _a = atomic<T>(initial) \npublic var a: T by _a \n```\n";
    @NotNull
    private static final KtDiagnosticFactoryToRendererMap MAP;

    private AtomicfuErrorMessages() {
    }

    @NotNull
    public KtDiagnosticFactoryToRendererMap getMAP() {
        return MAP;
    }

    static {
        KtDiagnosticFactoryToRendererMap ktDiagnosticFactoryToRendererMap;
        INSTANCE = new AtomicfuErrorMessages();
        KtDiagnosticFactoryToRendererMap map = ktDiagnosticFactoryToRendererMap = new KtDiagnosticFactoryToRendererMap("Atomicfu Plugin");
        boolean bl = false;
        map.put(AtomicfuErrors.INSTANCE.getPUBLIC_ATOMICS_ARE_FORBIDDEN(), PUBLIC_ATOMICS_ARE_FORBIDDEN_MESSAGE, (DiagnosticParameterRenderer)Renderers.TO_STRING);
        map.put(AtomicfuErrors.INSTANCE.getPUBLISHED_API_ATOMICS_ARE_FORBIDDEN(), PUBLIC_ATOMICS_ARE_FORBIDDEN_MESSAGE, (DiagnosticParameterRenderer)Renderers.TO_STRING);
        map.put(AtomicfuErrors.INSTANCE.getATOMIC_PROPERTIES_SHOULD_BE_VAL(), ATOMIC_PROEPRTIES_SHOULD_BE_VAL_MESSAGE, (DiagnosticParameterRenderer)Renderers.TO_STRING);
        MAP = ktDiagnosticFactoryToRendererMap;
    }
}

