/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.assignment.plugin.diagnostics.ErrorsAssignmentPlugin;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.extensions.AssignResolutionAltererExtension;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u0005*\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002JJ\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/AbstractAssignPluginResolutionAltererExtension;", "Lorg/jetbrains/kotlin/resolve/extensions/AssignResolutionAltererExtension;", "<init>", "()V", "needOverloadAssign", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isValPropertyAssignment", "hasSpecialAnnotation", "resolveAssign", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "leftOperand", "Lorg/jetbrains/kotlin/psi/KtExpression;", "left", "leftInfo", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "components", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingComponents;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "resolveMethodCall", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "binaryExpression", "kotlin-assignment-compiler-plugin.k1"})
public abstract class AbstractAssignPluginResolutionAltererExtension
implements AssignResolutionAltererExtension {
    public boolean needOverloadAssign(@NotNull KtBinaryExpression expression, @Nullable KotlinType leftType, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        return this.isValPropertyAssignment(expression, bindingContext) && this.hasSpecialAnnotation(leftType, expression);
    }

    private final boolean isValPropertyAssignment(KtBinaryExpression $this$isValPropertyAssignment, BindingContext bindingContext) {
        VariableDescriptor descriptor = BindingContextUtils.extractVariableFromResolvedCall((BindingContext)bindingContext, (KtElement)((KtElement)$this$isValPropertyAssignment.getLeft()));
        return descriptor instanceof PropertyDescriptor && !((PropertyDescriptor)descriptor).isVar();
    }

    private final boolean hasSpecialAnnotation(KotlinType $this$hasSpecialAnnotation, KtBinaryExpression expression) {
        KotlinType kotlinType = $this$hasSpecialAnnotation;
        return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null ? this.hasSpecialAnnotation((DeclarationDescriptor)kotlinType, (KtModifierListOwner)CfgContainingDeclarationUtilsKt.getElementParentDeclaration((KtElement)((KtElement)expression))) : false;
    }

    @Nullable
    public KotlinTypeInfo resolveAssign(@NotNull BindingContext bindingContext, @NotNull KtBinaryExpression expression, @NotNull KtExpression leftOperand, @NotNull KtExpression left, @NotNull KotlinTypeInfo leftInfo, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingComponents components, @NotNull LexicalWritableScope scope) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)leftOperand, (String)"leftOperand");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)leftInfo, (String)"leftInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        KotlinType kotlinType = leftInfo.getType();
        Intrinsics.checkNotNull((Object)kotlinType);
        KotlinType leftType = kotlinType;
        if (leftOperand instanceof KtSafeQualifiedExpression) {
            leftType = TypeUtilsKt.makeNotNullable((KotlinType)leftType);
        }
        BindingContext bindingContext2 = context.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(left, leftType, bindingContext2);
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        KtSimpleNameExpression operationSign = (KtSimpleNameExpression)ktOperationReferenceExpression;
        TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create((ResolutionContext)((ResolutionContext)context), (String)"trace to check assignment operation like '=' for", (KtExpression)((KtExpression)expression));
        Intrinsics.checkNotNullExpressionValue((Object)temporaryTraceAndCache, (String)"create(...)");
        TemporaryTraceAndCache temporaryForAssignmentOperation = temporaryTraceAndCache;
        ResolutionContext resolutionContext = ((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope((LexicalScope)scope);
        Intrinsics.checkNotNullExpressionValue((Object)resolutionContext, (String)"replaceScope(...)");
        ExpressionTypingContext temporaryContext = (ExpressionTypingContext)resolutionContext;
        CallResolver callResolver = components.callResolver;
        Intrinsics.checkNotNullExpressionValue((Object)callResolver, (String)"callResolver");
        OverloadResolutionResults<FunctionDescriptor> methodDescriptors = this.resolveMethodCall(callResolver, temporaryContext, receiver, expression);
        KotlinType methodReturnType = OverloadResolutionResultsUtil.getResultingType(methodDescriptors, (ResolutionContext)((ResolutionContext)context));
        if (methodDescriptors.isSuccess() && methodReturnType != null) {
            KotlinTypeInfo kotlinTypeInfo;
            temporaryForAssignmentOperation.commit();
            if (TypeUtilsKt.isUnit((KotlinType)methodReturnType)) {
                kotlinTypeInfo = leftInfo.replaceType(methodReturnType);
            } else {
                context.trace.report((Diagnostic)ErrorsAssignmentPlugin.CALL_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT.on((PsiElement)operationSign));
                kotlinTypeInfo = null;
            }
            return kotlinTypeInfo;
        }
        context.trace.report((Diagnostic)ErrorsAssignmentPlugin.NO_APPLICABLE_ASSIGN_METHOD.on((PsiElement)operationSign));
        return null;
    }

    private final OverloadResolutionResults<FunctionDescriptor> resolveMethodCall(CallResolver $this$resolveMethodCall, ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression) {
        Call call = CallMaker.makeCallWithExpressions((KtElement)((KtElement)binaryExpression), (Receiver)((Receiver)receiver), null, (KtExpression)((KtExpression)binaryExpression.getOperationReference()), Collections.singletonList(binaryExpression.getRight()));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"makeCallWithExpressions(...)");
        Call call2 = call;
        OverloadResolutionResults overloadResolutionResults = $this$resolveMethodCall.resolveCallWithGivenName((ResolutionContext)context, call2, (KtReferenceExpression)binaryExpression.getOperationReference(), OperatorConventions.ASSIGN_METHOD);
        Intrinsics.checkNotNullExpressionValue((Object)overloadResolutionResults, (String)"resolveCallWithGivenName(...)");
        return overloadResolutionResults;
    }
}

