/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinGlobalModificationService;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalSourceModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalSourceOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinGlobalModificationServiceBase;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinGlobalModificationService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "incrementModificationTrackers", "", "includeBinaryTrackers", "", "publishGlobalModuleStateModification", "publishGlobalSourceModuleStateModification", "publishGlobalSourceOutOfBlockModification", "analysis-api-providers"})
public abstract class KotlinGlobalModificationServiceBase
extends KotlinGlobalModificationService {
    @NotNull
    private final Project project;

    public KotlinGlobalModificationServiceBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    protected abstract void incrementModificationTrackers(boolean var1);

    @Override
    public void publishGlobalModuleStateModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(true);
        ((KotlinGlobalModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION())).onModification();
    }

    @Override
    public void publishGlobalSourceModuleStateModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(false);
        ((KotlinGlobalSourceModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION())).onModification();
    }

    @Override
    public void publishGlobalSourceOutOfBlockModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(false);
        ((KotlinGlobalSourceOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION())).onModification();
    }
}

