/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import com.intellij.openapi.project.Project;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.lifetime.KaBaseLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.impl.base.permissions.KaBaseWriteActionStartedChecker;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.ProhibitedAnalysisException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.providers.KaCachedService;
import org.jetbrains.kotlin.analysis.providers.lifetime.KtLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.providers.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001f2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J!\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001f2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\u0019\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001fH\u0002\u00a2\u0006\u0002\u0010'J!\u0010(\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001f2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J!\u0010(\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001f2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\u0019\u0010(\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060 j\u0002`\u001fH\u0002\u00a2\u0006\u0002\u0010'R!\u0010\u0006\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\r\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0016\u001a\u00060\u0018j\u0002`\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/providers/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "getPermissionChecker", "()Lorg/jetbrains/kotlin/analysis/providers/permissions/KaAnalysisPermissionChecker;", "permissionChecker$delegate", "Lkotlin/Lazy;", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "getLifetimeTracker$annotations", "getLifetimeTracker", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "lifetimeTracker$delegate", "writeActionStartedChecker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseWriteActionStartedChecker;", "tokenFactory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "getTokenFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "tokenFactory$delegate", "beforeEnteringAnalysis", "", "session", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)V", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "afterLeavingAnalysis", "analysis-api-impl-base"})
public abstract class KaBaseSessionProvider
extends KaSessionProvider {
    @NotNull
    private final Lazy permissionChecker$delegate;
    @NotNull
    private final Lazy lifetimeTracker$delegate;
    @NotNull
    private final KaBaseWriteActionStartedChecker writeActionStartedChecker;
    @NotNull
    private final Lazy tokenFactory$delegate;

    public KaBaseSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.permissionChecker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.permissionChecker_delegate$lambda$0(project));
        this.lifetimeTracker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.lifetimeTracker_delegate$lambda$1(project));
        this.writeActionStartedChecker = new KaBaseWriteActionStartedChecker(this);
        this.tokenFactory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.tokenFactory_delegate$lambda$2(project));
    }

    private final KaAnalysisPermissionChecker getPermissionChecker() {
        Lazy lazy = this.permissionChecker$delegate;
        return (KaAnalysisPermissionChecker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    private final KaBaseLifetimeTracker getLifetimeTracker() {
        Lazy lazy = this.lifetimeTracker$delegate;
        return (KaBaseLifetimeTracker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    @Override
    @NotNull
    public KaLifetimeTokenFactory getTokenFactory() {
        Lazy lazy = this.tokenFactory$delegate;
        return (KaLifetimeTokenFactory)lazy.getValue();
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        this.beforeEnteringAnalysis(session);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.beforeEnteringAnalysis(session);
    }

    private final void beforeEnteringAnalysis(KaSession session) {
        if (!this.getPermissionChecker().isAnalysisAllowed()) {
            throw new ProhibitedAnalysisException("Analysis is not allowed: " + this.getPermissionChecker().getRejectionReason());
        }
        this.getLifetimeTracker().beforeEnteringAnalysis(session);
        this.writeActionStartedChecker.beforeEnteringAnalysis();
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        this.afterLeavingAnalysis(session);
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.afterLeavingAnalysis(session);
    }

    private final void afterLeavingAnalysis(KaSession session) {
        this.writeActionStartedChecker.afterLeavingAnalysis();
        this.getLifetimeTracker().afterLeavingAnalysis(session);
    }

    private static final KaAnalysisPermissionChecker permissionChecker_delegate$lambda$0(Project $project) {
        return KaAnalysisPermissionChecker.Companion.getInstance($project);
    }

    private static final KaBaseLifetimeTracker lifetimeTracker_delegate$lambda$1(Project $project) {
        return KaBaseLifetimeTracker.Companion.getInstance($project);
    }

    private static final KaLifetimeTokenFactory tokenFactory_delegate$lambda$2(Project $project) {
        return KtLifetimeTokenProvider.Companion.getService($project).getLifetimeTokenFactory();
    }
}

