/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.permissions;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.providers.KaCachedService;
import org.jetbrains.kotlin.analysis.providers.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.analysis.providers.permissions.KotlinAnalysisPermissionOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R!\u0010\u0004\u001a\u00020\u00058BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\u00020\f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\n\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseAnalysisPermissionChecker;", "Lorg/jetbrains/kotlin/analysis/providers/permissions/KaAnalysisPermissionChecker;", "<init>", "()V", "permissionRegistry", "Lorg/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistry;", "getPermissionRegistry$annotations", "getPermissionRegistry", "()Lorg/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistry;", "permissionRegistry$delegate", "Lkotlin/Lazy;", "permissionOptions", "Lorg/jetbrains/kotlin/analysis/providers/permissions/KotlinAnalysisPermissionOptions;", "getPermissionOptions$annotations", "getPermissionOptions", "()Lorg/jetbrains/kotlin/analysis/providers/permissions/KotlinAnalysisPermissionOptions;", "permissionOptions$delegate", "isAnalysisAllowed", "", "getRejectionReason", "", "isProhibitedEdtAnalysis", "application", "Lcom/intellij/openapi/application/Application;", "isProhibitedWriteActionAnalysis", "analysis-api-impl-base"})
public final class KaBaseAnalysisPermissionChecker
implements KaAnalysisPermissionChecker {
    @NotNull
    private final Lazy permissionRegistry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, KaBaseAnalysisPermissionChecker::permissionRegistry_delegate$lambda$0);
    @NotNull
    private final Lazy permissionOptions$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, KaBaseAnalysisPermissionChecker::permissionOptions_delegate$lambda$1);

    private final KaAnalysisPermissionRegistry getPermissionRegistry() {
        Lazy lazy = this.permissionRegistry$delegate;
        return (KaAnalysisPermissionRegistry)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionRegistry$annotations() {
    }

    private final KotlinAnalysisPermissionOptions getPermissionOptions() {
        Lazy lazy = this.permissionOptions$delegate;
        return (KotlinAnalysisPermissionOptions)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionOptions$annotations() {
    }

    @Override
    public boolean isAnalysisAllowed() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application);
        if (this.isProhibitedEdtAnalysis(application)) {
            return false;
        }
        if (this.isProhibitedWriteActionAnalysis(application)) {
            return false;
        }
        return this.getPermissionRegistry().getExplicitAnalysisRestriction() == null;
    }

    @Override
    @NotNull
    public String getRejectionReason() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application);
        if (this.isProhibitedEdtAnalysis(application)) {
            return "Called in the EDT thread.";
        }
        if (this.isProhibitedWriteActionAnalysis(application)) {
            return "Called from a write action.";
        }
        KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction kaExplicitAnalysisRestriction = this.getPermissionRegistry().getExplicitAnalysisRestriction();
        if (kaExplicitAnalysisRestriction != null) {
            KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction restriction = kaExplicitAnalysisRestriction;
            boolean bl = false;
            return "Resolve is explicitly forbidden in the current action: " + restriction.getDescription() + '.';
        }
        throw new IllegalStateException("Cannot get a rejection reason when analysis is allowed.".toString());
    }

    private final boolean isProhibitedEdtAnalysis(Application application) {
        return application.isDispatchThread() && !this.getPermissionOptions().getDefaultIsAnalysisAllowedOnEdt() && !this.getPermissionRegistry().isAnalysisAllowedOnEdt();
    }

    private final boolean isProhibitedWriteActionAnalysis(Application application) {
        return application.isWriteAccessAllowed() && !this.getPermissionOptions().getDefaultIsAnalysisAllowedInWriteAction() && !this.getPermissionRegistry().isAnalysisAllowedInWriteAction();
    }

    private static final KaAnalysisPermissionRegistry permissionRegistry_delegate$lambda$0() {
        return KaAnalysisPermissionRegistry.Companion.getInstance();
    }

    private static final KotlinAnalysisPermissionOptions permissionOptions_delegate$lambda$1() {
        return KotlinAnalysisPermissionOptions.Companion.getInstance();
    }
}

