/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR&\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollectorBase;", "", "<init>", "()V", "lineInfo", "Lorg/jetbrains/kotlin/kapt3/base/stubs/LineInfoMap;", "", "", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "getLineInfo", "()Ljava/util/Map;", "Ljava/util/Map;", "signatureInfo", "getSignatureInfo", "filePaths", "Lcom/intellij/psi/PsiFile;", "Lkotlin/Pair;", "", "register", "", "fqName", "psiElement", "Lcom/intellij/psi/PsiElement;", "getFilePathRelativePreferred", "file", "serialize", "", "kotlin-annotation-processing-compiler"})
@SourceDebugExtension(value={"SMAP\nKaptLineMappingCollectorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaptLineMappingCollectorBase.kt\norg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollectorBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n381#2,3:76\n384#2,4:80\n1#3:79\n*S KotlinDebug\n*F\n+ 1 KaptLineMappingCollectorBase.kt\norg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollectorBase\n*L\n36#1:76,3\n36#1:80,4\n*E\n"})
public abstract class KaptLineMappingCollectorBase {
    @NotNull
    private final Map<String, KotlinPosition> lineInfo = new LinkedHashMap();
    @NotNull
    private final Map<String, String> signatureInfo = new LinkedHashMap();
    @NotNull
    private final Map<PsiFile, Pair<String, Boolean>> filePaths = new LinkedHashMap();

    @NotNull
    protected final Map<String, KotlinPosition> getLineInfo() {
        return this.lineInfo;
    }

    @NotNull
    protected final Map<String, String> getSignatureInfo() {
        return this.signatureInfo;
    }

    protected final void register(@NotNull String fqName, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        VirtualFile containingVirtualFile = psiElement.getContainingFile().getVirtualFile();
        if (containingVirtualFile == null || FileDocumentManager.getInstance().getDocument(containingVirtualFile) == null) {
            return;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange textRange2 = textRange;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        Pair<String, Boolean> pair = this.getFilePathRelativePreferred(psiFile);
        String path = (String)pair.component1();
        boolean isRelative = (Boolean)pair.component2();
        this.lineInfo.put(fqName, new KotlinPosition(path, isRelative, textRange2.getStartOffset()));
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<String, Boolean> getFilePathRelativePreferred(PsiFile file) {
        block6: {
            block5: {
                $this$getOrPut$iv = this.filePaths;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(file);
                if (value$iv != null) break block5;
                $i$a$-getOrPut-KaptLineMappingCollectorBase$getFilePathRelativePreferred$1 = false;
                v0 = file.getVirtualFile().getCanonicalPath();
                if (v0 == null) {
                    v1 = file.getVirtualFile().getPath();
                    v0 = v1;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                }
                absolutePath = v0;
                absoluteFile = new File(absolutePath);
                v2 = file.getProject().getBasePath();
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-KaptLineMappingCollectorBase$getFilePathRelativePreferred$1$baseFile$1 = false;
                    v3 = new File(it);
                } else {
                    v3 = baseFile = null;
                }
                if (!absoluteFile.exists() || baseFile == null || !baseFile.exists()) ** GOTO lbl-1000
                v4 = FilesKt.relativeToOrNull((File)absoluteFile, (File)baseFile);
                v5 = relativePath = v4 != null ? v4.getPath() : null;
                if (relativePath != null) {
                    v6 = new Pair((Object)relativePath, (Object)true);
                } else lbl-1000:
                // 2 sources

                {
                    v6 = new Pair((Object)absolutePath, (Object)false);
                }
                answer$iv = v6;
                $this$getOrPut$iv.put(file, (Pair<String, Boolean>)answer$iv);
                v7 = answer$iv;
                break block6;
            }
            v7 = value$iv;
        }
        return v7;
    }

    @NotNull
    public final byte[] serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(1);
        oos.writeInt(this.lineInfo.size());
        for (Map.Entry<String, KotlinPosition> entry : this.lineInfo.entrySet()) {
            String fqName = entry.getKey();
            KotlinPosition kotlinPosition = entry.getValue();
            oos.writeUTF(fqName);
            oos.writeUTF(kotlinPosition.getPath());
            oos.writeBoolean(kotlinPosition.isRelativePath());
            oos.writeInt(kotlinPosition.getPos());
        }
        oos.writeInt(this.signatureInfo.size());
        for (Map.Entry<String, Object> entry : this.signatureInfo.entrySet()) {
            String javacSignature = entry.getKey();
            String methodDesc = (String)entry.getValue();
            oos.writeUTF(javacSignature);
            oos.writeUTF(methodDesc);
        }
        oos.flush();
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

