/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010 \u001a\u00020!J\r\u0010\"\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b#J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\tJ\u0014\u0010&\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\nJ\u0006\u0010(\u001a\u00020)R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "Ljava/io/Serializable;", "<init>", "()V", "sourceCache", "", "Ljava/net/URI;", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaFileStructure;", "dependencyCache", "", "", "nonTransitiveCache", "addSourceStructure", "", "sourceStructure", "getTypesForFiles", "", "files", "", "Ljava/io/File;", "readObject", "input", "Ljava/io/ObjectInputStream;", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "isAlreadyProcessed", "", "sourceFile", "getStructure", "getStructure$kotlin_annotation_processing_base", "getAllImpactedTypes", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "invalidateAll", "invalidateAll$kotlin_annotation_processing_base", "getSourceForType", "type", "invalidateDataForTypes", "impactedTypes", "getSourceFileDefinedTypesCount", "", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nclassStructureCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 classStructureCache.kt\norg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,234:1\n1863#2,2:235\n865#2,2:237\n1755#2,3:242\n1863#2,2:246\n1863#2,2:248\n1863#2,2:250\n216#3,2:239\n216#3:241\n217#3:245\n*S KotlinDebug\n*F\n+ 1 classStructureCache.kt\norg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache\n*L\n122#1:235,2\n133#1:237,2\n154#1:242,3\n159#1:246,2\n108#1:248,2\n113#1:250,2\n143#1:239,2\n153#1:241\n153#1:245\n*E\n"})
public final class JavaClassCache
implements Serializable {
    @NotNull
    private Map<URI, JavaFileStructure> sourceCache = new LinkedHashMap();
    @NotNull
    private transient Map<String, Set<URI>> dependencyCache = new LinkedHashMap();
    @NotNull
    private transient Map<String, Set<URI>> nonTransitiveCache = new LinkedHashMap();

    public final void addSourceStructure(@NotNull JavaFileStructure sourceStructure) {
        Intrinsics.checkNotNullParameter((Object)sourceStructure, (String)"sourceStructure");
        this.sourceCache.put(sourceStructure.getSourceFile(), sourceStructure);
    }

    @NotNull
    public final Set<String> getTypesForFiles(@NotNull Collection<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        HashSet typesFromFiles = new HashSet(files.size());
        for (File file : files) {
            Object object = this.sourceCache.get(file.toURI());
            if (object == null || (object = object.getDeclaredTypes()) == null) continue;
            Object it = object;
            boolean bl = false;
            typesFromFiles.addAll((Collection)it);
        }
        return typesFromFiles;
    }

    private final void readObject(ObjectInputStream input) {
        Set dependants;
        Object object = input.readObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<java.net.URI, org.jetbrains.kotlin.kapt3.base.incremental.JavaFileStructure>");
        this.sourceCache = TypeIntrinsics.asMutableMap((Object)object);
        this.dependencyCache = new HashMap(this.sourceCache.size() * 4);
        for (JavaFileStructure sourceInfo : this.sourceCache.values()) {
            if (!(sourceInfo instanceof SourceFileStructure)) continue;
            for (String mentionedType : ((SourceFileStructure)sourceInfo).getMentionedTypes()) {
                Set set = this.dependencyCache.get(mentionedType);
                if (set == null) {
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add(((SourceFileStructure)sourceInfo).getSourceFile());
                this.dependencyCache.put(mentionedType, dependants);
            }
            for (String mentionedConstants : ((SourceFileStructure)sourceInfo).getMentionedConstants().keySet()) {
                Set set = this.dependencyCache.get(mentionedConstants);
                if (set == null) {
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add(((SourceFileStructure)sourceInfo).getSourceFile());
                this.dependencyCache.put(mentionedConstants, dependants);
            }
        }
        this.nonTransitiveCache = new HashMap(this.sourceCache.size() * 2);
        for (JavaFileStructure sourceInfo : this.sourceCache.values()) {
            if (!(sourceInfo instanceof SourceFileStructure)) continue;
            for (String privateType : ((SourceFileStructure)sourceInfo).getPrivateTypes()) {
                Set set = this.nonTransitiveCache.get(privateType);
                if (set == null) {
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add(((SourceFileStructure)sourceInfo).getSourceFile());
                this.nonTransitiveCache.put(privateType, dependants);
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) {
        output.writeObject(this.sourceCache);
    }

    public final boolean isAlreadyProcessed(@NotNull URI sourceFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (!sourceFile.isAbsolute()) {
            return true;
        }
        if (sourceFile.isOpaque()) {
            return true;
        }
        try {
            bl = this.sourceCache.containsKey(sourceFile);
        }
        catch (IllegalArgumentException e) {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final JavaFileStructure getStructure$kotlin_annotation_processing_base(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.get(sourceFile.toURI());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getAllImpactedTypes(@NotNull Changes changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Set allDirtyTypes = new LinkedHashSet();
        Collection currentDirtyTypes = null;
        currentDirtyTypes = CollectionsKt.toMutableSet((Iterable)this.getTypesForFiles(changes.getSourceChanges()));
        Iterable $this$forEach$iv = changes.getDirtyFqNamesFromClasspath();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String classpathChange = (String)element$iv;
            boolean bl = false;
            JavaClassCache.getAllImpactedTypes$findImpactedTypes(this, classpathChange, currentDirtyTypes, allDirtyTypes);
        }
        while (!((Collection)currentDirtyTypes).isEmpty()) {
            void $this$filterTo$iv;
            Set nextRound = new LinkedHashSet();
            for (String dirtyType : currentDirtyTypes) {
                allDirtyTypes.add(dirtyType);
                JavaClassCache.getAllImpactedTypes$findImpactedTypes(this, dirtyType, nextRound, allDirtyTypes);
            }
            Iterable $i$f$forEach2 = nextRound;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!allDirtyTypes.contains(it))) continue;
                destination$iv.add(element$iv);
            }
            currentDirtyTypes = destination$iv;
        }
        return allDirtyTypes;
    }

    public final void invalidateAll$kotlin_annotation_processing_base() {
        this.sourceCache.clear();
    }

    @NotNull
    public final File getSourceForType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<URI, JavaFileStructure> $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<URI, JavaFileStructure>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<URI, JavaFileStructure> element$iv;
            Map.Entry<URI, JavaFileStructure> entry = element$iv = iterator.next();
            boolean bl = false;
            URI fileUri = entry.getKey();
            JavaFileStructure typeInfo = entry.getValue();
            if (!typeInfo.getDeclaredTypes().contains(type)) continue;
            return new File(fileUri);
        }
        throw new IllegalStateException("Unable to find source file for type " + type);
    }

    public final void invalidateDataForTypes(@NotNull Set<String> impactedTypes) {
        Map.Entry<URI, JavaFileStructure> element$iv;
        Intrinsics.checkNotNullParameter(impactedTypes, (String)"impactedTypes");
        Set allSources = new LinkedHashSet();
        Object $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<URI, JavaFileStructure>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            URI fileUri;
            block5: {
                Map.Entry<URI, JavaFileStructure> entry = element$iv = iterator.next();
                boolean bl2 = false;
                fileUri = entry.getKey();
                JavaFileStructure typeInfo = entry.getValue();
                Iterable $this$any$iv = typeInfo.getDeclaredTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl3 = false;
                        if (!impactedTypes.contains(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            allSources.add(fileUri);
        }
        $this$forEach$iv = allSources;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            URI it = (URI)((Object)element$iv);
            boolean bl = false;
            this.sourceCache.remove(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSourceFileDefinedTypesCount() {
        Iterable iterable = this.sourceCache.values();
        int n = 0;
        for (Object t : iterable) {
            SourceFileStructure structure;
            void it;
            JavaFileStructure javaFileStructure = (JavaFileStructure)t;
            int n2 = n;
            boolean bl = false;
            SourceFileStructure sourceFileStructure = it instanceof SourceFileStructure ? (SourceFileStructure)it : null;
            int n3 = sourceFileStructure == null ? 0 : ((structure = sourceFileStructure).getDeclaredTypes().size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.single((Iterable)structure.getDeclaredTypes()), (Object)"error.NonExistentClass") ? 0 : structure.getDeclaredTypes().size());
            n = n2 + n3;
        }
        return n;
    }

    private static final void getAllImpactedTypes$findImpactedTypes(JavaClassCache this$0, String changedType, Set<String> transitiveDeps, Set<String> nonTransitiveDeps) {
        block3: {
            URI it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Set<URI> impactedSources;
            Set<URI> set = this$0.dependencyCache.get(changedType);
            if (set != null) {
                impactedSources = set;
                boolean bl = false;
                $this$forEach$iv = impactedSources;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (URI)element$iv;
                    boolean bl2 = false;
                    transitiveDeps.addAll((Collection<String>)((JavaFileStructure)MapsKt.getValue(this$0.sourceCache, (Object)it)).getDeclaredTypes());
                }
            }
            Set<URI> set2 = this$0.nonTransitiveCache.get(changedType);
            if (set2 == null) break block3;
            impactedSources = set2;
            boolean bl = false;
            $this$forEach$iv = impactedSources;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (URI)element$iv;
                boolean bl3 = false;
                nonTransitiveDeps.addAll((Collection<String>)((JavaFileStructure)MapsKt.getValue(this$0.sourceCache, (Object)it)).getDeclaredTypes());
            }
        }
    }
}

