/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.project.structure;

import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KotlinModuleDependentsProviderBase;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR;\u0010\u000e\u001a/\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \u0010*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t0\t0\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtStaticModuleDependentsProvider;", "Lorg/jetbrains/kotlin/analysis/project/structure/impl/KotlinModuleDependentsProviderBase;", "modules", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "<init>", "(Ljava/util/List;)V", "directDependentsByKtModule", "", "", "getDirectDependentsByKtModule", "()Ljava/util/Map;", "directDependentsByKtModule$delegate", "Lkotlin/Lazy;", "transitiveDependentsByKtModule", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getDirectDependents", "module", "getTransitiveDependents", "analysis-api-standalone-base"})
public final class KtStaticModuleDependentsProvider
extends KotlinModuleDependentsProviderBase {
    @NotNull
    private final List<KtModule> modules;
    @NotNull
    private final Lazy directDependentsByKtModule$delegate;
    @NotNull
    private final ConcurrentMap<KtModule, Set<KtModule>> transitiveDependentsByKtModule;

    public KtStaticModuleDependentsProvider(@NotNull List<? extends KtModule> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
        this.directDependentsByKtModule$delegate = LazyKt.lazy(() -> KtStaticModuleDependentsProvider.directDependentsByKtModule_delegate$lambda$3(this));
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.transitiveDependentsByKtModule = concurrentMap;
    }

    private final Map<KtModule, Set<KtModule>> getDirectDependentsByKtModule() {
        Lazy lazy = this.directDependentsByKtModule$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public Set<KtModule> getDirectDependents(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set set = this.getDirectDependentsByKtModule().get(module);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public Set<KtModule> getTransitiveDependents(@NotNull KtModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set set = this.transitiveDependentsByKtModule.computeIfAbsent(module, arg_0 -> KtStaticModuleDependentsProvider.getTransitiveDependents$lambda$5(arg_0 -> KtStaticModuleDependentsProvider.getTransitiveDependents$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        return set;
    }

    private static final Set directDependentsByKtModule_delegate$lambda$3$lambda$2$lambda$0(KtModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set directDependentsByKtModule_delegate$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Map directDependentsByKtModule_delegate$lambda$3(KtStaticModuleDependentsProvider this$0) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Map $this$directDependentsByKtModule_delegate_u24lambda_u243_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (KtModule module : this$0.modules) {
            for (KtModule dependency : KtModuleUtilsKt.allDirectDependencies((KtModule)module)) {
                Set dependents;
                if (Intrinsics.areEqual((Object)dependency, (Object)module)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)$this$directDependentsByKtModule_delegate_u24lambda_u243_u24lambda_u242.computeIfAbsent(dependency, arg_0 -> KtStaticModuleDependentsProvider.directDependentsByKtModule_delegate$lambda$3$lambda$2$lambda$1(KtStaticModuleDependentsProvider::directDependentsByKtModule_delegate$lambda$3$lambda$2$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
                dependents.add(module);
            }
        }
        return MapsKt.build((Map)map);
    }

    private static final Set getTransitiveDependents$lambda$4(KtStaticModuleDependentsProvider this$0, KtModule it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        return this$0.computeTransitiveDependents(it);
    }

    private static final Set getTransitiveDependents$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

