/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KotlinModuleDependentsProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.providers.KotlinAnchorModuleProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "getSessionCache", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "sessionCache$delegate", "Lkotlin/Lazy;", "subscribeToModificationEvents", "", "invalidate", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "invalidateAll", "includeLibraryModules", "", "invalidateContextualDanglingFileSessions", "contextModule", "invalidateUnstableDanglingFileSessions", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionInvalidationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionInvalidationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1853#2,2:136\n1853#2,2:138\n*S KotlinDebug\n*F\n+ 1 LLFirSessionInvalidationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService\n*L\n85#1:136,2\n113#1:138,2\n*E\n"})
public final class LLFirSessionInvalidationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy sessionCache$delegate;

    public LLFirSessionInvalidationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sessionCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LLFirSessionCache>(this){
            final /* synthetic */ LLFirSessionInvalidationService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LLFirSessionCache invoke() {
                return LLFirSessionCache.Companion.getInstance(LLFirSessionInvalidationService.access$getProject$p(this.this$0));
            }
        }));
    }

    private final LLFirSessionCache getSessionCache() {
        Lazy lazy = this.sessionCache$delegate;
        return (LLFirSessionCache)lazy.getValue();
    }

    public final void subscribeToModificationEvents() {
        MessageBusConnection messageBusConnection = KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)this.project).connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"connect(...)");
        MessageBusConnection busConnection = messageBusConnection;
        busConnection.subscribe(KotlinTopics.INSTANCE.getMODULE_STATE_MODIFICATION(), (arg_0, arg_1) -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$0(this, arg_0, arg_1));
        busConnection.subscribe(KotlinTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION(), arg_0 -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$1(this, arg_0));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$2(this));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$3(this));
        busConnection.subscribe(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION(), () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$4(this));
        busConnection.subscribe(KotlinTopics.INSTANCE.getCODE_FRAGMENT_CONTEXT_MODIFICATION(), arg_0 -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$5(this, arg_0));
        busConnection.subscribe(PsiModificationTracker.TOPIC, () -> LLFirSessionInvalidationService.subscribeToModificationEvents$lambda$6(this));
    }

    /*
     * WARNING - void declaration
     */
    public final void invalidate(@NotNull KtModule module) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSessionExist = this.getSessionCache().removeSession(module);
        if (!didSessionExist) {
            return;
        }
        Iterable iterable = KotlinModuleDependentsProvider.Companion.getInstance(this.project).getTransitiveDependents(module);
        LLFirSessionCache lLFirSessionCache = this.getSessionCache();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModule p0 = (KtModule)element$iv;
            boolean bl = false;
            lLFirSessionCache.removeSession(p0);
        }
        if (module instanceof KtScriptModule || module instanceof KtScriptDependencyModule || module instanceof KtLibraryModule) {
            this.getSessionCache().removeAllScriptSessions();
        }
        if (module instanceof KtDanglingFileModule) {
            this.getSessionCache().removeContextualDanglingFileSessions(module);
        } else {
            this.getSessionCache().removeAllDanglingFileSessions();
        }
    }

    private final void invalidateAll(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!includeLibraryModules) {
            Collection anchorModules;
            KotlinAnchorModuleProvider kotlinAnchorModuleProvider = KotlinAnchorModuleProvider.Companion.getInstance(this.project);
            Collection collection = anchorModules = kotlinAnchorModuleProvider != null ? kotlinAnchorModuleProvider.getAllAnchorModules() : null;
            if (collection != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtModule p0 = (KtModule)element$iv;
                    boolean bl = false;
                    this.invalidate(p0);
                }
            }
        }
        this.getSessionCache().removeAllSessions(includeLibraryModules);
    }

    private final void invalidateContextualDanglingFileSessions(KtModule contextModule) {
        this.getSessionCache().removeContextualDanglingFileSessions(contextModule);
    }

    private final void invalidateUnstableDanglingFileSessions() {
        this.getSessionCache().removeUnstableDanglingFileSessions();
    }

    public void dispose() {
    }

    private static final void subscribeToModificationEvents$lambda$0(LLFirSessionInvalidationService this$0, KtModule module, KotlinModuleStateModificationKind kotlinModuleStateModificationKind) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)kotlinModuleStateModificationKind, (String)"<unused var>");
        this$0.invalidate(module);
    }

    private static final void subscribeToModificationEvents$lambda$1(LLFirSessionInvalidationService this$0, KtModule module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this$0.invalidate(module);
    }

    private static final void subscribeToModificationEvents$lambda$2(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(true);
    }

    private static final void subscribeToModificationEvents$lambda$3(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(false);
    }

    private static final void subscribeToModificationEvents$lambda$4(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateAll(false);
    }

    private static final void subscribeToModificationEvents$lambda$5(LLFirSessionInvalidationService this$0, KtModule module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this$0.invalidateContextualDanglingFileSessions(module);
    }

    private static final void subscribeToModificationEvents$lambda$6(LLFirSessionInvalidationService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.invalidateUnstableDanglingFileSessions();
    }

    public static final /* synthetic */ Project access$getProject$p(LLFirSessionInvalidationService $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationService;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionInvalidationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LLFirSessionInvalidationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirSessionInvalidationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

