/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.javac;

import com.sun.tools.javac.tree.JCTree;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.util.Java9UtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u001cH\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/kapt3/javac/KaptJavaFileObject;", "Ljavax/tools/JavaFileObject;", "compilationUnit", "Lcom/sun/tools/javac/tree/JCTree$JCCompilationUnit;", "clazz", "Lcom/sun/tools/javac/tree/JCTree$JCClassDecl;", "file", "Ljava/io/File;", "timestamp", "", "(Lcom/sun/tools/javac/tree/JCTree$JCCompilationUnit;Lcom/sun/tools/javac/tree/JCTree$JCClassDecl;Ljava/io/File;J)V", "getClazz", "()Lcom/sun/tools/javac/tree/JCTree$JCClassDecl;", "getCompilationUnit", "()Lcom/sun/tools/javac/tree/JCTree$JCCompilationUnit;", "getFile", "()Ljava/io/File;", "getTimestamp", "()J", "delete", "", "equals", "", "other", "", "getAccessLevel", "Ljavax/lang/model/element/Modifier;", "getCharContent", "", "ignoreEncodingErrors", "getKind", "Ljavax/tools/JavaFileObject$Kind;", "getLastModified", "getName", "getNestingKind", "Ljavax/lang/model/element/NestingKind;", "hashCode", "", "isNameCompatible", "simpleName", "kind", "openInputStream", "Ljava/io/ByteArrayInputStream;", "openOutputStream", "openReader", "Ljava/io/StringReader;", "openWriter", "toString", "toUri", "Ljava/net/URI;", "kotlin-annotation-processing"})
public final class KaptJavaFileObject
implements JavaFileObject {
    @NotNull
    private final JCTree.JCCompilationUnit compilationUnit;
    @NotNull
    private final JCTree.JCClassDecl clazz;
    @Nullable
    private final File file;
    private final long timestamp;

    public KaptJavaFileObject(@NotNull JCTree.JCCompilationUnit compilationUnit, @NotNull JCTree.JCClassDecl clazz, @Nullable File file, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)compilationUnit, (String)"compilationUnit");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        this.compilationUnit = compilationUnit;
        this.clazz = clazz;
        this.file = file;
        this.timestamp = timestamp;
    }

    public /* synthetic */ KaptJavaFileObject(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCClassDecl jCClassDecl, File file, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            l = System.currentTimeMillis();
        }
        this(jCCompilationUnit, jCClassDecl, file, l);
    }

    @NotNull
    public final JCTree.JCCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @NotNull
    public final JCTree.JCClassDecl getClazz() {
        return this.clazz;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getName() + ']';
    }

    @Override
    public boolean isNameCompatible(@Nullable String simpleName, @Nullable JavaFileObject.Kind kind) {
        if (simpleName == null || kind == null) {
            return false;
        }
        return this.getKind() == kind && Intrinsics.areEqual((Object)simpleName, (Object)this.clazz.getSimpleName().toString());
    }

    @Override
    @NotNull
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    @NotNull
    public String getName() {
        JCTree packageName = Java9UtilsKt.getPackageNameJava9Aware(this.compilationUnit);
        if (packageName == null || Intrinsics.areEqual((Object)packageName.toString(), (Object)"")) {
            return this.clazz.name.toString() + ".java";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = packageName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName.toString()");
        return stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('/').append((Object)this.clazz.getSimpleName()).append(".java").toString();
    }

    @Override
    @Nullable
    public Modifier getAccessLevel() {
        Set<Modifier> flags = this.clazz.getModifiers().getFlags();
        if (flags.contains((Object)Modifier.PUBLIC)) {
            return Modifier.PUBLIC;
        }
        if (flags.contains((Object)Modifier.PROTECTED)) {
            return Modifier.PROTECTED;
        }
        if (flags.contains((Object)Modifier.PRIVATE)) {
            return Modifier.PRIVATE;
        }
        return null;
    }

    @Override
    @NotNull
    public ByteArrayInputStream openInputStream() {
        String string = this.getCharContent(false);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new ByteArrayInputStream(byArray);
    }

    @Override
    @NotNull
    public String getCharContent(boolean ignoreEncodingErrors) {
        String string = this.compilationUnit.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compilationUnit.toString()");
        return string;
    }

    @Override
    @NotNull
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    @Nullable
    public URI toUri() {
        File file = this.file;
        return file != null ? file.toURI() : null;
    }

    @Override
    @NotNull
    public StringReader openReader(boolean ignoreEncodingErrors) {
        return new StringReader(this.getCharContent(ignoreEncodingErrors));
    }

    @NotNull
    public Void openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.timestamp;
    }

    @NotNull
    public Void openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(other.getClass(), this.getClass())) {
            return false;
        }
        KaptJavaFileObject cfr_ignored_0 = (KaptJavaFileObject)other;
        if (!Intrinsics.areEqual((Object)this.compilationUnit, (Object)((KaptJavaFileObject)other).compilationUnit)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clazz, (Object)((KaptJavaFileObject)other).clazz)) {
            return false;
        }
        return this.timestamp == ((KaptJavaFileObject)other).timestamp;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.compilationUnit.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + Long.hashCode(this.timestamp);
        return result;
    }
}

