/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.tools.javac.tree.JCTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.KaptContextForStubGeneration;
import org.jetbrains.kotlin.kapt3.base.stubs.FileInfoKt;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010$\u001a\u00020%R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u0006j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollector;", "", "kaptContext", "Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;", "(Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;)V", "filePaths", "", "Lcom/intellij/psi/PsiFile;", "Lkotlin/Pair;", "", "", "lineInfo", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "Lorg/jetbrains/kotlin/kapt3/base/stubs/LineInfoMap;", "signatureInfo", "getFilePathRelativePreferred", "file", "getPosition", "clazz", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "field", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "register", "", "asmNode", "fqName", "psiElement", "Lcom/intellij/psi/PsiElement;", "registerClass", "registerField", "registerMethod", "registerSignature", "declaration", "Lcom/sun/tools/javac/tree/JCTree$JCMethodDecl;", "serialize", "", "kotlin-annotation-processing"})
public final class KaptLineMappingCollector {
    @NotNull
    private final KaptContextForStubGeneration kaptContext;
    @NotNull
    private final Map<String, KotlinPosition> lineInfo;
    @NotNull
    private final Map<String, String> signatureInfo;
    @NotNull
    private final Map<PsiFile, Pair<String, Boolean>> filePaths;

    public KaptLineMappingCollector(@NotNull KaptContextForStubGeneration kaptContext) {
        Intrinsics.checkNotNullParameter((Object)kaptContext, (String)"kaptContext");
        this.kaptContext = kaptContext;
        boolean bl = false;
        this.lineInfo = new LinkedHashMap();
        bl = false;
        this.signatureInfo = new LinkedHashMap();
        bl = false;
        this.filePaths = new LinkedHashMap();
    }

    public final void registerClass(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        String string = clazz.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
        this.register(clazz, string);
    }

    public final void registerMethod(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.register(method, clazz.name + '#' + method.name + method.desc);
    }

    public final void registerField(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.register(field, clazz.name + '#' + field.name);
    }

    public final void registerSignature(@NotNull JCTree.JCMethodDecl declaration, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Map<String, String> map = this.signatureInfo;
        String string = FileInfoKt.getJavacSignature(declaration);
        String string2 = Intrinsics.stringPlus((String)method.name, (Object)method.desc);
        boolean bl = false;
        map.put(string, string2);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return this.lineInfo.get(clazz.name);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.lineInfo.get(clazz.name + '#' + method.name + method.desc);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.lineInfo.get(clazz.name + '#' + field.name);
    }

    private final void register(Object asmNode, String fqName) {
        PsiElement psiElement;
        JvmDeclarationOrigin jvmDeclarationOrigin = this.kaptContext.getOrigins().get(asmNode);
        PsiElement psiElement2 = psiElement = jvmDeclarationOrigin == null ? null : jvmDeclarationOrigin.getElement();
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement3 = psiElement;
        this.register(fqName, psiElement3);
    }

    private final void register(String fqName, PsiElement psiElement) {
        VirtualFile containingVirtualFile = psiElement.getContainingFile().getVirtualFile();
        if (containingVirtualFile == null || FileDocumentManager.getInstance().getDocument(containingVirtualFile) == null) {
            return;
        }
        Pair<String, Boolean> pair = psiElement.getTextRange();
        if (pair == null) {
            return;
        }
        Pair<String, Boolean> textRange = pair;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiElement.containingFile");
        pair = this.getFilePathRelativePreferred(psiFile);
        String path = (String)pair.component1();
        boolean isRelative = (Boolean)pair.component2();
        Map<String, KotlinPosition> map = this.lineInfo;
        KotlinPosition kotlinPosition = new KotlinPosition(path, isRelative, textRange.getStartOffset());
        boolean bl = false;
        map.put(fqName, kotlinPosition);
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<String, Boolean> getFilePathRelativePreferred(PsiFile file) {
        block5: {
            block4: {
                $this$getOrPut$iv = this.filePaths;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(file);
                if (value$iv != null) break block4;
                $i$a$-getOrPut-KaptLineMappingCollector$getFilePathRelativePreferred$1 = false;
                var6_7 = file.getVirtualFile().getCanonicalPath();
                var7_8 = var6_7 == null ? file.getVirtualFile().getPath() : var6_7;
                Intrinsics.checkNotNullExpressionValue((Object)var7_8, (String)"file.virtualFile.canonicalPath ?: file.virtualFile.path");
                absolutePath = var7_8;
                absoluteFile = new File(absolutePath);
                var9_10 = file.getProject().getBasePath();
                if (var9_10 == null) {
                    v0 = null;
                } else {
                    var10_11 = var9_10;
                    var11_12 = false;
                    var12_13 = false;
                    it = var10_11;
                    $i$a$-let-KaptLineMappingCollector$getFilePathRelativePreferred$1$baseFile$1 = false;
                    v0 = new File(it);
                }
                baseFile = v0;
                if (!absoluteFile.exists() || baseFile == null || !baseFile.exists()) ** GOTO lbl-1000
                var10_11 = FilesKt.relativeToOrNull((File)absoluteFile, (File)baseFile);
                v1 = relativePath = var10_11 == null ? null : var10_11.getPath();
                if (relativePath != null) {
                    v2 = new Pair((Object)relativePath, (Object)true);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = new Pair((Object)absolutePath, (Object)false);
                }
                answer$iv = v2;
                $this$getOrPut$iv.put(file, (Pair<String, Boolean>)answer$iv);
                v3 = answer$iv;
                break block5;
            }
            v3 = value$iv;
        }
        return v3;
    }

    @NotNull
    public final byte[] serialize() {
        Object kotlinPosition;
        boolean bl;
        Map.Entry<String, Object> entry;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(1);
        oos.writeInt(this.lineInfo.size());
        Map<String, KotlinPosition> object22 = this.lineInfo;
        boolean bl2 = false;
        Object object = object22.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, KotlinPosition> entry2;
            Map.Entry<String, KotlinPosition> entry3 = entry2 = object.next();
            boolean bl3 = false;
            String fqName = entry3.getKey();
            entry = entry2;
            bl = false;
            kotlinPosition = entry.getValue();
            oos.writeUTF(fqName);
            oos.writeUTF(((KotlinPosition)kotlinPosition).getPath());
            oos.writeBoolean(((KotlinPosition)kotlinPosition).isRelativePath());
            oos.writeInt(((KotlinPosition)kotlinPosition).getPos());
        }
        oos.writeInt(this.signatureInfo.size());
        Map<String, String> map = this.signatureInfo;
        boolean fqName = false;
        for (Map.Entry<String, Object> entry4 : map.entrySet()) {
            kotlinPosition = entry4;
            boolean bl4 = false;
            String javacSignature = (String)kotlinPosition.getKey();
            entry = entry4;
            bl = false;
            String methodDesc = (String)entry.getValue();
            oos.writeUTF(javacSignature);
            oos.writeUTF(methodDesc);
        }
        oos.flush();
        object = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"os.toByteArray()");
        return object;
    }
}

