/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aJ\r\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "Ljava/io/Serializable;", "()V", "dependencyCache", "", "", "", "Ljava/net/URI;", "nonTransitiveCache", "sourceCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "addSourceStructure", "", "sourceStructure", "getAllImpactedTypes", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "getSourceForType", "Ljava/io/File;", "type", "getStructure", "sourceFile", "getStructure$kotlin_annotation_processing_base", "getTypesForFiles", "", "files", "", "invalidateAll", "invalidateAll$kotlin_annotation_processing_base", "invalidateDataForTypes", "impactedTypes", "isAlreadyProcessed", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "kotlin-annotation-processing-base"})
public final class JavaClassCache
implements Serializable {
    private Map<URI, SourceFileStructure> sourceCache;
    private transient Map<String, Set<URI>> dependencyCache;
    private transient Map<String, Set<URI>> nonTransitiveCache;

    public final void addSourceStructure(@NotNull SourceFileStructure sourceStructure) {
        Intrinsics.checkNotNullParameter((Object)sourceStructure, (String)"sourceStructure");
        this.sourceCache.put(sourceStructure.getSourceFile(), sourceStructure);
    }

    @NotNull
    public final Set<String> getTypesForFiles(@NotNull Collection<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        HashSet typesFromFiles = new HashSet(files.size());
        for (File file : files) {
            Object object = this.sourceCache.get(file.toURI());
            if (object == null || (object = ((SourceFileStructure)object).getDeclaredTypes()) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            typesFromFiles.addAll((Collection)it);
        }
        return typesFromFiles;
    }

    private final void readObject(ObjectInputStream input) {
        Set dependants;
        boolean bl;
        Object object = input.readObject();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.net.URI, org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure>");
        }
        this.sourceCache = TypeIntrinsics.asMutableMap((Object)object);
        this.dependencyCache = new HashMap(this.sourceCache.size() * 4);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String mentionedType : sourceInfo.getMentionedTypes()) {
                Set set = this.dependencyCache.get(mentionedType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.dependencyCache.put(mentionedType, dependants);
            }
            for (String mentionedConstants : sourceInfo.getMentionedConstants().keySet()) {
                Set set = this.dependencyCache.get(mentionedConstants);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.dependencyCache.put(mentionedConstants, dependants);
            }
        }
        this.nonTransitiveCache = new HashMap(this.sourceCache.size() * 2);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String privateType : sourceInfo.getPrivateTypes()) {
                Set set = this.nonTransitiveCache.get(privateType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.nonTransitiveCache.put(privateType, dependants);
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) {
        output.writeObject(this.sourceCache);
    }

    public final boolean isAlreadyProcessed(@NotNull URI sourceFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        if (!sourceFile.isAbsolute()) {
            return true;
        }
        if (sourceFile.isOpaque()) {
            return true;
        }
        try {
            bl = this.sourceCache.containsKey(sourceFile);
        }
        catch (IllegalArgumentException e) {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final SourceFileStructure getStructure$kotlin_annotation_processing_base(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.get(sourceFile.toURI());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getAllImpactedTypes(@NotNull Changes changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Function3<String, Set<String>, Set<String>, Unit> $fun$findImpactedTypes$1 = new Function3<String, Set<String>, Set<String>, Unit>(this){
            final /* synthetic */ JavaClassCache this$0;

            public final void invoke(@NotNull String changedType, @NotNull Set<String> transitiveDeps, @NotNull Set<String> nonTransitiveDeps) {
                URI it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Set impactedSources;
                boolean bl;
                boolean bl2;
                Set set;
                Intrinsics.checkNotNullParameter((Object)changedType, (String)"changedType");
                Intrinsics.checkNotNullParameter(transitiveDeps, (String)"transitiveDeps");
                Intrinsics.checkNotNullParameter(nonTransitiveDeps, (String)"nonTransitiveDeps");
                Set set2 = (Set)JavaClassCache.access$getDependencyCache$p(this.this$0).get(changedType);
                if (set2 != null) {
                    set = set2;
                    bl2 = false;
                    bl = false;
                    impactedSources = set;
                    boolean bl3 = false;
                    $this$forEach$iv = impactedSources;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (URI)element$iv;
                        boolean bl4 = false;
                        transitiveDeps.addAll((Collection<String>)((SourceFileStructure)MapsKt.getValue((Map)JavaClassCache.access$getSourceCache$p(this.this$0), (Object)it)).getDeclaredTypes());
                    }
                }
                Set set3 = (Set)JavaClassCache.access$getNonTransitiveCache$p(this.this$0).get(changedType);
                if (set3 != null) {
                    set = set3;
                    bl2 = false;
                    bl = false;
                    impactedSources = set;
                    boolean bl5 = false;
                    $this$forEach$iv = impactedSources;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (URI)element$iv;
                        boolean bl6 = false;
                        nonTransitiveDeps.addAll((Collection<String>)((SourceFileStructure)MapsKt.getValue((Map)JavaClassCache.access$getSourceCache$p(this.this$0), (Object)it)).getDeclaredTypes());
                    }
                }
            }
            {
                this.this$0 = javaClassCache;
                super(3);
            }
        };
        boolean bl = false;
        Set allDirtyTypes = new LinkedHashSet();
        Set currentDirtyTypes = CollectionsKt.toMutableSet((Iterable)this.getTypesForFiles(changes.getSourceChanges()));
        Iterable $this$forEach$iv = changes.getDirtyFqNamesFromClasspath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String classpathChange = (String)element$iv;
            boolean bl2 = false;
            $fun$findImpactedTypes$1.invoke(classpathChange, (Set<String>)currentDirtyTypes, (Set<String>)allDirtyTypes);
        }
        while (true) {
            void $this$filterTo$iv;
            $this$forEach$iv = currentDirtyTypes;
            $i$f$forEach = false;
            if (!(!$this$forEach$iv.isEmpty())) break;
            $i$f$forEach = false;
            Set nextRound = new LinkedHashSet();
            for (String dirtyType : currentDirtyTypes) {
                allDirtyTypes.add(dirtyType);
                $fun$findImpactedTypes$1.invoke(dirtyType, (Set<String>)nextRound, (Set<String>)allDirtyTypes);
            }
            Iterable dirtyType = nextRound;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                if (!(!allDirtyTypes.contains(it))) continue;
                destination$iv.add(element$iv);
            }
            Collection collection = destination$iv;
            currentDirtyTypes = (Set)collection;
        }
        return allDirtyTypes;
    }

    public final void invalidateAll$kotlin_annotation_processing_base() {
        this.sourceCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getSourceForType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<URI, SourceFileStructure> $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Map<URI, SourceFileStructure> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<URI, SourceFileStructure>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void fileUri;
            Map.Entry<URI, SourceFileStructure> element$iv;
            Map.Entry<URI, SourceFileStructure> $dstr$fileUri$typeInfo = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<URI, SourceFileStructure> entry = $dstr$fileUri$typeInfo;
            boolean bl3 = false;
            URI uRI = entry.getKey();
            entry = $dstr$fileUri$typeInfo;
            bl3 = false;
            SourceFileStructure typeInfo = entry.getValue();
            if (!typeInfo.getDeclaredTypes().contains(type)) continue;
            return new File((URI)fileUri);
        }
        throw (Throwable)new IllegalStateException("Unable to find source file for type " + type);
    }

    /*
     * WARNING - void declaration
     */
    public final void invalidateDataForTypes(@NotNull Set<String> impactedTypes) {
        Intrinsics.checkNotNullParameter(impactedTypes, (String)"impactedTypes");
        boolean bl = false;
        Set allSources = new LinkedHashSet();
        Object $this$forEach$iv = this.sourceCache;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<URI, SourceFileStructure>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void fileUri;
            boolean bl3;
            block5: {
                Map.Entry<URI, SourceFileStructure> element$iv;
                Map.Entry<URI, SourceFileStructure> $dstr$fileUri$typeInfo = element$iv = iterator.next();
                boolean bl4 = false;
                Map.Entry<URI, SourceFileStructure> entry = $dstr$fileUri$typeInfo;
                boolean bl5 = false;
                URI uRI = entry.getKey();
                entry = $dstr$fileUri$typeInfo;
                bl5 = false;
                SourceFileStructure typeInfo = entry.getValue();
                Iterable $this$any$iv = typeInfo.getDeclaredTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl6 = false;
                        if (!impactedTypes.contains(it)) continue;
                        bl3 = true;
                        break block5;
                    }
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            allSources.add(fileUri);
        }
        $this$forEach$iv = allSources;
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            URI it = (URI)element$iv;
            boolean bl7 = false;
            this.sourceCache.remove(it);
        }
    }

    public JavaClassCache() {
        boolean bl = false;
        this.sourceCache = new LinkedHashMap();
        bl = false;
        this.dependencyCache = new LinkedHashMap();
        bl = false;
        this.nonTransitiveCache = new LinkedHashMap();
    }

    public static final /* synthetic */ Map access$getDependencyCache$p(JavaClassCache $this) {
        return $this.dependencyCache;
    }

    public static final /* synthetic */ void access$setDependencyCache$p(JavaClassCache $this, Map map) {
        $this.dependencyCache = map;
    }

    public static final /* synthetic */ Map access$getSourceCache$p(JavaClassCache $this) {
        return $this.sourceCache;
    }

    public static final /* synthetic */ void access$setSourceCache$p(JavaClassCache $this, Map map) {
        $this.sourceCache = map;
    }

    public static final /* synthetic */ Map access$getNonTransitiveCache$p(JavaClassCache $this) {
        return $this.nonTransitiveCache;
    }

    public static final /* synthetic */ void access$setNonTransitiveCache$p(JavaClassCache $this, Map map) {
        $this.nonTransitiveCache = map;
    }
}

