/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0017\u0010\u0011\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0086\bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/kapt3/util/KaptLogger;", "", "isVerbose", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(ZLorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "()Z", "getMessageCollector", "()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "error", "", "message", "", "exception", "e", "", "info", "Lkotlin/Function0;", "warn", "Companion", "kotlin-annotation-processing"})
public final class KaptLogger {
    private final boolean isVerbose;
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private static final String PREFIX = "[kapt] ";
    public static final Companion Companion = new Companion(null);

    public final void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.isVerbose) {
            this.messageCollector.report(CompilerMessageSeverity.INFO, Companion.getPREFIX() + message, CompilerMessageLocation.NO_LOCATION);
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.isVerbose()) {
            this.info((String)message.invoke());
        }
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.WARNING, Companion.getPREFIX() + message, CompilerMessageLocation.NO_LOCATION);
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.ERROR, Companion.getPREFIX() + message, CompilerMessageLocation.NO_LOCATION);
    }

    public final void exception(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        KaptLogger kaptLogger = this;
        KaptLogger kaptLogger2 = kaptLogger;
        StringWriter writer = new StringWriter();
        Throwable throwable = e;
        PrintWriter printWriter = new PrintWriter(writer);
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
        }
        throwable2.printStackTrace(printWriter);
        String stacktrace = writer.toString();
        this.messageCollector.report(CompilerMessageSeverity.EXCEPTION, Companion.getPREFIX() + "An exception occurred: " + stacktrace, CompilerMessageLocation.NO_LOCATION);
    }

    public final boolean isVerbose() {
        return this.isVerbose;
    }

    @NotNull
    public final MessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    public KaptLogger(boolean isVerbose, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        this.isVerbose = isVerbose;
        this.messageCollector = messageCollector;
    }

    public /* synthetic */ KaptLogger(boolean bl, MessageCollector messageCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            messageCollector = (MessageCollector)new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, bl);
        }
        this(bl, messageCollector);
    }

    static {
        PREFIX = PREFIX;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/kapt3/util/KaptLogger$Companion;", "", "()V", "PREFIX", "", "getPREFIX", "()Ljava/lang/String;", "kotlin-annotation-processing"})
    private static final class Companion {
        @NotNull
        public final String getPREFIX() {
            return PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

