/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.elements;

import javax.lang.model.element.AnnotationValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteral;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.java.model.elements.JeAnnotationAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeArrayAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeEnumValueAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeErrorAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeExpressionAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeLiteralAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeTypeAnnotationValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"JeAnnotationValue", "Ljavax/lang/model/element/AnnotationValue;", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiAnnotationMemberValue;", "kotlin-annotation-processing"})
public final class JeAnnotationValueKt {
    @NotNull
    public static final AnnotationValue JeAnnotationValue(@NotNull PsiAnnotationMemberValue psi) {
        AnnotationValue annotationValue;
        PsiElement original;
        Intrinsics.checkParameterIsNotNull((Object)psi, (String)"psi");
        PsiElement psiElement = original = psi.getOriginalElement();
        if (psiElement instanceof PsiLiteral) {
            annotationValue = new JeLiteralAnnotationValue((PsiLiteral)original);
        } else if (psiElement instanceof PsiAnnotation) {
            annotationValue = new JeAnnotationAnnotationValue((PsiAnnotation)original);
        } else if (psiElement instanceof PsiArrayInitializerMemberValue) {
            annotationValue = new JeArrayAnnotationValue((PsiArrayInitializerMemberValue)original);
        } else if (psiElement instanceof PsiClassObjectAccessExpression) {
            annotationValue = new JeTypeAnnotationValue((PsiClassObjectAccessExpression)original);
        } else if (psiElement instanceof PsiReferenceExpression) {
            PsiElement element = ((PsiReferenceExpression)original).resolve();
            if (element instanceof PsiEnumConstant) {
                annotationValue = new JeEnumValueAnnotationValue((PsiEnumConstant)element);
            } else if (element instanceof PsiField && ((PsiField)element).hasInitializer()) {
                PsiExpression psiExpression = ((PsiField)element).getInitializer();
                if (psiExpression == null) {
                    String string = "Field should have an initializer";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                annotationValue = JeAnnotationValueKt.JeAnnotationValue((PsiAnnotationMemberValue)psiExpression);
            } else {
                annotationValue = new JeErrorAnnotationValue((PsiElement)psi);
            }
        } else if (psiElement instanceof PsiExpression) {
            annotationValue = new JeExpressionAnnotationValue((PsiExpression)original);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unsupported annotation element value: " + psi + " (original = " + original + ")")));
        }
        AnnotationValue annotationValue2 = annotationValue;
        return annotationValue2;
    }
}

