/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.java.model.JeElement;
import org.jetbrains.kotlin.java.model.elements.DefaultJeElementRenderer$WhenMappings;
import org.jetbrains.kotlin.java.model.elements.JeAnnotationAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeArrayAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeClassInitializerExecutableElement;
import org.jetbrains.kotlin.java.model.elements.JeElementRenderer;
import org.jetbrains.kotlin.java.model.elements.JeEnumValueAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeErrorAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeExpressionAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeLiteralAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeMethodExecutableElement;
import org.jetbrains.kotlin.java.model.elements.JePackageElement;
import org.jetbrains.kotlin.java.model.elements.JeSingletonArrayAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeTypeAnnotationValue;
import org.jetbrains.kotlin.java.model.elements.JeTypeElement;
import org.jetbrains.kotlin.java.model.elements.JeVariableElement;
import org.jetbrains.kotlin.java.model.types.JeErrorType;
import org.jetbrains.kotlin.java.model.types.JeNoneType;
import org.jetbrains.kotlin.java.model.types.JeNullType;
import org.jetbrains.kotlin.java.model.types.JePsiType;
import org.jetbrains.kotlin.java.model.types.JeVoidType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0002J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/java/model/elements/DefaultJeElementRenderer;", "Lorg/jetbrains/kotlin/java/model/elements/JeElementRenderer;", "()V", "render", "", "element", "Lorg/jetbrains/kotlin/java/model/JeElement;", "renderAnnotation", "anno", "Ljavax/lang/model/element/AnnotationMirror;", "renderAnnotationValue", "av", "Ljavax/lang/model/element/AnnotationValue;", "renderAnnotations", "Ljavax/lang/model/element/Element;", "renderConstantValue", "value", "", "renderModifiers", "renderType", "type", "Ljavax/lang/model/type/TypeMirror;", "noneAsVoid", "", "withMargin", "Companion", "kotlin-annotation-processing"})
public final class DefaultJeElementRenderer
implements JeElementRenderer {
    @NotNull
    private static final String MARGIN = "    ";
    @NotNull
    private static final String LINE_SEPARATOR;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String render(@NotNull JeElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        JeElement jeElement = element;
        if (jeElement instanceof JePackageElement) {
            void $receiver$iv;
            void $receiver;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder;
            Iterable iterable = $receiver;
            String string2 = "package " + ((JePackageElement)element).getQualifiedName();
            StringsKt.appendln((StringBuilder)StringsKt.appendln((StringBuilder)((StringBuilder)((Object)iterable)).append(string2)));
            iterable = ((JePackageElement)element).getEnclosedElements();
            for (Object element$iv : $receiver$iv) {
                JeTypeElement it = (JeTypeElement)element$iv;
                void var9_16 = $receiver;
                String string3 = this.withMargin(this.render(it));
                StringsKt.appendln((StringBuilder)StringsKt.appendln((StringBuilder)var9_16.append(string3)));
            }
            String string4 = stringBuilder.toString();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        } else if (jeElement instanceof JeTypeElement) {
            String string5;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder $receiver = stringBuilder;
            switch (DefaultJeElementRenderer$WhenMappings.$EnumSwitchMapping$0[((JeTypeElement)element).getKind().ordinal()]) {
                case 1: {
                    string5 = "@interface";
                    break;
                }
                case 2: {
                    string5 = "interface";
                    break;
                }
                case 3: {
                    string5 = "enum";
                    break;
                }
                case 4: {
                    string5 = "class";
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Invalid class type: " + (Object)((Object)((JeTypeElement)element).getKind()));
                }
            }
            String classType = string5;
            StringBuilder stringBuilder3 = $receiver;
            String string6 = this.renderModifiers(element) + classType + ' ' + ((JeTypeElement)element).getSimpleName() + " {";
            StringsKt.appendln((StringBuilder)stringBuilder3.append(string6));
            stringBuilder3 = $receiver;
            string6 = CollectionsKt.joinToString$default((Iterable)((JeTypeElement)element).getEnclosedElements(), (CharSequence)StringsKt.repeat((CharSequence)Companion.getLINE_SEPARATOR(), (int)2), null, null, (int)0, null, (Function1)((Function1)new Function1<JeElement, String>(this, element){
                final /* synthetic */ DefaultJeElementRenderer this$0;
                final /* synthetic */ JeElement $element$inlined;

                public final String invoke(JeElement it) {
                    return DefaultJeElementRenderer.access$withMargin(this.this$0, this.this$0.render(it));
                }
                {
                    this.this$0 = defaultJeElementRenderer;
                    this.$element$inlined = jeElement;
                    super(1);
                }
            }), (int)30, null);
            StringsKt.appendln((StringBuilder)stringBuilder3.append(string6));
            $receiver.append("}");
            String string7 = stringBuilder.toString();
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
        } else if (jeElement instanceof JeVariableElement) {
            string = this.renderModifiers(element) + DefaultJeElementRenderer.renderType$default(this, ((JeVariableElement)element).asType(), false, 2, null) + " " + ((JeVariableElement)element).getSimpleName();
        } else if (jeElement instanceof JeMethodExecutableElement) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder $receiver = stringBuilder;
            $receiver.append(this.renderModifiers(element) + this.renderType(((JeMethodExecutableElement)element).getReturnType(), true) + " " + ((JeMethodExecutableElement)element).getSimpleName());
            $receiver.append(CollectionsKt.joinToString$default((Iterable)((JeMethodExecutableElement)element).getParameters(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<JeVariableElement, String>(this, element){
                final /* synthetic */ DefaultJeElementRenderer this$0;
                final /* synthetic */ JeElement $element$inlined;

                public final String invoke(JeVariableElement it) {
                    return DefaultJeElementRenderer.renderType$default(this.this$0, it.asType(), false, 2, null) + " " + it.getSimpleName();
                }
                {
                    this.this$0 = defaultJeElementRenderer;
                    this.$element$inlined = jeElement;
                    super(1);
                }
            }), (int)25, null));
            String string8 = stringBuilder.toString();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"StringBuilder().apply(builderAction).toString()");
        } else if (jeElement instanceof JeClassInitializerExecutableElement) {
            string = this.renderModifiers(element) + "{}";
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported element: " + element);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String renderType(TypeMirror type, boolean noneAsVoid) {
        TypeMirror typeMirror = type;
        if (typeMirror instanceof JeNullType) {
            return "null";
        }
        if (typeMirror instanceof JeVoidType) {
            return "void";
        }
        if (typeMirror instanceof JeErrorType) {
            return "<ERROR>";
        }
        if (typeMirror instanceof JeNoneType) {
            if (!noneAsVoid) throw (Throwable)new IllegalArgumentException("Unexpected 'none' type");
            return "void";
        }
        if (!(typeMirror instanceof JePsiType)) throw (Throwable)new IllegalArgumentException("Unsupported type: " + type);
        String string = ((JePsiType)type).getPsiType().getCanonicalText(false);
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.psiType.getCanonicalText(false)");
        return string2;
    }

    static /* bridge */ /* synthetic */ String renderType$default(DefaultJeElementRenderer defaultJeElementRenderer, TypeMirror typeMirror, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderType");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return defaultJeElementRenderer.renderType(typeMirror, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderModifiers(Element element) {
        String string;
        String renderedAnnotations = this.renderAnnotations(element);
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.isEmpty()) {
            string = renderedAnnotations;
        } else {
            List list;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = modifiers;
            StringBuilder stringBuilder = new StringBuilder().append(renderedAnnotations);
            void var5_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string2;
                void it;
                Modifier modifier = (Modifier)((Object)item$iv$iv);
                list = destination$iv$iv;
                String string3 = it.name();
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                list.add(string2);
            }
            list = (List)destination$iv$iv;
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, (CharSequence)" ", (int)0, null, null, (int)58, null)).toString();
        }
        return string;
    }

    private final String renderAnnotations(Element element) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        if (annotations.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)annotations, (CharSequence)Companion.getLINE_SEPARATOR(), null, (CharSequence)Companion.getLINE_SEPARATOR(), (int)0, null, (Function1)((Function1)new Function1<AnnotationMirror, String>(this){
            final /* synthetic */ DefaultJeElementRenderer this$0;

            @NotNull
            public final String invoke(AnnotationMirror it) {
                AnnotationMirror annotationMirror = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationMirror, (String)"it");
                return DefaultJeElementRenderer.access$renderAnnotation(this.this$0, annotationMirror);
            }
            {
                this.this$0 = defaultJeElementRenderer;
                super(1);
            }
        }), (int)26, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderAnnotation(AnnotationMirror anno) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        StringBuilder stringBuilder = new StringBuilder().append("@");
        TypeMirror typeMirror = anno.getAnnotationType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"anno.annotationType");
        String name = stringBuilder.append(DefaultJeElementRenderer.renderType$default(this, typeMirror, false, 2, null)).toString();
        Map<? extends ExecutableElement, ? extends AnnotationValue> args = anno.getElementValues();
        if (args.isEmpty()) {
            return name;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = args;
        StringBuilder stringBuilder2 = new StringBuilder().append(name);
        void var5_6 = $receiver$iv;
        Collection collection = new ArrayList($receiver$iv.size());
        void var7_8 = $receiver$iv$iv;
        Iterator iterator = var7_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            list = destination$iv$iv;
            StringBuilder stringBuilder3 = new StringBuilder().append(((ExecutableElement)it.getKey()).getSimpleName().toString()).append(" = ");
            AnnotationValue annotationValue = (AnnotationValue)it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"it.value");
            String string = stringBuilder3.append(this.renderAnnotationValue(annotationValue)).toString();
            list.add(string);
        }
        list = (List)destination$iv$iv;
        return stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null)).toString();
    }

    private final String renderAnnotationValue(AnnotationValue av) {
        Object object;
        block5: {
            AnnotationValue annotationValue;
            block10: {
                block11: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        annotationValue = av;
                                        if (!(annotationValue instanceof JeAnnotationAnnotationValue)) break block4;
                                        object = this.renderAnnotation(((JeAnnotationAnnotationValue)av).getValue());
                                        break block5;
                                    }
                                    if (!(annotationValue instanceof JeArrayAnnotationValue)) break block6;
                                    object = CollectionsKt.joinToString$default((Iterable)((Iterable)((JeArrayAnnotationValue)av).getValue()), null, (CharSequence)"{ ", (CharSequence)" }", (int)0, null, (Function1)((Function1)new Function1<AnnotationValue, String>(this){
                                        final /* synthetic */ DefaultJeElementRenderer this$0;

                                        @NotNull
                                        public final String invoke(@NotNull AnnotationValue it) {
                                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                            return DefaultJeElementRenderer.access$renderAnnotationValue(this.this$0, it);
                                        }
                                        {
                                            this.this$0 = defaultJeElementRenderer;
                                            super(1);
                                        }
                                    }), (int)25, null);
                                    break block5;
                                }
                                if (!(annotationValue instanceof JeSingletonArrayAnnotationValue)) break block7;
                                object = CollectionsKt.joinToString$default((Iterable)((Iterable)((JeSingletonArrayAnnotationValue)av).getValue()), null, (CharSequence)"{ ", (CharSequence)" }", (int)0, null, (Function1)((Function1)new Function1<AnnotationValue, String>(this){
                                    final /* synthetic */ DefaultJeElementRenderer this$0;

                                    @NotNull
                                    public final String invoke(@NotNull AnnotationValue it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        return DefaultJeElementRenderer.access$renderAnnotationValue(this.this$0, it);
                                    }
                                    {
                                        this.this$0 = defaultJeElementRenderer;
                                        super(1);
                                    }
                                }), (int)25, null);
                                break block5;
                            }
                            if (!(annotationValue instanceof JeEnumValueAnnotationValue)) break block8;
                            object = ((JeEnumValueAnnotationValue)av).getValue().getSimpleName().toString();
                            break block5;
                        }
                        if (!(annotationValue instanceof JeErrorAnnotationValue)) break block9;
                        object = "<ERROR>";
                        break block5;
                    }
                    if (!(annotationValue instanceof JeExpressionAnnotationValue) && !(annotationValue instanceof JeLiteralAnnotationValue)) break block10;
                    object = av.getValue();
                    if (object == null) break block11;
                    Object object2 = object;
                    Object it = object2;
                    object = this.renderConstantValue(it);
                    if (object != null) break block5;
                }
                object = "null";
                break block5;
            }
            if (annotationValue instanceof JeTypeAnnotationValue) {
                object = DefaultJeElementRenderer.renderType$default(this, ((JeTypeAnnotationValue)av).getValue(), false, 2, null) + ".class";
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported annotation value: " + av);
            }
        }
        return object;
    }

    private final String renderConstantValue(Object value) {
        Object object = value;
        return Intrinsics.areEqual((Object)object, null) ? "null" : (object instanceof String ? "\"" + StringsKt.replace$default((String)((String)value), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\"" : value.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final String withMargin(@NotNull String $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = StringsKt.lines((CharSequence)$receiver);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var11_8 = destination$iv$iv;
            String string2 = Companion.getMARGIN() + (String)it;
            var11_8.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)Companion.getLINE_SEPARATOR(), null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Companion = new Companion(null);
        MARGIN = MARGIN;
        String string = System.getProperty("line.separator");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"line.separator\")");
        LINE_SEPARATOR = string;
    }

    @NotNull
    public static final /* synthetic */ String access$withMargin(DefaultJeElementRenderer $this, @NotNull String $receiver) {
        return $this.withMargin($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$renderAnnotation(DefaultJeElementRenderer $this, @NotNull AnnotationMirror anno) {
        return $this.renderAnnotation(anno);
    }

    @NotNull
    public static final /* synthetic */ String access$renderAnnotationValue(DefaultJeElementRenderer $this, @NotNull AnnotationValue av) {
        return $this.renderAnnotationValue(av);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/java/model/elements/DefaultJeElementRenderer$Companion;", "", "()V", "LINE_SEPARATOR", "", "getLINE_SEPARATOR", "()Ljava/lang/String;", "MARGIN", "getMARGIN", "kotlin-annotation-processing"})
    private static final class Companion {
        @NotNull
        public final String getMARGIN() {
            return MARGIN;
        }

        @NotNull
        public final String getLINE_SEPARATOR() {
            return LINE_SEPARATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

