/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation.processing.impl;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/annotation/processing/impl/Constants;", "", "()V", "format", "", "value", "formatByte", "b", "", "formatChar", "c", "", "formatDouble", "d", "", "formatFloat", "f", "", "formatLong", "lng", "", "formatShort", "s", "", "formatString", "isPrintableAscii", "", "ch", "quote", "kotlin-annotation-processing"})
public final class Constants {
    public static final Constants INSTANCE;

    @NotNull
    public final String format(@Nullable Object value) {
        String string;
        Object object = value;
        if (object instanceof Byte) {
            Byte by = (Byte)value;
            if (by == null) {
                Intrinsics.throwNpe();
            }
            string = this.formatByte(by);
        } else if (object instanceof Short) {
            Short s = (Short)value;
            if (s == null) {
                Intrinsics.throwNpe();
            }
            string = this.formatShort(s);
        } else if (object instanceof Long) {
            Long l = (Long)value;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            string = this.formatLong(l);
        } else if (object instanceof Float) {
            Float f = (Float)value;
            if (f == null) {
                Intrinsics.throwNpe();
            }
            string = this.formatFloat(((Number)f).floatValue());
        } else if (object instanceof Double) {
            Double d = (Double)value;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            string = this.formatDouble(d);
        } else if (object instanceof Character) {
            string = this.formatChar(((Character)value).charValue());
        } else if (object instanceof String) {
            string = this.formatString((String)value);
        } else if (object instanceof Integer || object instanceof Boolean) {
            string = value.toString();
        } else {
            throw (Throwable)new IllegalArgumentException("Argument is not a primitive type or a string; it " + (value == null ? "is a null value." : "has class " + value.getClass().getName()) + ".");
        }
        return string;
    }

    private final String formatByte(byte b) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "(byte)0x%02x";
        Object[] objectArray = new Object[]{b};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private final String formatShort(short s) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "(short)%d";
        Object[] objectArray = new Object[]{s};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    private final String formatLong(long lng) {
        return lng + "L";
    }

    private final String formatChar(char c) {
        char c2 = '\'';
        String string = this.quote(c);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c2) + string;
        return stringBuilder.append(string2).append('\'').toString();
    }

    private final String formatString(String s) {
        char c = '\"';
        String string = this.quote(s);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    private final String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private final String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return String.valueOf(d);
    }

    @NotNull
    public final String quote(char ch) {
        String string;
        switch (ch) {
            case '\b': {
                string = "\\b";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            case '\'': {
                string = "\\'";
                break;
            }
            case '\"': {
                string = "\\\"";
                break;
            }
            case '\\': {
                string = "\\\\";
                break;
            }
            default: {
                if (this.isPrintableAscii(ch)) {
                    string = String.valueOf(ch);
                    break;
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "\\u%04x";
                Object[] objectArray = new Object[]{(int)ch};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String quote(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        StringBuilder buf = new StringBuilder();
        int n = 0;
        int n2 = s.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                buf.append(this.quote(s.charAt((int)i)));
                if (i == n2) break;
                ++i;
            }
        }
        String string = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
        return string;
    }

    private final boolean isPrintableAscii(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    private Constants() {
        INSTANCE = this;
    }

    static {
        new Constants();
    }
}

