/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.annotation.AnnotatedClassDescriptor;
import org.jetbrains.kotlin.annotation.AnnotatedConstructorDescriptor;
import org.jetbrains.kotlin.annotation.AnnotatedElementDescriptor;
import org.jetbrains.kotlin.annotation.AnnotatedFieldDescriptor;
import org.jetbrains.kotlin.annotation.AnnotatedMethodDescriptor;
import org.jetbrains.kotlin.annotation.KotlinAnnotationProvider;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0011)\u0001!B\u0001\r\u0003\u0015\tA!B\u0003\u0002\u0011\u0017)\u0001!B\u0001\t$\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u001c\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\t\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005A\u0001#\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\t\u0001a\u0001!G\u0001\u0019\u0002\u0005\u0016\u0012b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001\u0014A\u0005\u0004\u0011\u000bi\u0011\u0001G\u0002\n\u0007!\u001dQ\"\u0001\r\u0005#\u000e\t\u0001\u0012B\u0013\u0005\t-A\u0011\"D\u0001\u0019\u0014\u0015\nBa\u0003\u0005\u000b\u001b\u0019I1\u0001\"\u0001\n\u0003aYA\u0012\u0001M\u000b3\u001dA9\"D\u0003\n\u0007\u0011\u0005\u0011\"\u0001M\r11)S\u0002B\u0006\t\u001551\u0011b\u0001C\u0001\u0013\u0005A2\u0002$\u0001\u0019\u0016e\u0019\u0001rC\u0007\u000215)\u0013\u0002B\u0006\t\u001c51\u0011b\u0001C\u0001\u0013\u0005A2\u0002$\u0001\u0019\u0016\u0015\"Aa\u0003\u0005\u000f\u001b\u0005A\u001a\"J\u0006\u0005\u0003!uQ\u0002B\u0005\u0003\u0013\u0005A2\u0002G\b\u001a\u0007!}Q\"\u0001\r\u0011K;!\u0011\u0001#\t\u000e\t%\u0011\u0011\"\u0001\r\f1E)\u0012\u0001G\u0007\u001a\n!\rR\"\u0001\r\u0013!\u000e\u0005Q\u0005\u0006\u0003\u0002\u0011CiA!\u0003\u0002\n\u0003aY\u0001$E\u000b\u000215IJ\u0001c\t\u000e\u0003a\u0011\u0002k!\u0001\u001a\n!\u0015R\"\u0001\r\u0011!\u000e\tQu\u0003\u0003\u0002\u0011Mi\u0011\u0001g\u0005\u0016\u0003aY\u0011\u0014\u0002E\u0010\u001b\u0005A\u0002\u0003UB\u0001K/!\u0011\u0001c\n\u000e\u0003aMQ#\u0001\r\u000e3\u0013Ay\"D\u0001\u0019!A\u001b\t!\u000b\u0006\u0005\u0007\"A9!D\u0001\u0019\tE\u001bA!\u0002\u0001\u000e\u0005\u0011)\u00012B\u0015\u000b\t\rC\u0001BA\u0007\u00021\u0003\t6\u0001B\u0003\u0001\u001b\t!a\u0001#\u0004*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002E\bS)!1\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0005\t\u0012\u0001"}, strings={"Lorg/jetbrains/kotlin/annotation/RoundEnvironmentWrapper;", "Ljavax/annotation/processing/RoundEnvironment;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "parent", "roundNumber", "", "kotlinAnnotationsProvider", "Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "(Ljavax/annotation/processing/ProcessingEnvironment;Ljavax/annotation/processing/RoundEnvironment;ILorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;)V", "getKotlinAnnotationsProvider", "()Lorg/jetbrains/kotlin/annotation/KotlinAnnotationProvider;", "getParent", "()Ljavax/annotation/processing/RoundEnvironment;", "getProcessingEnv", "()Ljavax/annotation/processing/ProcessingEnvironment;", "getRoundNumber", "()I", "errorRaised", "", "getElementsAnnotatedWith", "", "Ljavax/lang/model/element/Element;", "a", "Ljava/lang/Class;", "", "Ljavax/lang/model/element/TypeElement;", "getRootElements", "processingOver", "resolveKotlinElements", "", "annotationFqName", "", "filterEnclosedElements", "", "kind", "Ljavax/lang/model/element/ElementKind;", "name", "hasAnnotation", "hasInheritedAnnotation"}, moduleName="kotlin-annotation-processing")
public final class RoundEnvironmentWrapper
implements RoundEnvironment {
    @NotNull
    private final ProcessingEnvironment processingEnv;
    @NotNull
    private final RoundEnvironment parent;
    private final int roundNumber;
    @NotNull
    private final KotlinAnnotationProvider kotlinAnnotationsProvider;

    @Override
    @Nullable
    public Set<? extends Element> getRootElements() {
        return this.parent.getRootElements();
    }

    @Override
    @Nullable
    public Set<? extends Element> getElementsAnnotatedWith(@NotNull TypeElement a) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        HashSet elements = CollectionsKt.toHashSet((Iterable)this.parent.getElementsAnnotatedWith(a));
        elements.addAll((Collection)this.resolveKotlinElements(a.getQualifiedName().toString()));
        return elements;
    }

    @Override
    @Nullable
    public Set<? extends Element> getElementsAnnotatedWith(@NotNull Class<? extends Annotation> a) {
        Intrinsics.checkParameterIsNotNull(a, (String)"a");
        HashSet elements = CollectionsKt.toHashSet((Iterable)this.parent.getElementsAnnotatedWith(a));
        String string = a.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.getName()");
        elements.addAll((Collection)this.resolveKotlinElements(string));
        return elements;
    }

    @Override
    public boolean processingOver() {
        return this.parent.processingOver();
    }

    @Override
    public boolean errorRaised() {
        return this.parent.errorRaised();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterEnclosedElements(TypeElement $receiver, ElementKind kind, String name) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = $receiver.getEnclosedElements();
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Element it = (Element)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)((Object)it.getKind()), (Object)((Object)kind)) && Intrinsics.areEqual((Object)it.getSimpleName().toString(), (Object)name))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> filterEnclosedElements(TypeElement $receiver, ElementKind kind) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = $receiver.getEnclosedElements();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Element it = (Element)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)it.getKind()), (Object)((Object)kind))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean hasAnnotation(Element $receiver, String annotationFqName) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getAnnotationMirrors();
            for (Object element$iv : $receiver$iv) {
                AnnotationMirror it = (AnnotationMirror)element$iv;
                if (!Intrinsics.areEqual((Object)annotationFqName, (Object)it.getAnnotationType().asElement().toString())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasInheritedAnnotation(TypeElement $receiver, String annotationFqName) {
        if (this.hasAnnotation($receiver, annotationFqName)) {
            return true;
        }
        TypeMirror superclassMirror = $receiver.getSuperclass();
        if (superclassMirror instanceof NoType) {
            return false;
        }
        Element superClass = this.processingEnv.getTypeUtils().asElement(superclassMirror);
        if (!(superClass instanceof TypeElement)) {
            return false;
        }
        return this.hasInheritedAnnotation((TypeElement)superClass, annotationFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Element> resolveKotlinElements(String annotationFqName) {
        void $receiver$iv;
        Iterable initial$iv;
        if (this.roundNumber > 1) {
            return SetsKt.setOf();
        }
        Set set = this.kotlinAnnotationsProvider.getAnnotatedKotlinElements().get(annotationFqName);
        if (set == null) {
            set = SetsKt.setOf();
        }
        Set descriptors = set;
        Iterable iterable = descriptors;
        HashSet hashSet = SetsKt.hashSetOf((Object[])new Element[0]);
        HashSet accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            HashSet hashSet2;
            void descriptor;
            AnnotatedElementDescriptor annotatedElementDescriptor = (AnnotatedElementDescriptor)element$iv;
            HashSet set2 = accumulator$iv;
            if (this.processingEnv.getElementUtils().getTypeElement(descriptor.getClassFqName()) == null) {
                hashSet2 = set2;
            } else {
                List list;
                Collection destination$iv$iv;
                Element it;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv2;
                HashSet hashSet3;
                TypeElement clazz;
                void var12_12 = descriptor;
                if (var12_12 instanceof AnnotatedClassDescriptor) {
                    set2.add(clazz);
                } else if (var12_12 instanceof AnnotatedConstructorDescriptor) {
                    Iterable iterable2 = this.filterEnclosedElements(clazz, ElementKind.CONSTRUCTOR);
                    hashSet3 = set2;
                    void var15_15 = $receiver$iv2;
                    Collection collection = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    hashSet3.addAll(list);
                } else if (var12_12 instanceof AnnotatedFieldDescriptor) {
                    $receiver$iv2 = this.filterEnclosedElements(clazz, ElementKind.FIELD, ((AnnotatedFieldDescriptor)descriptor).getFieldName());
                    hashSet3 = set2;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    hashSet3.addAll(list);
                } else if (var12_12 instanceof AnnotatedMethodDescriptor) {
                    $receiver$iv2 = this.filterEnclosedElements(clazz, ElementKind.METHOD, ((AnnotatedMethodDescriptor)descriptor).getMethodName());
                    hashSet3 = set2;
                    $receiver$iv$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!this.hasAnnotation(it, annotationFqName)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    hashSet3.addAll(list);
                }
                hashSet2 = set2;
            }
            accumulator$iv = hashSet2;
        }
        HashSet descriptorsWithKotlin = accumulator$iv;
        if (this.kotlinAnnotationsProvider.getSupportInheritedAnnotations()) {
            boolean isInherited;
            boolean bl;
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(annotationFqName);
            if (typeElement != null) {
                Element element = typeElement;
                String string = Inherited.class.getCanonicalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass<Inherited>().getCanonicalName()");
                bl = this.hasAnnotation(element, string);
            } else {
                bl = isInherited = false;
            }
            if (isInherited) {
                void $receiver$iv3;
                initial$iv = this.kotlinAnnotationsProvider.getKotlinClasses();
                for (Object element$iv : $receiver$iv3) {
                    TypeElement clazz;
                    String classFqName = (String)element$iv;
                    if (this.processingEnv.getElementUtils().getTypeElement(classFqName) == null) {
                        continue;
                    }
                    if (!this.hasInheritedAnnotation(clazz, annotationFqName)) continue;
                    descriptorsWithKotlin.add(clazz);
                }
            }
        }
        return descriptorsWithKotlin;
    }

    @NotNull
    public final ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    @NotNull
    public final RoundEnvironment getParent() {
        return this.parent;
    }

    public final int getRoundNumber() {
        return this.roundNumber;
    }

    @NotNull
    public final KotlinAnnotationProvider getKotlinAnnotationsProvider() {
        return this.kotlinAnnotationsProvider;
    }

    public RoundEnvironmentWrapper(@NotNull ProcessingEnvironment processingEnv2, @NotNull RoundEnvironment parent, int roundNumber, @NotNull KotlinAnnotationProvider kotlinAnnotationsProvider2) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv2, (String)"processingEnv");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)kotlinAnnotationsProvider2, (String)"kotlinAnnotationsProvider");
        this.processingEnv = processingEnv2;
        this.parent = parent;
        this.roundNumber = roundNumber;
        this.kotlinAnnotationsProvider = kotlinAnnotationsProvider2;
    }
}

