/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.lifetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KaLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KotlinReadActionConfinementLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.platform.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinReadActionConfinementLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "modificationTracker", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/ModificationTracker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/ModificationTracker;)V", "onCreatedTimeStamp", "", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker;", "getLifetimeTracker$annotations", "factory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "getFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenFactory;", "isValid", "", "getInvalidationReason", "", "isAccessible", "getInaccessibilityReason", "analysis-api-platform-interface"})
public final class KotlinReadActionConfinementLifetimeToken
extends KaLifetimeToken {
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KaAnalysisPermissionChecker permissionChecker;
    @NotNull
    private final KaLifetimeTracker lifetimeTracker;

    public KotlinReadActionConfinementLifetimeToken(@NotNull Project project, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        this.modificationTracker = modificationTracker;
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.permissionChecker = KaAnalysisPermissionChecker.Companion.getInstance(project);
        this.lifetimeTracker = KaLifetimeTracker.Companion.getInstance(project);
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    @KaCachedService
    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    @Override
    @NotNull
    public KaLifetimeTokenFactory getFactory() {
        return KotlinReadActionConfinementLifetimeTokenFactory.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation.";
        }
        throw new IllegalStateException("Cannot get an invalidation reason for a valid lifetime token.".toString());
    }

    @Override
    public boolean isAccessible() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return false;
        }
        if (!this.permissionChecker.isAnalysisAllowed()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lifetimeTracker.getCurrentToken(), (Object)this);
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return "Called outside a read action.";
        }
        if (!this.permissionChecker.isAnalysisAllowed()) {
            return this.permissionChecker.getRejectionReason();
        }
        KaLifetimeToken currentToken = this.lifetimeTracker.getCurrentToken();
        if (currentToken == null) {
            return "Called outside an `analyze` context.";
        }
        if (!Intrinsics.areEqual((Object)currentToken, (Object)this)) {
            return "Using a lifetime owner from an old `analyze` context.";
        }
        throw new IllegalStateException("Cannot get an inaccessibility reason for a lifetime token when it's accessible.".toString());
    }
}

