/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.KaptPaths;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoaderKt;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "Ljava/io/Closeable;", "paths", "Lorg/jetbrains/kotlin/kapt3/base/KaptPaths;", "annotationProcessorFqNames", "", "", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "(Lorg/jetbrains/kotlin/kapt3/base/KaptPaths;Ljava/util/List;Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;)V", "annotationProcessingClassLoader", "Ljava/net/URLClassLoader;", "close", "", "loadProcessors", "Ljavax/annotation/processing/Processor;", "parentClassLoader", "Ljava/lang/ClassLoader;", "tryLoadProcessor", "fqName", "classLoader", "kotlin-annotation-processing-base"})
public final class ProcessorLoader
implements Closeable {
    private URLClassLoader annotationProcessingClassLoader;
    private final KaptPaths paths;
    private final List<String> annotationProcessorFqNames;
    private final KaptLogger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Processor> loadProcessors(@NotNull ClassLoader parentClassLoader) {
        List processors;
        List list;
        Object $receiver$iv;
        URLClassLoader classLoader;
        Collection<URL> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)parentClassLoader, (String)"parentClassLoader");
        ProcessorLoaderKt.access$clearJarURLCache();
        List classpath = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.paths.getAnnotationProcessingClasspath(), (Iterable)this.paths.getCompileClasspath()));
        Iterable iterable = $receiver$iv2 = (Iterable)classpath;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv2 = collection;
        Iterable thisCollection$iv = $receiver$iv2;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = uRLArray;
        ClassLoader classLoader2 = parentClassLoader;
        URL[] uRLArray2 = (URL[])collection;
        this.annotationProcessingClassLoader = classLoader = new URLClassLoader(uRLArray2, classLoader2);
        thisCollection$iv = this.annotationProcessorFqNames;
        if (!thisCollection$iv.isEmpty()) {
            void $receiver$iv$iv2;
            this.logger.info("Annotation processor class names are set, skip AP discovery");
            $receiver$iv = this.annotationProcessorFqNames;
            Iterable $i$f$toTypedArray = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Processor processor;
                Object element$iv$iv = element$iv$iv$iv;
                String it = (String)element$iv$iv;
                if (this.tryLoadProcessor(it, classLoader) == null) continue;
                Processor it$iv$iv = processor;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            this.logger.info("Need to discovery annotation processors in the AP classpath");
            ServiceLoader<Processor> serviceLoader = ServiceLoader.load(Processor.class, classLoader);
            Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(Proce\u2026:class.java, classLoader)");
            list = processors = CollectionsKt.toList((Iterable)serviceLoader);
        }
        if (processors.isEmpty()) {
            this.logger.info("No annotation processors available, aborting");
        } else {
            $receiver$iv = this.logger;
            if ($receiver$iv.isVerbose()) {
                Object object = $receiver$iv;
                String string = "Annotation processors: " + CollectionsKt.joinToString$default((Iterable)processors, null, null, null, (int)0, null, (Function1)loadProcessors.1.1.INSTANCE, (int)31, null);
                object.info(string);
            }
        }
        return processors;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List loadProcessors$default(ProcessorLoader processorLoader, ClassLoader classLoader, int n, Object object) {
        if ((n & 1) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
            classLoader = classLoader2;
        }
        return processorLoader.loadProcessors(classLoader);
    }

    private final Processor tryLoadProcessor(String fqName, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fqName, true, classLoader);
        }
        catch (Throwable e) {
            this.logger.warn("Can't find annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
        Class<?> annotationProcessorClass = clazz;
        try {
            Object annotationProcessorInstance = annotationProcessorClass.newInstance();
            if (!(annotationProcessorInstance instanceof Processor)) {
                this.logger.warn(fqName + " is not an instance of 'Processor'");
                return null;
            }
            return (Processor)annotationProcessorInstance;
        }
        catch (Throwable e) {
            this.logger.warn("Can't load annotation processor class " + fqName + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        URLClassLoader uRLClassLoader = this.annotationProcessingClassLoader;
        if (uRLClassLoader != null) {
            uRLClassLoader.close();
        }
        ProcessorLoaderKt.access$clearJarURLCache();
    }

    public ProcessorLoader(@NotNull KaptPaths paths, @NotNull List<String> annotationProcessorFqNames, @NotNull KaptLogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull(annotationProcessorFqNames, (String)"annotationProcessorFqNames");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.paths = paths;
        this.annotationProcessorFqNames = annotationProcessorFqNames;
        this.logger = logger;
    }
}

