/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.FirDesignationState;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H$J\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/ContextByDesignationCollector;", "C", "", "designation", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;)V", "context", "Ljava/lang/Object;", "designationState", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/FirDesignationState;", "getCurrentContext", "()Ljava/lang/Object;", "goToNestedDeclaration", "", "target", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "getCollectedContext", "nextStep", "low-level-api-fir"})
public abstract class ContextByDesignationCollector<C> {
    @NotNull
    private final FirDesignation designation;
    @Nullable
    private C context;
    @NotNull
    private final FirDesignationState designationState;

    public ContextByDesignationCollector(@NotNull FirDesignation designation) {
        Intrinsics.checkNotNullParameter((Object)designation, (String)"designation");
        this.designation = designation;
        this.designationState = new FirDesignationState(this.designation);
    }

    @NotNull
    protected abstract C getCurrentContext();

    protected abstract void goToNestedDeclaration(@NotNull FirElementWithResolveState var1);

    @NotNull
    public final C getCollectedContext() {
        C c = this.context;
        if (c == null) {
            throw new IllegalStateException("Context is not collected yet".toString());
        }
        return c;
    }

    public final void nextStep() {
        if (this.designationState.canGoNext()) {
            this.designationState.goNext();
            if (Intrinsics.areEqual((Object)this.designationState.getCurrentDeclarationIfPresent(), (Object)this.designation.getTarget())) {
                if (!(this.context == null)) {
                    throw new IllegalStateException("Check failed.");
                }
                this.context = this.getCurrentContext();
            }
            this.goToNestedDeclaration(this.designationState.getCurrentDeclaration());
        } else if (Intrinsics.areEqual((Object)this.designationState.getCurrentDeclarationIfPresent(), (Object)this.designation.getTarget())) {
            this.designationState.goToInnerDeclaration();
        }
    }
}

